/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractHibernatePersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.LocationReportDataType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.Query;

public abstract class AbstractReadableReportsPersistenceManager
extends AbstractHibernatePersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected HTResponseType responseType = new HTResponseType();
    public static final GregorianCalendar CENSUS_EARLIEST_START_DATE = new GregorianCalendar(2005, 8, 10);
    public static final long MILLIS_IN_ONE_DAY = 86400000L;

    @Override
    public abstract HTResponseType performReadReportAggregate(HTReportFilterType var1) throws PersistenceException;

    protected Integer getSurveyCount(List<? extends LocationReportDataType> results) {
        Integer count = null;
        if (results != null) {
            count = 0;
            for (LocationReportDataType locationReportDataType : results) {
                count = count + locationReportDataType.getRecordCount();
            }
        }
        return count;
    }

    protected XMLGregorianCalendar dateToXMLGregorianCalendar(int year, int month, int day) {
        XMLGregorianCalendar newXMLGregorianCalendar = null;
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            newXMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendarDate(year, month, day, 0);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return newXMLGregorianCalendar;
    }

    protected XMLGregorianCalendar gregorianCalendarToXMLGregorianCalendar(GregorianCalendar aDateTime) {
        XMLGregorianCalendar newXMLGregorianCalendar = null;
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            newXMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(aDateTime);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return newXMLGregorianCalendar;
    }

    protected java.sql.Date formatDate(XMLGregorianCalendar aDate) {
        java.sql.Date sqlDate = null;
        if (aDate != null) {
            GregorianCalendar convertDate = aDate.toGregorianCalendar();
            Date utilDate = convertDate.getTime();
            sqlDate = new java.sql.Date(utilDate.getTime());
        }
        return sqlDate;
    }

    protected List queryForReportData(Query aQuery) {
        List results = null;
        try {
            results = aQuery.list();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Result size: " + results.size()));
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
            throw e;
        }
        return results;
    }
}

