/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.jaxb;

import gov.va.med.cds.ars.jaxb.JaxbHelper;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.SAXException;

public class PooledJaxbHelper
implements JaxbHelper {
    private static final String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private static Map<String, Schema> schemaMap = new ConcurrentHashMap<String, Schema>();
    private static Map<Class, JAXBContext> jaxbContextMap = new ConcurrentHashMap<Class, JAXBContext>();
    private static GenericKeyedObjectPool<PoolKey, Marshaller> marshallerPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new MarshallerFactory(), (GenericKeyedObjectPoolConfig)new CustomPoolConfig());
    private static GenericKeyedObjectPool<PoolKey, Unmarshaller> unmarshallerPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new UnmarshallerFactory(), (GenericKeyedObjectPoolConfig)new CustomPoolConfig());

    private static JAXBContext getJAXBContext(Class aClass) throws JAXBException {
        JAXBContext jaxbContext = jaxbContextMap.get(aClass);
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{aClass});
            jaxbContextMap.put(aClass, jaxbContext);
        }
        return jaxbContext;
    }

    private static Schema getSchema(PoolKey poolKey) throws JAXBException, SAXException, IOException {
        Schema schema = schemaMap.get(poolKey.getSchemaLocation());
        if (schema == null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI);
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource resource = resolver.getResource(poolKey.getSchemaLocation());
            URL fileURL = resource.getURL();
            schema = schemaFactory.newSchema(fileURL);
            schemaMap.put(poolKey.getSchemaLocation(), schema);
        }
        return schema;
    }

    @Override
    public <T> String marshal(T instance, @Nullable String schemaLocation) throws Exception {
        StringWriter result = new StringWriter();
        PoolKey poolKey = new PoolKey(instance.getClass(), schemaLocation);
        Marshaller marshaller = (Marshaller)marshallerPool.borrowObject((Object)poolKey);
        try {
            marshaller.marshal(instance, (Writer)result);
            marshallerPool.returnObject((Object)poolKey, (Object)marshaller);
            return result.toString();
        }
        catch (Exception e) {
            marshallerPool.invalidateObject((Object)poolKey, (Object)marshaller);
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T unmarshal(String xml, Class<T> clazz, @Nullable String schemaLocation) throws Exception {
        PoolKey poolKey = new PoolKey(clazz, schemaLocation);
        Unmarshaller unmarshaller = (Unmarshaller)unmarshallerPool.borrowObject((Object)poolKey);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        ByteArrayInputStream xmlStream = new ByteArrayInputStream(xml.getBytes());
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(xmlStream);
        try {
            Object result = unmarshaller.unmarshal(xmlStreamReader);
            unmarshallerPool.returnObject((Object)poolKey, (Object)unmarshaller);
            return (T)result;
        }
        catch (Exception e) {
            unmarshallerPool.invalidateObject((Object)poolKey, (Object)unmarshaller);
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        String SCHEMA_LOCATION = "classpath:main/resources/HTReportFilter.xsd";
        String filterInstance = StreamUtil.resourceToString((Resource)new FileSystemResource("./src/test/resources/filters/DMPFilter"));
        PooledJaxbHelper pooledJaxbHelper = new PooledJaxbHelper();
        HTReportFilterType htFilter = pooledJaxbHelper.unmarshal(filterInstance, HTReportFilterType.class, SCHEMA_LOCATION);
        String sampleXml = pooledJaxbHelper.marshal(htFilter, SCHEMA_LOCATION);
        System.out.println("XML: " + sampleXml);
    }

    private static class CustomPoolConfig
    extends GenericKeyedObjectPoolConfig {
        private CustomPoolConfig() {
            this.setMaxIdlePerKey(3);
            this.setMaxTotal(100);
            this.setMinIdlePerKey(1);
            this.setBlockWhenExhausted(true);
            this.setTimeBetweenEvictionRunsMillis(600000L);
            this.setNumTestsPerEvictionRun(50);
            this.setMinEvictableIdleTimeMillis(300000L);
        }
    }

    private static class UnmarshallerFactory
    extends BaseKeyedPooledObjectFactory<PoolKey, Unmarshaller> {
        private UnmarshallerFactory() {
        }

        public Unmarshaller create(PoolKey key) throws Exception {
            JAXBContext jaxbContext = PooledJaxbHelper.getJAXBContext(key.getClazz());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            if (key.getSchemaLocation() != null) {
                Schema schema = PooledJaxbHelper.getSchema(key);
                unmarshaller.setSchema(schema);
            }
            return unmarshaller;
        }

        public PooledObject<Unmarshaller> wrap(Unmarshaller unmarshaller) {
            return new DefaultPooledObject((Object)unmarshaller);
        }

        public PooledObject<Unmarshaller> makeObject(PoolKey key) throws Exception {
            Unmarshaller unmarshaller = this.create(key);
            return this.wrap(unmarshaller);
        }
    }

    private static class MarshallerFactory
    extends BaseKeyedPooledObjectFactory<PoolKey, Marshaller> {
        static final String NAMESPACE_PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";

        private MarshallerFactory() {
        }

        public Marshaller create(PoolKey key) throws Exception {
            JAXBContext jaxbContext = PooledJaxbHelper.getJAXBContext(key.getClazz());
            Marshaller marshaller = jaxbContext.createMarshaller();
            if (key.getSchemaLocation() != null) {
                Schema schema = PooledJaxbHelper.getSchema(key);
                marshaller.setSchema(schema);
            }
            return marshaller;
        }

        public PooledObject<Marshaller> wrap(Marshaller marshaller) {
            return new DefaultPooledObject((Object)marshaller);
        }

        public PooledObject<Marshaller> makeObject(PoolKey key) throws Exception {
            Marshaller marshaller = this.create(key);
            return this.wrap(marshaller);
        }
    }

    private static class PoolKey {
        private Class clazz;
        private String schemaLocation;

        private PoolKey(Class aClass, @Nullable String schemaLocation) {
            this.clazz = aClass;
            this.schemaLocation = schemaLocation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PoolKey poolKey = (PoolKey)o;
            return this.clazz.equals(poolKey.clazz) && !(this.schemaLocation == null ? poolKey.schemaLocation != null : !this.schemaLocation.equals(poolKey.schemaLocation));
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + (this.schemaLocation != null ? this.schemaLocation.hashCode() : 0);
            return result;
        }

        public Class getClazz() {
            return this.clazz;
        }

        @Nullable
        public String getSchemaLocation() {
            return this.schemaLocation;
        }
    }
}

