/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.exceptionframework;

import gov.va.med.cds.ars.exceptionframework.BaseExceptionHandler;
import gov.va.med.cds.ars.exceptionframework.ExceptionHandlerInterface;
import gov.va.med.cds.exceptionframework.ExceptionLoggerInterface;
import gov.va.med.cds.util.LogMessageUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExceptionHandlerFactory {
    private static ExceptionHandlerInterface exceptionHandler = null;
    private static ExceptionLoggerInterface guaranteedLogger = null;
    private static Log logger = LogFactory.getLog(ExceptionHandlerFactory.class);
    private static final String APPLICATION_NAME = "ARS";

    public ExceptionHandlerInterface create() {
        if (exceptionHandler == null) {
            if (guaranteedLogger == null && logger.isWarnEnabled()) {
                logger.warn((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)"The guaranteed logger is null and must be set. Please check your configuration."));
            }
            BaseExceptionHandler workingExceptionHandler = new BaseExceptionHandler();
            workingExceptionHandler.setGuaranteedLogger(guaranteedLogger);
            exceptionHandler = workingExceptionHandler;
        }
        return exceptionHandler;
    }

    public void setGuaranteedLogger(ExceptionLoggerInterface elogger) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)("Setting the guaranteed logger: " + elogger)));
        }
        guaranteedLogger = elogger;
    }
}

