/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.xml;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.testharness.AbstractLoggingTest;
import gov.va.med.cds.testharness.xml.XmlComparator;
import gov.va.med.cds.testharness.xml.XmlCompareException;
import gov.va.med.cds.util.StreamUtil;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

@RunWith(value=SuiteAwareRunner.class)
public class XmlComparatorTest
extends AbstractLoggingTest {
    private XmlComparator xmlComparator = new XmlComparator();
    private static DefaultResourceLoader resourceLoader;

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testSimpleRootCompareFail() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot><first></first></myRoot>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><notMyRoot><first></first></notMyRoot>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testSimpleRootCompareSucceed() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot></myRoot>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot></myRoot>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testSimpleRootValueCompareFail() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot>something</myRoot>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot>not something</myRoot>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testSimpleRootAttributesValueCompareFail() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot first=\"1\" second=\"2\"></myRoot>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot first=\"1\" second=\"3\"></myRoot>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testSimpleRootAttributesNameCompareFail() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot first=\"1\" second=\"2\"></myRoot>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot first=\"1\" other=\"2\"></myRoot>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testSimpleRootAttributesCountMismatchCompareFail() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot first=\"1\" second=\"2\"></myRoot>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot first=\"1\" second=\"2\" third=\"3\"></myRoot>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testSimpleRootAttributesOrderCompare() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot third=\"3\" first=\"1\" second=\"2\"><first><second></second></first></myRoot>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot first=\"1\" second=\"2\" third=\"3\"><first><second></second></first></myRoot>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml, "test");
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testSimpleRootAttributesOrderValueCompare() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot third=\"3\" first=\"1\" second=\"2\">This is Correct</myRoot>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myRoot first=\"1\" second=\"2\" third=\"3\">This is Correct</myRoot>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testSimpleNameCompare() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><first>firstData</first></root>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><second>firstData</second></root>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testListItemValueFailure() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root first=\"1\" second=\"2\"><item a=\"food\" b=\"medicine\">firstItem</item><item b=\"medicine\" a=\"food\">secondtem</item></root>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root first=\"1\" second=\"2\"><item a=\"food\" b=\"medicine\">firstItem</item><item b=\"medicine\" a=\"food\">mismatch item</item></root>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testListItemOutOfOrder() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root first=\"1\" second=\"2\"><item a=\"food\" b=\"medicine\">firstItem</item><item b=\"medicine\" a=\"food\">secondtem</item></root>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root second=\"2\" first=\"1\"><item b=\"medicine\" a=\"food\">secondtem</item><item b=\"medicine\" a=\"food\">firstItem</item></root>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testSequence() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root first=\"1\" second=\"2\"><allergy attr1=\"something1\" attr2=\"something2\">allergyvalue</allergy><vital v1=\"bp\" v2=\"temp\">vitalvalue</vital></root>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root first=\"1\" second=\"2\"><allergy attr1=\"something1\" attr2=\"something2\">allergyvalue</allergy><vital v1=\"bp\" v2=\"temp\">vitalvalue</vital></root>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testSequenceOutofOrder() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root first=\"1\" second=\"2\"><allergy attr1=\"something1\" attr2=\"something2\">allergyvalue</allergy><vital v1=\"bp\" v2=\"temp\">vitalvalue</vital></root>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root first=\"1\" second=\"2\"><vital v2=\"temp\" v1=\"bp\">vitalvalue</vital><allergy attr2=\"something2\" attr1=\"something1\">allergyvalue</allergy></root>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testSequenceOutofOrderMismatchValue() throws XmlCompareException {
        String sourceXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root first=\"1\" second=\"2\"><allergy attr1=\"something1\" attr2=\"something2\">allergyvalue</allergy><vital v1=\"bp\" v2=\"temp\">vitalvalue</vital></root>";
        String controlXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root first=\"1\" second=\"2\"><vital v2=\"temp\" v1=\"bp\">vitalvalue</vital><allergy attr2=\"something2\" attr1=\"something1\">allergyvalue DIFFERENT</allergy></root>";
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testXmlSimpleFileCompareFail() throws XmlCompareException, IOException {
        Resource resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/testSourceDifferent.xml");
        String sourceXml = StreamUtil.resourceToString((Resource)resource);
        resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/testControl.xml");
        String controlXml = StreamUtil.resourceToString((Resource)resource);
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testXmlSimpleFileCompare() throws XmlCompareException, IOException {
        Resource resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/AllergyAppend.xml");
        String sourceXml = StreamUtil.resourceToString((Resource)resource);
        resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/AllergyAppendSame.xml");
        String controlXml = StreamUtil.resourceToString((Resource)resource);
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testXmlFileBadTransformAndCompare() throws XmlCompareException, IOException, TransformerException {
        ArrayList<String> excludes = new ArrayList<String>();
        Resource resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/allergyRead00009Result.xml");
        String sourceXml = StreamUtil.resourceToString((Resource)resource);
        resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/allergyRead00009Control.xml");
        String controlXml = StreamUtil.resourceToString((Resource)resource);
        XmlComparator.assertXMLSimilar(sourceXml, controlXml, excludes);
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testXmlFileTransformAndCompare() throws XmlCompareException, IOException, TransformerException {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("/clinicaldata:clinicalData/intoleranceCondition/reactionObservationEvent/reactionOnsetHistory/@changedDate");
        Resource resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/allergyRead00009Result.xml");
        String sourceXml = StreamUtil.resourceToString((Resource)resource);
        resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/allergyRead00009Control.xml");
        String controlXml = StreamUtil.resourceToString((Resource)resource);
        XmlComparator.assertXMLSimilar(sourceXml, controlXml, excludes);
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testRemoveChangedDateAndCompare() throws XmlCompareException, IOException, TransformerException {
        ArrayList<String> excludes = new ArrayList<String>();
        Resource resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/testSource2.xml");
        String sourceXml = StreamUtil.resourceToString((Resource)resource);
        resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/testControl2.xml");
        String controlXml = StreamUtil.resourceToString((Resource)resource);
        XmlComparator.assertXMLSimilar(sourceXml, controlXml, excludes);
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testRemoveErrorIdAndCompareSame() throws XmlCompareException, IOException, TransformerException {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("/clinicaldata:clinicalData/errors/fatalError/errorId");
        Resource resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/testSourceErrorSectionSame.xml");
        String sourceXml = StreamUtil.resourceToString((Resource)resource);
        resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/testControlErrorSection.xml");
        String controlXml = StreamUtil.resourceToString((Resource)resource);
        XmlComparator.assertXMLSimilar(sourceXml, controlXml, excludes);
    }

    @Test(expected=XmlCompareException.class)
    @Suite(groups={"checkintest"})
    public void testRemoveErrorIdAndCompareDifferent() throws XmlCompareException, IOException, TransformerException {
        ArrayList<String> excludes = new ArrayList<String>();
        Resource resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/testSourceErrorSectionDifferent.xml");
        String sourceXml = StreamUtil.resourceToString((Resource)resource);
        resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/testControlErrorSection.xml");
        String controlXml = StreamUtil.resourceToString((Resource)resource);
        XmlComparator.assertXMLSimilar(sourceXml, controlXml, excludes);
    }

    @Test
    @Suite(groups={"checkintest"})
    public void testNoTransformationCompare() throws XmlCompareException, IOException, TransformerException {
        Resource resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/allergyConcurrentReadSource.xml");
        String sourceXml = StreamUtil.resourceToString((Resource)resource);
        resource = resourceLoader.getResource("classpath:gov/va/med/cds/testharness/xml/allergyConcurrentReadControl.xml");
        String controlXml = StreamUtil.resourceToString((Resource)resource);
        XmlComparator.assertXMLSimilar(sourceXml, controlXml);
    }

    @BeforeClass
    public static void beforeXmlComparatorTestClassSetUp() throws Exception {
        resourceLoader = new DefaultResourceLoader();
    }

    @AfterClass
    public static void afterXmlComparatorTestClassTearDown() throws Exception {
        resourceLoader = null;
    }
}

