/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.xml;

import gov.va.med.cds.testharness.xml.XmlCompareException;
import gov.va.med.cds.util.LogMessageUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class XmlComparator {
    private static Log logger = LogFactory.getLog(XmlComparator.class);
    private Queue<String> elementNotFound = new LinkedList<String>();
    private List<String> excludesXPaths;
    private static final String APPLICATION_NAME = "CDS";
    boolean detachedNode;

    private void compareXmlDocuments(Document sourceDocument, Document controlDocument) throws XmlCompareException {
        Element sourceElement = sourceDocument.getRootElement();
        Element controlElement = controlDocument.getRootElement();
        sourceElement = this.removeEmptyElementsFromXml(sourceElement);
        controlElement = this.removeEmptyElementsFromXml(controlElement);
        this.iterateTree(sourceElement, controlElement);
    }

    private void compareXmlDocumentsAfterRemovingAllEmptyElements(Document sourceDocument, Document controlDocument) throws XmlCompareException {
        Element sourceElement = sourceDocument.getRootElement();
        Element controlElement = controlDocument.getRootElement();
        this.detachedNode = true;
        while (this.detachedNode) {
            this.detachedNode = false;
            sourceElement = this.removeEmptyElementsFromXml(sourceElement);
        }
        this.detachedNode = true;
        while (this.detachedNode) {
            this.detachedNode = false;
            controlElement = this.removeEmptyElementsFromXml(controlElement);
        }
        this.iterateTree(sourceElement, controlElement);
    }

    private void iterateTree(Element sourceElement, Element controlElement) throws XmlCompareException {
        if (this.excludesXPaths == null || this.excludesXPaths != null && !this.excludesXPaths.contains(sourceElement.getPath())) {
            this.compareElementName(sourceElement, controlElement);
            this.compareElementValue(sourceElement, controlElement);
            this.compareAttributeLists(sourceElement.getUniquePath(), sourceElement.attributes(), controlElement.attributes());
            this.compareChildCount(sourceElement, controlElement);
            LinkedList<Element> sourceSubElementsList = new LinkedList<Element>();
            LinkedList<Element> controlSubElementsList = new LinkedList<Element>();
            Iterator input = sourceElement.elementIterator();
            while (input.hasNext()) {
                Element ipElement = (Element)input.next();
                sourceSubElementsList.add(ipElement);
            }
            Iterator output = controlElement.elementIterator();
            while (output.hasNext()) {
                Element opElement = (Element)output.next();
                controlSubElementsList.add(opElement);
            }
            Iterator sourceIterator = sourceSubElementsList.iterator();
            while (sourceIterator.hasNext()) {
                boolean foundAMatch = false;
                Element sourceSubElement = (Element)sourceIterator.next();
                List<Element> controlWithSameNameElementList = this.getElementsWithSameName(sourceSubElement.getQualifiedName(), controlSubElementsList);
                if (controlWithSameNameElementList.size() == 0) {
                    String msg = "A source element : " + sourceElement.getUniquePath() + " could not be found in the control xml.";
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)msg));
                    }
                    throw new XmlCompareException(msg);
                }
                Iterator<Element> controlIterator = controlWithSameNameElementList.iterator();
                while (controlIterator.hasNext()) {
                    Element controlSubElement = controlIterator.next();
                    try {
                        this.iterateTree(sourceSubElement, controlSubElement);
                        foundAMatch = true;
                        sourceSubElementsList.remove(sourceSubElement);
                        controlWithSameNameElementList.remove(controlSubElement);
                        sourceIterator = sourceSubElementsList.iterator();
                        controlIterator = controlWithSameNameElementList.iterator();
                        break;
                    }
                    catch (XmlCompareException e) {
                        this.elementNotFound.offer(e.getMessage());
                    }
                }
                if (foundAMatch) continue;
                throw new XmlCompareException(this.elementNotFound.remove());
            }
        }
    }

    private List<Element> getElementsWithSameName(String qualifiedName, List<Element> controlSubElementsList) {
        LinkedList<Element> result = new LinkedList<Element>();
        for (Element controlSubElement : controlSubElementsList) {
            if (!qualifiedName.equals(controlSubElement.getQualifiedName())) continue;
            result.add(controlSubElement);
        }
        return result;
    }

    private void compareChildCount(Element sourceElement, Element controlElement) throws XmlCompareException {
        if (sourceElement.elements().size() != controlElement.elements().size()) {
            String msg = "The child counts were not equal at: " + sourceElement.getUniquePath() + " source was: " + sourceElement.elements().size() + " control was: " + controlElement.elements().size();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)msg));
            }
            throw new XmlCompareException(msg);
        }
    }

    private void compareElementValue(Element sourceElement, Element controlElement) throws XmlCompareException {
        if (!sourceElement.getTextTrim().equals(controlElement.getTextTrim())) {
            String msg = "The element values were not equal at: " + sourceElement.getUniquePath() + " source was: " + sourceElement.getText() + " control was: " + controlElement.getText();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)msg));
            }
            throw new XmlCompareException(msg);
        }
    }

    private void compareElementName(Element sourceElement, Element controlElement) throws XmlCompareException {
        if (!sourceElement.getQualifiedName().equals(controlElement.getQualifiedName())) {
            String msg = "The element names were not equal at: " + sourceElement.getUniquePath() + " source was: " + sourceElement.getQualifiedName() + " control was: " + controlElement.getQualifiedName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)msg));
            }
            throw new XmlCompareException(msg);
        }
    }

    private Iterator getAttListIterator(List attributeList) {
        Iterator iterator = attributeList.iterator();
        return iterator;
    }

    private boolean compareAttributeLists(String parentPath, List sourceList, List controlList) throws XmlCompareException {
        if (sourceList != null && controlList == null) {
            String msg = "for node: " + parentPath + " the source attribute list is not null, but the contol attribute list is null.";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)msg));
            }
            throw new XmlCompareException(msg);
        }
        if (sourceList == null && controlList != null) {
            String msg = "for node: " + parentPath + " the source attribute list is null, but the contol attribute list is not null.";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)msg));
            }
            throw new XmlCompareException(msg);
        }
        sourceList = this.removeExcludedAttributes(sourceList);
        controlList = this.removeExcludedAttributes(controlList);
        if (sourceList.size() != controlList.size()) {
            String msg = "for node: " + parentPath + " the source attribute list length was: " + sourceList.size() + ", but the contol attribute list length was: " + controlList.size();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)msg));
            }
            throw new XmlCompareException(msg);
        }
        this.compareSourceAttributeListToControlAttributeList(sourceList, controlList);
        return true;
    }

    private List removeExcludedAttributes(List attributeList) {
        ArrayList prunedAttributeList = new ArrayList(attributeList);
        if (this.excludesXPaths == null) {
            return prunedAttributeList;
        }
        Attribute attribute2 = null;
        for (Attribute attribute2 : attributeList) {
            if (!this.excludesXPaths.contains(attribute2.getPath())) continue;
            prunedAttributeList.remove(attribute2);
        }
        return prunedAttributeList;
    }

    private void compareSourceAttributeListToControlAttributeList(List source, List control) throws XmlCompareException {
        LinkedList sourceList = new LinkedList(source);
        LinkedList controlList = new LinkedList(control);
        Iterator sourceListIterator = sourceList.iterator();
        Iterator targetListIterator = controlList.iterator();
        boolean attListsEqual = false;
        while (sourceListIterator.hasNext()) {
            Attribute sourceAttribute = (Attribute)sourceListIterator.next();
            attListsEqual = false;
            while (targetListIterator.hasNext()) {
                Attribute targetAttribute = (Attribute)targetListIterator.next();
                if (!sourceAttribute.getText().equals(targetAttribute.getText()) || !sourceAttribute.getName().equals(targetAttribute.getName())) continue;
                attListsEqual = true;
                controlList.remove(targetAttribute);
                sourceList.remove(sourceAttribute);
                targetListIterator = this.getAttListIterator(controlList);
                sourceListIterator = this.getAttListIterator(sourceList);
                break;
            }
            if (attListsEqual) continue;
            String msg = "A match could not be found in the contol xml for source attribute " + sourceAttribute.getUniquePath() + "=\"" + sourceAttribute.getText() + "\"";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)msg));
            }
            throw new XmlCompareException(msg);
        }
    }

    public static void assertXMLSimilar(String sourceXml, String controlXml) throws XmlCompareException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)("Control: " + controlXml)));
            logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)("Source: " + sourceXml)));
        }
        XmlComparator xmlComparator = new XmlComparator();
        xmlComparator.compareXmlDocuments(xmlComparator.xmlStringXmlDocument(sourceXml), xmlComparator.xmlStringXmlDocument(controlXml));
    }

    public static void assertXMLSimilar(String sourceXml, String controlXml, String preProcess) throws XmlCompareException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)("Control: " + controlXml)));
            logger.debug((Object)LogMessageUtil.buildMessage(null, null, (String)APPLICATION_NAME, (String)("Source: " + sourceXml)));
        }
        XmlComparator xmlComparator = new XmlComparator();
        xmlComparator.compareXmlDocuments(xmlComparator.xmlStringXmlDocument(sourceXml), xmlComparator.xmlStringXmlDocument(controlXml));
    }

    private Document xmlStringXmlDocument(String xml) throws XmlCompareException {
        Document document;
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            throw new XmlCompareException("Problem with parsing the xml test source:\n" + xml, e);
        }
        return document;
    }

    public static void assertXMLSimilar(String sourceXml, String controlXml, List<String> excludes) throws XmlCompareException {
        XmlComparator xmlComparator = new XmlComparator();
        Document sourceDocument = xmlComparator.xmlStringXmlDocument(sourceXml);
        Document controlDocument = xmlComparator.xmlStringXmlDocument(controlXml);
        xmlComparator.setExcludesXPaths(excludes);
        xmlComparator.compareXmlDocuments(sourceDocument, controlDocument);
    }

    public static void assertXMLSimilarAfterRemovingAllEmptyElements(String sourceXml, String controlXml, List<String> excludes) throws XmlCompareException {
        XmlComparator xmlComparator = new XmlComparator();
        Document sourceDocument = xmlComparator.xmlStringXmlDocument(sourceXml);
        Document controlDocument = xmlComparator.xmlStringXmlDocument(controlXml);
        xmlComparator.setExcludesXPaths(excludes);
        xmlComparator.compareXmlDocumentsAfterRemovingAllEmptyElements(sourceDocument, controlDocument);
    }

    private void setExcludesXPaths(List<String> excludesXPaths) {
        this.excludesXPaths = excludesXPaths;
    }

    private Element removeEmptyElementsFromXml(Element source) {
        int size = source.nodeCount();
        for (int counter = 0; counter < size; ++counter) {
            Node node = source.node(counter);
            if (!(node instanceof Element)) continue;
            Element nodeElement = (Element)node;
            if (!node.hasContent() && nodeElement.attributeCount() == 0) {
                node.detach();
                size = source.nodeCount();
                --counter;
                this.detachedNode = true;
                continue;
            }
            this.removeEmptyElementsFromXml((Element)node);
        }
        return source;
    }
}

