/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.xml;

import gov.va.med.cds.testharness.util.TemplateJarHelper;
import gov.va.med.cds.testharness.xml.SchemaHelperException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SchemaHelper {
    private static final Namespace XSD_NAMESPACE = Namespace.get((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    private static final QName XSD_ELEMENT = QName.get((String)"element", (Namespace)XSD_NAMESPACE);
    private static final QName XSD_SIMPLETYPE = QName.get((String)"simpleType", (Namespace)XSD_NAMESPACE);
    private static final QName XSD_COMPLEXTYPE = QName.get((String)"complexType", (Namespace)XSD_NAMESPACE);
    private static final QName XSD_SEQUENCE = QName.get((String)"sequence", (Namespace)XSD_NAMESPACE);
    private static final QName XSD_ALL = QName.get((String)"all", (Namespace)XSD_NAMESPACE);
    private static final QName XSD_IMPORT = QName.get((String)"import", (Namespace)XSD_NAMESPACE);
    private static final QName XSD_EXTENSION = QName.get((String)"extension", (Namespace)XSD_NAMESPACE);
    private static final QName XSD_COMPLEXCONTENT = QName.get((String)"complexContent", (Namespace)XSD_NAMESPACE);
    private Document schemaDocument;
    private List<String> imported = new ArrayList<String>();

    public static SchemaHelper createSchemaHelper(String systemId) throws SchemaHelperException {
        SchemaHelper schemaHelper = new SchemaHelper(systemId);
        return schemaHelper;
    }

    public static SchemaHelper createSchemaHelper(String templateCacheDir, String templateId) throws SchemaHelperException {
        try {
            TemplateJarHelper.unjar(templateCacheDir, templateId);
            String systemId = String.format("%s/%s/template/%s.xsd", templateCacheDir, templateId, templateId);
            SchemaHelper schemaHelper = new SchemaHelper(systemId);
            return schemaHelper;
        }
        catch (Exception e) {
            throw new SchemaHelperException("Error creating schema helper.", e);
        }
    }

    private SchemaHelper(String systemId) throws SchemaHelperException {
        try {
            SAXReader reader = new SAXReader();
            this.schemaDocument = reader.read(systemId);
            this.internalBuild(this.schemaDocument);
        }
        catch (DocumentException e) {
            throw new SchemaHelperException("An error occurred reading the document.", e);
        }
    }

    private Element elementToComplexTypeResolution(Element xsdElement) {
        String type = xsdElement.attributeValue("type").split(":")[1];
        return (Element)this.schemaDocument.getRootElement().selectSingleNode(String.format("xsd:complexType[@name='%s']", type));
    }

    private Element locateXsdElement(Element parent, String elementName) {
        Element element = (Element)parent.selectSingleNode(String.format("xsd:element[@name='%s'] | xsd:choice/xsd:element[@name='%s']", elementName, elementName));
        if (this.isComplexType(element)) {
            element = this.elementToComplexTypeResolution(element);
        }
        return element;
    }

    private boolean isComplexType(Element element) {
        String type = null;
        if (element != null) {
            type = element.attributeValue("type");
        }
        return element != null && type != null && !type.startsWith("xsd:");
    }

    public boolean isPathValidForSchema(String path) {
        String[] split = this.splitPath(path);
        Element clinicalDataComplexType = this.locateXsdElement(this.schemaDocument.getRootElement(), split[0]);
        if (clinicalDataComplexType == null) {
            return false;
        }
        if (clinicalDataComplexType != null && split[1] == null) {
            return true;
        }
        return this.isPathValidForSchema(clinicalDataComplexType, split[1]);
    }

    public Document getSchemaDocument() {
        return this.schemaDocument;
    }

    private boolean isPathValidForSchema(Element current, String path) {
        Element newCurrent = null;
        String[] split = this.splitPath(path);
        List children = current.elements();
        Element e = (Element)children.get(0);
        String elementName = e.getName();
        if (children.size() == 1 && !XSD_ELEMENT.getName().equals(elementName)) {
            if (XSD_COMPLEXTYPE.getName().equals(elementName) || XSD_SEQUENCE.getName().equals(elementName) || XSD_ALL.getName().equals(elementName) || XSD_COMPLEXCONTENT.getName().equals(elementName)) {
                return this.isPathValidForSchema(e, path);
            }
            if (XSD_EXTENSION.getName().equals(elementName)) {
                Element rootElement = this.schemaDocument.getRootElement();
                String typeName = e.attributeValue("base").split(":")[1];
                Element extension = (Element)rootElement.selectSingleNode(String.format("xsd:complexType[@name='%s']", typeName));
                return this.isPathValidForSchema(e, path) || this.isPathValidForSchema(extension, path);
            }
        } else {
            newCurrent = this.locateXsdElement(current, split[0]);
        }
        if (newCurrent != null && split[1] != null) {
            return this.isPathValidForSchema(newCurrent, split[1]);
        }
        return newCurrent != null;
    }

    private String[] splitPath(String path) {
        int slashIndex;
        String[] split = new String[2];
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((slashIndex = path.indexOf(47)) != -1) {
            split[0] = path.substring(0, slashIndex);
            split[1] = path.substring(slashIndex + 1);
        } else {
            split[0] = path;
        }
        int nsSeparatorIndex = split[0].indexOf(58);
        split[0] = nsSeparatorIndex != -1 ? split[0].substring(nsSeparatorIndex + 1) : split[0];
        return split;
    }

    private void internalBuild(Document schemaDocument) throws SchemaHelperException {
        Element root = schemaDocument.getRootElement();
        if (root != null) {
            Iterator includeIter = root.elementIterator(XSD_IMPORT);
            while (includeIter.hasNext()) {
                Element includeElement = (Element)includeIter.next();
                String inclSchemaInstanceURI = includeElement.attributeValue("schemaLocation");
                if (!this.isImported(inclSchemaInstanceURI)) {
                    EntityResolver resolver = schemaDocument.getEntityResolver();
                    try {
                        if (resolver == null) {
                            String msg = "No EntityResolver available";
                            throw new SchemaHelperException(msg);
                        }
                        InputSource inputSource = resolver.resolveEntity(null, inclSchemaInstanceURI);
                        if (inputSource == null) {
                            String msg = "Could not resolve the schema URI: " + inclSchemaInstanceURI;
                            throw new SchemaHelperException(msg);
                        }
                        SAXReader reader = new SAXReader();
                        Document inclSchemaDocument = reader.read(inputSource);
                        this.internalBuild(inclSchemaDocument);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new SchemaHelperException("Failed to load schema: " + inclSchemaInstanceURI);
                    }
                }
                includeElement.detach();
            }
            Iterator iter = root.elementIterator(XSD_ELEMENT);
            while (iter.hasNext()) {
                this.schemaDocument.getRootElement().add(((Element)iter.next()).detach());
            }
            iter = root.elementIterator(XSD_SIMPLETYPE);
            while (iter.hasNext()) {
                this.schemaDocument.getRootElement().add(((Element)iter.next()).detach());
            }
            iter = root.elementIterator(XSD_COMPLEXTYPE);
            while (iter.hasNext()) {
                this.schemaDocument.getRootElement().add(((Element)iter.next()).detach());
            }
        }
    }

    private boolean isImported(String schemaURI) {
        int slashIndex = schemaURI.lastIndexOf(47);
        String string = schemaURI = slashIndex == -1 ? schemaURI : schemaURI.substring(slashIndex + 1);
        if (!this.imported.contains(schemaURI)) {
            this.imported.add(schemaURI);
            return false;
        }
        return true;
    }
}

