/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.xml;

import gov.va.med.cds.exceptionframework.LoggingSeverity;
import gov.va.med.cds.testharness.xml.XmlComparator;
import gov.va.med.cds.testharness.xml.XmlCompareException;
import gov.va.med.cds.testharness.xml.XmlValidator;
import gov.va.med.cds.testharness.xml.XpathAsserterFactory;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

public class Assert
extends org.junit.Assert {
    public static void assertXpathCompare(String xml, String xpathExpression, String controlResult) {
        try {
            XpathAsserterFactory.createXpathAsserter(XpathAsserterFactory.VHIM_VERSION.VHIM_400).assertXpathCompare(xml, xpathExpression, controlResult);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertXmlEquals(String sourceXml, String controlXml) {
        try {
            XmlComparator.assertXMLSimilar(sourceXml, controlXml);
        }
        catch (XmlCompareException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertXmlEquals(String sourceXml, String controlXml, List<String> excludes) {
        try {
            XmlComparator.assertXMLSimilar(sourceXml, controlXml, excludes);
        }
        catch (XmlCompareException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertXmlEqualsAfterRemovingAllEmptyElements(String sourceXml, String controlXml, List<String> excludes) {
        try {
            XmlComparator.assertXMLSimilarAfterRemovingAllEmptyElements(sourceXml, controlXml, excludes);
        }
        catch (XmlCompareException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertXmlSimilar(String sourceXml, String controlXml) {
        try {
            XmlComparator.assertXMLSimilar(sourceXml, controlXml);
        }
        catch (XmlCompareException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertXmlValidation(String xml, String templateId) {
        try {
            XmlValidator.validateXml(xml, templateId);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertXmlValidation(String xml, String templateId, String schemaNamespace) {
        try {
            XmlValidator.validateXml(xml, templateId, schemaNamespace);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertXmlErrorSectionEquals(String sourceXml, String controlXml) {
        Assert.assertXmlErrorSectionEquals(sourceXml, controlXml, null);
    }

    public static void assertXmlErrorSectionEquals(String sourceXml, String controlXml, List<String> excludes) {
        try {
            XmlComparator.assertXMLSimilar(sourceXml, controlXml, excludes);
        }
        catch (XmlCompareException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertHasFatalErrors(String xmlClinicalData) {
        try {
            Document clinicalData = DocumentHelper.parseText((String)xmlClinicalData);
            Assert.assertTrue((clinicalData.selectNodes("/ClinicalData/errorSection/fataErrors").size() > 0 ? 1 : 0) != 0);
        }
        catch (DocumentException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertNoErrors(String xmlClinicalData) {
        try {
            Document clinicalData = DocumentHelper.parseText((String)xmlClinicalData);
            Assert.assertTrue((clinicalData.selectNodes("/ClinicalData/errorSection/*").size() == 0 ? 1 : 0) != 0);
        }
        catch (DocumentException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static void assertErrors(String xmlClinicalData, LoggingSeverity serverity, int count) {
        try {
            Document clinicalData = DocumentHelper.parseText((String)xmlClinicalData);
            switch (serverity) {
                case FATAL: {
                    Assert.assertEquals((Object)clinicalData.selectNodes("/ClnicalData/errorSection/fatalErrors"), (Object)count);
                    break;
                }
                case ERROR: {
                    Assert.assertEquals((Object)clinicalData.selectNodes("/ClnicalData/errorSection/errors"), (Object)count);
                    break;
                }
                case WARNING: {
                    Assert.assertEquals((Object)clinicalData.selectNodes("/ClnicalData/errorSection/warnings"), (Object)count);
                    break;
                }
                default: {
                    Assert.fail();
                    break;
                }
            }
        }
        catch (DocumentException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

