/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.CommonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TiuBuilder
extends AbstractEntryPointBuilder {
    public static final String[] DATA_ENTERERS = new String[]{"data_enterer_1", "data_enterer_2", "data_enterer_3"};
    public static final String[] AUTHORS = new String[]{"author_11", "author_12", "author_13"};
    public static final String[] SIGNERS = new String[]{"signer_21", "signer_22", "signer_23", "signer_24", "signer_25", "signer_26"};
    public static final String[] COSIGNERS = new String[]{"cosigner_31", "cosigner_32", "cosigner_33", "cosigner_34", "cosigner_35", "cosigner_36"};
    public static final String[] CLOSERS = new String[]{"closer_41", "closer_42", "closer_43"};
    public static final String[] AMENDERS = new String[]{"amender_51", "amender_52", "amender_53"};
    public static final String[] REASSIGNERS = new String[]{"reassigner_61", "reassigner_62", "reassigner_63"};
    public static final String[] EDITORS = new String[]{"editor_71", "editor_72", "editor_73"};
    public static final String[] MARKERS = new String[]{"marker_81", "marker_82", "marker_83"};
    public static final String[] RETRACTORS = new String[]{"retractor_91", "retractor_92", "retractor_93"};
    public static final String[] ATTENDINGS = new String[]{"attending_101", "attending_102", "attending_103"};
    public static final String[] DELETERS = new String[]{"deleter_111", "deleter_112", "deleter_113"};
    protected static Log logger = null;
    private static final String RECORD_VERSION = "12345";
    private int TIU_IDX = 60000;

    public TiuBuilder() {
    }

    public TiuBuilder(Random aRandom) {
        super(aRandom);
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeClinicalDocumentEvent(personIdentifier);
    }

    public Element makeClinicalDocumentEvent() {
        return this.makeClinicalDocumentEvent(null);
    }

    public List<Element> makeClinicalDocumentEvent(int number) {
        return this.makeClinicalDocumentEvents(number, null);
    }

    public Element makeClinicalDocumentEvent(Element patient) {
        Element newClinicalDocumentEvent = this.createClinicalDocumentEvent(this.TIU_IDX++, patient);
        return newClinicalDocumentEvent;
    }

    public List<Element> makeClinicalDocumentEvents(int number, Element patient) {
        ArrayList<Element> newClinicalDocumentEvents = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            newClinicalDocumentEvents.add(this.makeClinicalDocumentEvent(patient));
        }
        return newClinicalDocumentEvents;
    }

    private Element createClinicalDocumentEvent(int id, Element patient) {
        Element element = DocumentHelper.createElement((String)"clinicalDocumentEvents");
        element.add(this.createHL72EntityIdentifier("recordIdentifier", id));
        Element newPatient = this.createPatientLite("patient");
        if (patient != null) {
            newPatient.element("identifier").element("identity").setText(patient.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText(patient.elementText("assigningFacility"));
            newPatient.element("identifier").element("assigningAuthority").setText(patient.elementText("assigningAuthority"));
        }
        element.add(newPatient);
        element.add(this.createFixedPointInTime("referenceDate"));
        element.add(this.createHL72EntityIdentifier("parentIdentifier"));
        element.add(this.createHL72CodedElementLite("standardizedDocumentTitle", "StandardizedDocumentTitle"));
        element.addElement("documentTitle").setText("DocumentTitle");
        element.addElement("documentSubject").setText("DocumentSubject");
        element.addElement("documentText").setText("DocumentText_1");
        element.addElement("documentText").setText("DocumentText_2");
        element.addElement("documentContent").setText("DocumentContent");
        element.add(this.createHL72CodedElementLite("statusCode", "StatusCode"));
        element.add(this.createPractitionerLite("dataEnterer", DATA_ENTERERS));
        element.add(this.createPractitionerLite("author", AUTHORS));
        element.add(this.createPractitionerLite("chartMarkedSigned", SIGNERS));
        element.add(this.createPractitionerLite("chartMarkedCosigned", COSIGNERS));
        element.add(this.createPractitionerLite("expectedSigner", SIGNERS));
        element.add(this.createManagedPractitionerParticipationLite("signer", SIGNERS));
        element.add(this.createPractitionerLite("expectedCosigner", COSIGNERS));
        element.add(this.createManagedPractitionerParticipationLite("cosigner", COSIGNERS));
        element.add(this.createPractitionerLite("otherExpectedCosigners", COSIGNERS));
        element.add(this.createPractitionerLite("otherExpectedCosigners", COSIGNERS));
        element.add(this.createManagedPractitionerParticipationLite("otherCosigners", COSIGNERS));
        element.add(this.createManagedPractitionerParticipationLite("otherCosigners", COSIGNERS));
        element.add(this.createManagedPractitionerParticipationLite("adminCloser", CLOSERS));
        element.add(this.createManagedPractitionerParticipationLite("amender", AMENDERS));
        element.add(this.createFixedPointInTime("amendmentDate"));
        element.add(this.createFixedPointInTime("dictationDate"));
        element.add(this.createFixedPointInTime("patientMovementDate"));
        element.add(this.createFixedPointInTime("archiveDate"));
        element.add(this.createFixedPointInTime("procedureDate"));
        element.add(this.createFixedPointInTime("enteredDate"));
        element.add(this.createHL72CodedElementLite("procedureSummaryCode", "ProcedureSummaryCode"));
        element.add(this.createHL72CodedElementLite("treatingSpecialtyCode", "TreatingSpecialtyCode"));
        element.add(this.createHL72CodedElementLite("serviceCode", "ServiceCode"));
        element.add(this.createHL72CodedElementLite("cosignatureNeeded", "CosignatureNeeded"));
        element.add(this.createDocumentUpdateEvent("documentUpdateEvents"));
        element.add(this.createTreatmentEpisode("treatmentEpisode"));
        element.add(this.createTiuPatientVisit("patientVisit"));
        element.add(this.createRetractionEvent("retraction"));
        element.add(this.createImage("images"));
        element.add(this.createImage("images"));
        element.addElement("recordVersion").setText(RECORD_VERSION);
        element.add(this.createFixedPointInTime("recordUpdateTime"));
        return element;
    }

    private Element createImage(String elementName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(this.createHL72CodedElementLite("imageLinkCode", "ImageLinkCode"));
        return element;
    }

    private Element createRetractionEvent(String elementName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(this.createPractitionerLite("retractor", RETRACTORS));
        element.add(this.createHL72CodedElementLite("reasonCode", "ReasonCode"));
        element.add(this.createFixedPointInTime("retractionDate"));
        element.add(this.createHL72EntityIdentifier("retractedOriginal"));
        return element;
    }

    private Element createTiuPatientVisit(String elementName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.addElement("patientClass").addText("PatientClass");
        element.add(TiuBuilder.createHL72LocationIdentifier("assignedLocation", "AssignedLocation"));
        element.add(this.createPractitionerLite("attendingPhysician", ATTENDINGS));
        element.addElement("hospitalService").addText("HospitalService");
        element.add(TiuBuilder.createHL72LocationIdentifier("serviceLocation", "ServiceLocation"));
        element.add(this.createPointInTime("visitDate"));
        element.addElement("servicingFacility").addText("ServicingFacility");
        element.add(this.createPointInTime("admitDate"));
        element.addElement("visitId").addText("VisitId");
        element.add(this.createPointInTime("secondaryVisitDate"));
        return element;
    }

    private Element createTreatmentEpisode(String elementName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(this.createPointInTime("episodeBeginDate"));
        element.add(this.createPointInTime("episodeEndDate"));
        return element;
    }

    private Element createDocumentUpdateEvent(String elementName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(this.createHL72PersonName("initialPatientName"));
        element.add(this.createHL72PersonName("finalPatientName"));
        element.add(this.createPointInTime("initialVisitDate"));
        element.add(this.createPointInTime("finalVisitDate"));
        element.add(TiuBuilder.createHL72LocationIdentifier("initialVisitLocation", "InitialVisitLocation"));
        element.add(TiuBuilder.createHL72LocationIdentifier("finalVisitLocation", "FinalVisitLocation"));
        element.add(this.createHL72CodedElementLite("initialVisitType", "InitialVisitType"));
        element.add(this.createHL72CodedElementLite("finalVisitType", "FinalVisitType"));
        element.addElement("initialVisitRecord").addText("InitialVisitRecord");
        element.addElement("finalVisitRecord").addText("FinalVisitRecord");
        element.add(this.createPointInTime("reassignmentDate"));
        element.add(this.createPractitionerLite("reassigner", REASSIGNERS));
        element.add(this.createPointInTime("editDate"));
        element.add(this.createPractitionerLite("editor", EDITORS));
        element.addElement("interdisciplinaryNoteParent").addText("InterdisciplinaryNoteParent");
        element.add(this.createPractitionerLite("interdisciplinaryNoteMarker", MARKERS));
        element.add(this.createHL72CodedElementLite("interdisciplinaryNoteActionCode", "InterdisciplinaryNoteActionCode"));
        element.add(this.createPointInTime("interdisciplinaryNoteActionDate"));
        element.addElement("interdisciplinaryNoteEntryStatus").addText("InterdisciplinaryNoteEntryStatus");
        element.add(this.createPractitionerLite("deleter", DELETERS));
        element.add(this.createPointInTime("deletionDate"));
        element.add(this.createHL72CodedElementLite("deletionReasonCode", "DeletionReasonCode"));
        return element;
    }

    private Element createManagedPractitionerParticipationLite(String elementName, String[] sourcePersonIds) {
        Element practitionerLite = this.createPractitionerLite("practitioner", sourcePersonIds);
        Element signatureMode = this.createHL72CodedElementLite("signatureMode", "SignatureMode");
        return CommonBuilder.createManagedPractitionerParticipationLite(elementName, practitionerLite, signatureMode);
    }
}

