/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.vhim400.PathwaysDataResponse400;
import gov.va.med.cds.testharness.vhim400.builders.BaseDatatypesBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilderInterface;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.CommonBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.HATrackingClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.IntoleranceConditionBuilderFactory;
import gov.va.med.cds.testharness.vhim400.builders.NonVaMedBuilderFactory;
import gov.va.med.cds.testharness.vhim400.builders.SensitivePatientDataAccessBuilderFactoryInterface;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class PathwaysDataBuilder
extends PathwaysDataResponse400
implements ClinicalDataBuilderInterface {
    private static final String CLIENT_NAME_ELEMENT_NAME = "clientName";
    private static final String CLIENT_REQUEST_INITIATION_TIME_ELEMENT_NAME = "clientRequestInitiationTime";
    private Map<String, ClinicalDomainBuilderFactoryInterface> domainEntryPointsWrappersMap = null;
    private Map<String, DomainEntryPoint> domainEntryPointsMap = new HashMap<String, DomainEntryPoint>();

    public PathwaysDataBuilder() {
    }

    public PathwaysDataBuilder(String patientElementPath, String clinicalRootPath, String errorResponseTemplateId, String schemaNamespacePrefix, String schemaNamespaceUri, String schemaLocalName) {
        super(patientElementPath, clinicalRootPath, errorResponseTemplateId, schemaNamespacePrefix, schemaNamespaceUri, schemaLocalName);
    }

    @Override
    public Document createClinicalData(String templateId) {
        return this.createClinicalData(templateId, 1);
    }

    public Document createClinicalData(Set<DomainEntryPoint> domainEntryPointsSet) {
        return this.createClinicalData(domainEntryPointsSet, 1);
    }

    public Document createClinicalData(String templateId, MultiValueMap map, String facilityId, String menuOption, String requestId, String clName, String clReqTime) {
        Document clinicalData = this.buildEmptyPathwaysDocumentWithPatient(templateId, requestId, clName, clReqTime);
        this.buildClinicalDataFromTemplateId(templateId, clinicalData, map, facilityId, menuOption);
        return clinicalData;
    }

    protected void buildClinicalDataFromTemplateId(String templateId, Document clinicalData, MultiValueMap map, String facilityId, String menuOption) {
        Set<DomainEntryPoint> templateDomainEntryPointsSet = null;
        if (templateId != null && !templateId.equals("")) {
            templateDomainEntryPointsSet = this.getDomainEntryPoints(templateId);
        }
        for (DomainEntryPoint domainEntryPoint : templateDomainEntryPointsSet) {
            this.buildClinicalDataFromEntryPoint(domainEntryPoint.name(), clinicalData, map, facilityId, menuOption);
        }
    }

    private void buildClinicalDataFromEntryPoint(String domainEntryPoint, Document clinicalData, MultiValueMap map, String facilityId, String menuOption) {
        if (domainEntryPoint.equals("PatientDataAccessedEvent")) {
            SensitivePatientDataAccessBuilderFactoryInterface sensitivePatientDataAccessBuilderFactory = null;
            sensitivePatientDataAccessBuilderFactory = (SensitivePatientDataAccessBuilderFactoryInterface)this.domainEntryPointsWrappersMap.get(domainEntryPoint);
            sensitivePatientDataAccessBuilderFactory.createClinicalDomainData(clinicalData, map, facilityId, menuOption);
        }
    }

    public Document createClinicalData(String templateId, MultiValueMap map, String facilityId1, String facilityId2, String menuOption, String requestId, String clName, String clReqTime) {
        Document clinicalData = this.buildEmptyPathwaysDocumentWithPatient(templateId, requestId, clName, clReqTime);
        this.buildClinicalDataFromTemplateId(templateId, clinicalData, map, facilityId1, facilityId2, menuOption);
        return clinicalData;
    }

    protected void buildClinicalDataFromTemplateId(String templateId, Document clinicalData, MultiValueMap map, String facilityId1, String facilityId2, String menuOption) {
        Set<DomainEntryPoint> templateDomainEntryPointsSet = null;
        if (templateId != null && !templateId.equals("")) {
            templateDomainEntryPointsSet = this.getDomainEntryPoints(templateId);
        }
        for (DomainEntryPoint domainEntryPoint : templateDomainEntryPointsSet) {
            this.buildClinicalDataFromEntryPoint(domainEntryPoint.name(), clinicalData, map, facilityId1, facilityId2, menuOption);
        }
    }

    private void buildClinicalDataFromEntryPoint(String domainEntryPoint, Document clinicalData, MultiValueMap map, String facilityId1, String facilityId2, String menuOption) {
        if (domainEntryPoint.equals("PatientDataAccessedEvent")) {
            SensitivePatientDataAccessBuilderFactoryInterface sensitivePatientDataAccessBuilderFactory = null;
            sensitivePatientDataAccessBuilderFactory = (SensitivePatientDataAccessBuilderFactoryInterface)this.domainEntryPointsWrappersMap.get(domainEntryPoint);
            sensitivePatientDataAccessBuilderFactory.createClinicalDomainData(clinicalData, map, facilityId1, facilityId2, menuOption);
        }
    }

    @Override
    public Document createClinicalData(String templateId, int count) {
        Document clinicalData = this.buildClinicalData(templateId);
        Element patientIdentifier = this.createPatientIdentifier();
        this.buildClinicalDataFromTemplateId(templateId, count, clinicalData, patientIdentifier, null);
        return clinicalData;
    }

    @Override
    public Document createClinicalData(Set<DomainEntryPoint> domainEntryPointsSet, int count) {
        Document clinicalData = this.buildClinicalData();
        Element patientIdentifier = this.createPatientIdentifier();
        this.buildClinicalDataFromEntryPoints(domainEntryPointsSet, count, clinicalData, patientIdentifier);
        return clinicalData;
    }

    @Override
    public Document createClinicalData(String templateId, String entityId) {
        return this.createClinicalData(templateId, 1, entityId);
    }

    @Override
    public Document createClinicalData(Set<DomainEntryPoint> domainEntryPointsSet, String entityId) {
        return this.createClinicalData(domainEntryPointsSet, 1, entityId);
    }

    @Override
    public Document createClinicalData(String templateId, int count, String entityId) {
        Document clinicalData = this.buildClinicalData(templateId);
        Element patientIdentifier = this.createPatientIdentifier(entityId);
        this.buildClinicalDataFromTemplateId(templateId, count, clinicalData, patientIdentifier, null);
        return clinicalData;
    }

    @Override
    public Document createClinicalData(Set<DomainEntryPoint> domainEntryPointsSet, int count, String entityId) {
        Document clinicalData = this.buildClinicalData();
        Element patientIdentifier = this.createPatientIdentifier(entityId);
        this.buildClinicalDataFromEntryPoints(domainEntryPointsSet, count, clinicalData, patientIdentifier);
        return clinicalData;
    }

    @Override
    public Document createClinicalData(String templateId, int count, Element patient) {
        Document clinicalData = this.buildClinicalData(templateId);
        Element patientIdentifier = this.createPatientIdentifier(patient);
        this.buildClinicalDataFromTemplateId(templateId, count, clinicalData, patientIdentifier, null);
        return clinicalData;
    }

    public Document createClinicalData(String templateId, int count, Element patient, String skillType) {
        Document clinicalData = this.buildClinicalData(templateId);
        Element patientIdentifier = this.createPatientIdentifier(patient);
        this.buildClinicalDataFromTemplateId(templateId, count, clinicalData, patientIdentifier, skillType);
        return clinicalData;
    }

    @Override
    public Document createClinicalData(String templateId, String templateSubstitutionKey, int count, Element patient) {
        Document clinicalData = this.buildClinicalData(templateId);
        Element patientIdentifier = this.createPatientIdentifier(patient);
        this.buildClinicalDataFromTemplateId(templateSubstitutionKey, count, clinicalData, patientIdentifier, null);
        return clinicalData;
    }

    @Override
    public Document createClinicalData(Set<DomainEntryPoint> domainEntryPointsSet, int count, Element patient) {
        Document clinicalData = this.buildClinicalData();
        Element patientIdentifier = this.createPatientIdentifier(patient);
        this.buildClinicalDataFromEntryPoints(domainEntryPointsSet, count, clinicalData, patientIdentifier);
        return clinicalData;
    }

    @Override
    public Document createClinicalData(DomainEntryPoint domainEntryPoint, int count, Element patient) {
        Document clinicalData = this.buildClinicalData();
        Element patientIdentifier = this.createPatientIdentifier(patient);
        this.buildClinicalDataFromEntryPoint(domainEntryPoint.getName(), count, clinicalData, patientIdentifier, null);
        return clinicalData;
    }

    @Override
    public Document createClinicalData(DomainEntryPoint domainEntryPoint, int count) {
        Element patientIdentifier = this.createPatientIdentifier();
        return this.createClinicalData(domainEntryPoint, count, patientIdentifier);
    }

    @Override
    public Document createClinicalData(String templateId, Element clinicalDataPatient) {
        return this.createClinicalData(templateId, 1, clinicalDataPatient);
    }

    @Override
    public Document createClinicalData(Set<DomainEntryPoint> domainEntryPointsSet, Element clinicalDataPatient) {
        return this.createClinicalData(domainEntryPointsSet, 1, clinicalDataPatient);
    }

    @Override
    public Document updateClinicalData(String templateId, int count, Element patient) {
        Document clinicalData = this.buildClinicalData(templateId);
        Element patientIdentifier = this.createPatientIdentifier(patient);
        this.buildClinicalDataFromTemplateId(templateId, count, clinicalData, patientIdentifier, null);
        return clinicalData;
    }

    @Override
    public Document deleteClinicalData(DomainEntryPoint domainEntryPoint, String templateId, Element patient, String recordIdentifier, String recordStatus) {
        Document clinicalData = this.buildClinicalData(templateId);
        Element patientIdentifier = this.createPatientIdentifier(patient);
        this.buildDeleteClinicalDataFromEntryPoint(domainEntryPoint.getName(), clinicalData, recordIdentifier, recordStatus);
        return clinicalData;
    }

    public Document deleteClinicalDataWithRecordVersion(DomainEntryPoint domainEntryPoint, String templateId, String recordIdentifier, String recordVersion) {
        Document clinicalData = this.buildClinicalData(templateId);
        this.buildDeleteClinicalDataFromEntryPointWithRecordVersion(domainEntryPoint.getName(), clinicalData, recordIdentifier, recordVersion);
        return clinicalData;
    }

    @Override
    public Document deleteClinicalData(DomainEntryPoint domainEntryPoint, String templateId, String recordIdentifier, String recordStatus) {
        Document clinicalData = this.buildClinicalData(templateId);
        this.buildDeleteClinicalDataFromEntryPoint(domainEntryPoint.getName(), clinicalData, recordIdentifier, recordStatus);
        return clinicalData;
    }

    private Element createPatientIdentifier() {
        return BaseDatatypesBuilder.createHL72PersonIdentifier("Identifier");
    }

    protected Element createPatientIdentifier(Element patientIdentifier) {
        Element patient = null;
        patient = patientIdentifier.elements("identifer") == null ? BaseDatatypesBuilder.createHL72PersonIdentifier("Identifier") : patientIdentifier;
        return patient;
    }

    private Element createPatientIdentifier(String patientId) {
        return BaseDatatypesBuilder.createHL72PersonIdentifier("Identifier", patientId);
    }

    protected void buildClinicalDataFromTemplateId(String templateId, int aCount, Document clinicalData, Element patientIdentifier, String skillType) {
        Set<DomainEntryPoint> templateDomainEntryPointsSet = null;
        if (templateId != null && !templateId.equals("")) {
            templateDomainEntryPointsSet = this.getDomainEntryPoints(templateId);
        }
        for (DomainEntryPoint domainEntryPoint : templateDomainEntryPointsSet) {
            this.buildClinicalDataFromEntryPoint(domainEntryPoint.name(), aCount, clinicalData, patientIdentifier, skillType);
        }
    }

    protected void buildClinicalDataFromTemplateId(String templateId, int aCount, Document clinicalData, Element patientIdentifier, String goalName, String entryDate) {
        Set<DomainEntryPoint> templateDomainEntryPointsSet = null;
        if (templateId != null && !templateId.equals("")) {
            templateDomainEntryPointsSet = this.getDomainEntryPoints(templateId);
        }
        for (DomainEntryPoint domainEntryPoint : templateDomainEntryPointsSet) {
            this.buildClinicalDataFromEntryPoint(domainEntryPoint.name(), aCount, clinicalData, patientIdentifier, goalName, entryDate);
        }
    }

    private void buildClinicalDataFromEntryPoints(Set<DomainEntryPoint> domainEntryPointsSet, int count, Document clinicalData, Element patientIdentifier) {
        for (DomainEntryPoint domainEntryPoint : domainEntryPointsSet) {
            this.buildClinicalDataFromEntryPoint(domainEntryPoint.getName(), count, clinicalData, patientIdentifier, null);
        }
    }

    private void buildClinicalDataFromEntryPoint(String domainEntryPoint, int count, Document clinicalData, Element patientIdentifier, String skillType) {
        if (domainEntryPoint.equals("SkillTracking")) {
            HATrackingClinicalDomainBuilderFactoryInterface haTrackingClinicalDomainBuilderFactory = null;
            haTrackingClinicalDomainBuilderFactory = (HATrackingClinicalDomainBuilderFactoryInterface)this.domainEntryPointsWrappersMap.get(domainEntryPoint);
            haTrackingClinicalDomainBuilderFactory.createClinicalDomainData(clinicalData, count, patientIdentifier, skillType);
        } else {
            ClinicalDomainBuilderFactoryInterface clinicalDomainBuilderFactory = null;
            clinicalDomainBuilderFactory = this.domainEntryPointsWrappersMap.get(domainEntryPoint);
            clinicalDomainBuilderFactory.createClinicalDomainData(clinicalData, count, patientIdentifier);
        }
    }

    private void buildClinicalDataFromEntryPoint(String domainEntryPoint, int count, Document clinicalData, Element patientIdentifier, String goalName, String entryDate) {
        if (domainEntryPoint.equals("GoalTracking")) {
            HATrackingClinicalDomainBuilderFactoryInterface haTrackingClinicalDomainBuilderFactory = null;
            haTrackingClinicalDomainBuilderFactory = (HATrackingClinicalDomainBuilderFactoryInterface)this.domainEntryPointsWrappersMap.get(domainEntryPoint);
            haTrackingClinicalDomainBuilderFactory.createClinicalDomainData(clinicalData, count, patientIdentifier, goalName, entryDate);
        } else {
            ClinicalDomainBuilderFactoryInterface clinicalDomainBuilderFactory = null;
            clinicalDomainBuilderFactory = this.domainEntryPointsWrappersMap.get(domainEntryPoint);
            clinicalDomainBuilderFactory.createClinicalDomainData(clinicalData, count, patientIdentifier);
        }
    }

    private void buildDeleteClinicalDataFromEntryPoint(String domainEntryPoint, Document clinicalData, String recordIdentifier, String recordStatus) {
        if (domainEntryPoint.equals("IntoleranceCondition")) {
            IntoleranceConditionBuilderFactory clinicalDomainBuilderFactory = (IntoleranceConditionBuilderFactory)this.domainEntryPointsWrappersMap.get(domainEntryPoint);
            clinicalDomainBuilderFactory.createClinicalDomainData(clinicalData, recordIdentifier);
        } else if (domainEntryPoint.equals("NonVaMedicationEvent")) {
            NonVaMedBuilderFactory clinicalDomainBuilderFactory = (NonVaMedBuilderFactory)this.domainEntryPointsWrappersMap.get(domainEntryPoint);
            clinicalDomainBuilderFactory.createClinicalDomainData(clinicalData, recordIdentifier, recordStatus);
        } else {
            HAClinicalDomainBuilderFactoryInterface clinicalDomainBuilderFactory = (HAClinicalDomainBuilderFactoryInterface)this.domainEntryPointsWrappersMap.get(domainEntryPoint);
            clinicalDomainBuilderFactory.createClinicalDomainData(clinicalData, recordIdentifier, recordStatus);
        }
    }

    private void buildDeleteClinicalDataFromEntryPointWithRecordVersion(String domainEntryPoint, Document clinicalData, String recordIdentifier, String recordVersion) {
        if (domainEntryPoint.equals("IntoleranceCondition")) {
            IntoleranceConditionBuilderFactory clinicalDomainBuilderFactory = (IntoleranceConditionBuilderFactory)this.domainEntryPointsWrappersMap.get(domainEntryPoint);
            clinicalDomainBuilderFactory.createClinicalDomainData(clinicalData, recordIdentifier, recordVersion);
        }
    }

    @Override
    public ClinicalDomainBuilderFactoryInterface getClinicalDomainBuildFactory(String domainEntryPoint) {
        ClinicalDomainBuilderFactoryInterface clinicalDomainBuilderFactory = null;
        clinicalDomainBuilderFactory = this.domainEntryPointsWrappersMap.get(domainEntryPoint);
        return clinicalDomainBuilderFactory;
    }

    protected Document buildClinicalData(String templateId) {
        Element patient = CommonBuilder.createClinicalDataPatient("patient");
        return this.buildClinicalDataDocument(templateId, patient);
    }

    private Document buildClinicalData() {
        Element patient = CommonBuilder.createClinicalDataPatient("patient");
        return this.buildClinicalDataDocument(null, patient);
    }

    private Document buildClinicalDataDocument(String templateId, Element clinicalDataPatient) {
        Document clinicalDataDocument = null;
        clinicalDataDocument = templateId.equals("IntoleranceConditionCreateOrUpdate40060") || templateId.equals("AllergyAssessmentCreateOrUpdate40060") || templateId.equals("NonVAMedicationCreateOrUpdate3") || templateId.equals("NonVAMedicationDelete1") ? this.buildEmptyClinicalDocument(templateId, null, "ClientName") : (templateId.equals("HealthAdapterCreate1") || templateId.equals("HealthAdapterUpdate1") || templateId.equals("HealthAdapterDelete1") || templateId.startsWith("DBQ") || templateId.equals("IntoleranceConditionDelete40030") || templateId.equals("PharmacyCreateOrUpdate40060") || templateId.equals("LabCreateOrUpdate40060") ? this.buildEmptyClinicalDocument(templateId, null) : this.buildEmptyClinicalDocument(templateId, new UniqueIdentifier().toString()));
        return clinicalDataDocument;
    }

    @Override
    public Map<String, ClinicalDomainBuilderFactoryInterface> getDomainEntryPointsWrappersMap() {
        return this.domainEntryPointsWrappersMap;
    }

    public void setDomainEntryPointsWrappersMap(Map<String, ClinicalDomainBuilderFactoryInterface> domainEntryPointsWrappersMap) {
        this.domainEntryPointsWrappersMap = domainEntryPointsWrappersMap;
    }

    public Set<DomainEntryPoint> getDomainEntryPoints(String templateId) {
        HashSet<DomainEntryPoint> domainEntryPointSet = new HashSet<DomainEntryPoint>();
        domainEntryPointSet.add(this.domainEntryPointsMap.get(templateId));
        return domainEntryPointSet;
    }

    public void setDomainEntryPointsMap(Map<String, DomainEntryPoint> domainEntryPointsMap) {
        this.domainEntryPointsMap = domainEntryPointsMap;
    }

    @Override
    public void addAuditInfo(Element clinicalDataElement, String clientName) {
        if (clientName != null) {
            this.getChildElement(clinicalDataElement, CLIENT_NAME_ELEMENT_NAME, true).addText(clientName);
            this.getChildElement(clinicalDataElement, CLIENT_REQUEST_INITIATION_TIME_ELEMENT_NAME, true).addText(DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(new Date()));
        }
    }

    @Override
    public Document createClinicalData(String templateId, String templateSubstitutionKey, int count, Element patient, String skillType) {
        Document clinicalData = this.buildClinicalData(templateId);
        Element patientIdentifier = this.createPatientIdentifier(patient);
        this.buildClinicalDataFromTemplateId(templateSubstitutionKey, count, clinicalData, patientIdentifier, skillType);
        return clinicalData;
    }

    @Override
    public Document createClinicalData(String templateId, String templateSubstitutionKey, int count, Element patient, String goalName, String entryDate) {
        Document clinicalData = this.buildClinicalData(templateId);
        Element patientIdentifier = this.createPatientIdentifier(patient);
        this.buildClinicalDataFromTemplateId(templateSubstitutionKey, count, clinicalData, patientIdentifier, goalName, entryDate);
        return clinicalData;
    }

    public Document createClinicalData(String templateId, MultiValueMap map, String facilityId, String menuOption, String requestId) {
        return null;
    }

    public Document createClinicalData(String templateId, MultiValueMap map, String facilityId1, String facilityId2, String menuOption, String requestId) {
        return null;
    }
}

