/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class NonVaMedBuilder
extends AbstractEntryPointBuilder {
    public static final String[] DOCUMENTED_BYS = new String[]{"documented_by_1", "documented_by_2", "documented_by_3"};
    protected static Log logger = null;
    private static final String RECORD_VERSION = "12345";
    private int NME_IDX = 60000;

    public NonVaMedBuilder() {
    }

    public NonVaMedBuilder(Random aRandom) {
        super(aRandom);
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeNonVaMedicationEvent(personIdentifier);
    }

    public Element makeNonVaMedicationEvent() {
        return this.makeNonVaMedicationEvent(null);
    }

    public List<Element> makeNonVaMedicationEvent(int number) {
        return this.makeNonVaMedicationEvents(number, null);
    }

    public Element makeNonVaMedicationEvent(Element patient) {
        Element newNonVaMedicationEvent = this.createNonVaMedicationEvent(this.NME_IDX++, patient);
        return newNonVaMedicationEvent;
    }

    public Element makeNonVaMedicationEvents(String recordIdentifier, String recordStatus) {
        Element nonVaMedicationEvent = DocumentHelper.createElement((String)"nonVaMedicationEvent");
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
        nonVaMedicationEvent.add(newRecordIdentifier);
        nonVaMedicationEvent.addElement("recordStatus").addText(recordStatus);
        return nonVaMedicationEvent;
    }

    public List<Element> makeNonVaMedicationEvents(int number, Element patient) {
        ArrayList<Element> newNonVaMedicationEvents = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            newNonVaMedicationEvents.add(this.makeNonVaMedicationEvent(patient));
        }
        return newNonVaMedicationEvents;
    }

    private Element createNonVaMedicationEvent(int id, Element patient) {
        Element element = DocumentHelper.createElement((String)"nonVaMedicationEvent");
        element.add(this.createHL72EntityIdentifier("recordIdentifier", id));
        Element newPatient = this.createPatientLite("pharmacyPatient");
        if (patient != null) {
            newPatient.element("identifier").element("identity").setText(patient.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText(patient.elementText("assigningFacility"));
            newPatient.element("identifier").element("assigningAuthority").setText(patient.elementText("assigningAuthority"));
        }
        element.add(newPatient);
        element.add(this.createPhysicalQuantity("dosage"));
        element.add(this.createHL72CodedElementLite("route", "Route"));
        element.add(this.createHL72CodedElementLite("schedule", "Schedule"));
        element.add(this.createHL72CodedElementLite("status", "Status"));
        element.add(this.createFixedPointInTime("discontinueDate"));
        element.add(this.createHL72EntityIdentifier("orderIdentifier"));
        element.add(this.createPractitionerParticipationLite("documentedBy", "comment", DOCUMENTED_BYS));
        Element newMedication = element.addElement("medication");
        newMedication.add(this.createHL72CodedElement("medicationCode", "medicationCode"));
        element.add(this.createFixedPointInTime("startDate"));
        element.add(NonVaMedBuilder.createHL72LocationIdentifier("orderLocationIdentifier"));
        Element newComments = element.addElement("comments");
        newComments.addElement("comment").setText("comment");
        newComments.addElement("comment").setText("comment");
        element.addElement("source").setText("Source");
        Element newPharmacyOrderableItem = element.addElement("pharmacyOrderableItem");
        newPharmacyOrderableItem.add(this.createHL72CodedElementLite("itemCode", "ItemCode"));
        newPharmacyOrderableItem.add(this.createHL72CodedElementLite("dosageFormCode", "DosageFormCode"));
        Element newDisclaimers = element.addElement("disclaimers");
        newDisclaimers.addElement("disclaimer").setText("disclaimer");
        newDisclaimers.addElement("disclaimer").setText("disclaimer");
        element.add(this.createDetectedIssueEvents("detectedIssueEvents"));
        element.addElement("recordVersion").setText(RECORD_VERSION);
        element.add(this.createFixedPointInTime("recordUpdateTime"));
        return element;
    }

    private Element createDetectedIssueEvents(String elementName) {
        Element detectedIssueEventsElement = DocumentHelper.createElement((String)elementName);
        Element element = detectedIssueEventsElement.addElement("detectedIssueEvent");
        element.add(this.createHL72EntityIdentifier("id", "entityIdentifier", "namespaceId", "universalId"));
        element.addElement("narrativeText").setText("NarrativeText");
        element.add(this.createPractitionerParticipationLite("overridingProvider", "sourcePersonId", "comment"));
        Element newDetectedIssuesManagement = element.addElement("detectedIssuesManagement");
        return detectedIssueEventsElement;
    }
}

