/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.BaseDatatypesBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LabBuilder
extends AbstractEntryPointBuilder {
    public static final String[] DOCTOR_IDS = new String[]{"test_DOCTORID_1001", "test_DOCTORID_1002", "test_DOCTORID_1003", "test_DOCTORID_1004"};
    public static final String[] VERIFIER_IDS = new String[]{"test_verifierid_11001", "test_verifierid_11002", "test_verifierid_11003"};
    protected static Log logger = null;
    private static final int RECORD_VERSION = 12345;
    private int LAB_IDX = 50000;

    public LabBuilder() {
    }

    public LabBuilder(Random random) {
        super(random);
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeLabTestPromise(personIdentifier);
    }

    public Element makeLabTestPromise() {
        return this.makeLabTestPromise(null);
    }

    public List<Element> makeLabTestPromise(int number) {
        return this.makeLabTestPromise(number, null);
    }

    public Element makeLabTestPromise(Element patient) {
        Element lab = this.createLabTestPromise(this.LAB_IDX++, patient);
        return lab;
    }

    public List<Element> makeLabTestPromise(int number, Element patient) {
        ArrayList<Element> labs = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            labs.add(this.makeLabTestPromise(patient));
        }
        return labs;
    }

    public Element createLabTestPromise(int id, Element labPatient) {
        Element newLabTestPromise = DocumentHelper.createElement((String)"labTestPromises");
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", id);
        newLabTestPromise.add(newRecordIdentifier);
        Element newPatient = this.createPatientLite("patient");
        if (labPatient != null) {
            newPatient.element("identifier").element("identity").setText(labPatient.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText(labPatient.elementText("assigningFacility"));
            newPatient.element("identifier").element("assigningAuthority").setText(labPatient.elementText("assigningAuthority"));
        }
        newLabTestPromise.add(newPatient);
        Element newPlacerOrderIdentifier = this.createHL72EntityIdentifier("placerOrderIdentifier");
        newLabTestPromise.add(newPlacerOrderIdentifier);
        newLabTestPromise.addElement("placerAccessionReference").addText("PlacerAccessionReference");
        newLabTestPromise.addElement("fillerIenReference").addText("FillerIenReference");
        Element newReportCompleteDate = this.createPointInTime("reportCompleteDate");
        newLabTestPromise.add(newReportCompleteDate);
        newLabTestPromise.addElement("labSubscript").addText("CH");
        newLabTestPromise.addElement("priority").addText("Priority");
        newLabTestPromise.addElement("status").addText("Status");
        Element newLabCommentEvent = this.makeLabCommentEvent("LabTestPromise.LabCommentEvent1", "One");
        newLabTestPromise.add(newLabCommentEvent);
        newLabCommentEvent = this.makeLabCommentEvent("LabTestPromise.LabCommentEvent2", "Two");
        newLabTestPromise.add(newLabCommentEvent);
        Element newLabTestRequest = this.makeLabTestRequest();
        newLabTestPromise.add(newLabTestRequest);
        Element newLabPatientVisit = this.makeLabPatientVisit();
        newLabTestPromise.add(newLabPatientVisit);
        Element newSpecimen = this.makeSpecimen("Specimen");
        newLabTestPromise.add(newSpecimen);
        Element newLabTest = this.makeLabTest("LabTest1", "OTCode1");
        newLabTestPromise.add(newLabTest);
        newLabTest = this.makeLabTest("LabTest2", "OTCode2");
        newLabTestPromise.add(newLabTest);
        Element newRecordSource = this.createHL72FacilityIdentifier("recordSource");
        newLabTestPromise.add(newRecordSource);
        newLabTestPromise.addElement("recordVersion").addText(new Integer(12345).toString());
        Element newRecordUpdateTime = this.createPointInTime("recordUpdateTime");
        newLabTestPromise.add(newRecordUpdateTime);
        return newLabTestPromise;
    }

    public Element makeLabCommentEvent(String commentText, String codePrefix) {
        Element newLabCommentEvent = DocumentHelper.createElement((String)"labCommentEvents");
        Element newCommentTypeCode = BaseDatatypesBuilder.createHL72CodedElementLite("commentTypeCode", codePrefix);
        newLabCommentEvent.add(newCommentTypeCode);
        newLabCommentEvent.addElement("comments").addText(commentText + ".   Comment1");
        newLabCommentEvent.addElement("comments").addText(commentText + "    .Comment2");
        return newLabCommentEvent;
    }

    private Element makeLabTest(String labPrefix, String orderedTestCodePrefix) {
        Element newLabTest = DocumentHelper.createElement((String)"labTests");
        Element newProdedureCode = this.createHL72CodedElement("procedureCode", "ProcedureCode");
        newLabTest.add(newProdedureCode);
        Element newOrderedTestCode = this.createHL72CodedElement("orderedTestCode", orderedTestCodePrefix);
        newLabTest.add(newOrderedTestCode);
        newLabTest.addElement("fillerAccessionReference").addText("FillerAccessionReference");
        Element newChemistryResult = this.makeChemistryResult(labPrefix + ".ChemistryResult1");
        newLabTest.add(newChemistryResult);
        newChemistryResult = this.makeChemistryResult(labPrefix + ".ChemistryResult2");
        newLabTest.add(newChemistryResult);
        return newLabTest;
    }

    private Element makeUsMailingAddress(String elementName) {
        return BaseDatatypesBuilder.createUsMailingAddress(elementName);
    }

    public Element makeLabPatientVisit() {
        Element newLabPatientVisit = DocumentHelper.createElement((String)"patientVisit");
        newLabPatientVisit.addElement("patientClass").addText("PatientClass");
        Element newAssignedLocation = LabBuilder.createHL72LocationIdentifier("assignedLocation", "AssignedLocation");
        newLabPatientVisit.add(newAssignedLocation);
        Element newPriorLocation = LabBuilder.createHL72LocationIdentifier("priorLocation", "PriorLocation");
        newLabPatientVisit.add(newPriorLocation);
        Element attendingDoctor = this.createPractitionerLite("attendingDoctor", DOCTOR_IDS);
        newLabPatientVisit.add(attendingDoctor);
        newLabPatientVisit.addElement("hospitalService").addText("HospitalService");
        newLabPatientVisit.addElement("patientType").addText("PatientType");
        newLabPatientVisit.addElement("chargePriceIndicator").addText("ChargePriceIndicator");
        newLabPatientVisit.addElement("dischargeDisposition").addText("DischargeDisposition");
        newLabPatientVisit.addElement("servicingFacility").addText("ServicingFacility");
        Element newAdmissionDate = this.createFixedPointInTime("admissionDate");
        newLabPatientVisit.add(newAdmissionDate);
        newLabPatientVisit.addElement("alternateVisitId").addText("AlternateVisitId");
        return newLabPatientVisit;
    }

    public void printLabTestPromises(List<Element> listOfResults) {
        this.printDomainRecords(listOfResults);
    }

    public void printLabTestPromises(List<Element> listOfResults, Logger logger) {
        this.printDomainRecords(listOfResults, logger);
    }

    protected void printLabTestPromise(Element labTestPromise) {
        this.printDomainRecord(labTestPromise);
    }

    protected void printLabTestPromise(Element labTestPromise, Logger logger) {
        this.printDomainRecord(labTestPromise, logger);
    }

    @Override
    public String fillPrintBuffer(Object aOject) {
        String returnString = "";
        if (aOject != null && aOject instanceof Element) {
            returnString = ((Element)aOject).asXML();
        }
        return returnString;
    }

    private Element makeChemistryResult(String type) {
        Element newChemistryResult = DocumentHelper.createElement((String)"chemistryResults");
        newChemistryResult.addElement("valueInterpretation").addText("Interpretation" + type);
        Element newObservationDate = this.createFixedPointInTime("observationDate");
        newChemistryResult.add(newObservationDate);
        newChemistryResult.addElement("observationStatus").addText("Status" + type);
        Element newTestIdentifier = this.createHL72CodedElementExtended("testIdentifier", "TestCode" + type);
        newChemistryResult.add(newTestIdentifier);
        newChemistryResult.addElement("referenceRange").addText("VistaReferenceRange" + type);
        Element newComment1 = this.makeLabCommentEvent(type + ".LabCommentEvent1", "One");
        newChemistryResult.add(newComment1);
        Element newComment2 = this.makeLabCommentEvent(type + ".LabCommentEvent2", "Two");
        newChemistryResult.add(newComment2);
        newChemistryResult.addElement("observationValue").addText("ObservationValue");
        Element newObservationUnits = this.createHL72CodedElementLite("observationUnits", "ObservationUnits" + type);
        newChemistryResult.add(newObservationUnits);
        Element newDeviceIdentifier = this.createHL72EntityIdentifier("deviceIdentifier");
        newChemistryResult.add(newDeviceIdentifier);
        newChemistryResult.addElement("observationValueType").addText("ObservationValueType" + type);
        Element newProducerCode = this.createHL72CodedElement("producerCode", "ProducerCode" + type);
        newChemistryResult.add(newProducerCode);
        Element newVerifier = this.createPractitionerLite("verifier", VERIFIER_IDS);
        newChemistryResult.add(newVerifier);
        Element newAnalysisDate = this.createFixedPointInTime("analysisDate");
        newChemistryResult.add(newAnalysisDate);
        Element newPerformingOrganization = this.makePerformingOrganization();
        newChemistryResult.add(newPerformingOrganization);
        Element newObservationMethod1 = this.createObservationMethod(type + "1");
        newChemistryResult.add(newObservationMethod1);
        Element newObservationMethod2 = this.createObservationMethod(type + "2");
        newChemistryResult.add(newObservationMethod2);
        return newChemistryResult;
    }

    private Element createObservationMethod(String string) {
        Element newObservationMethod = DocumentHelper.createElement((String)"observationMethods");
        Element newObservationMethodCode = this.createHL72CodedElement("observationMethodCode", "AMethodCode" + string);
        newObservationMethod.add(newObservationMethodCode);
        return newObservationMethod;
    }

    private Element makeLabTestRequest() {
        Element newLabTestRequest = DocumentHelper.createElement((String)"labTestRequest");
        Element newAuthor = this.createPractitionerLite("author", AUTHOR_IDS);
        newLabTestRequest.add(newAuthor);
        Element newRequestingLocationIdentifier = LabBuilder.createHL72LocationIdentifier("requestingLocationIdentifier");
        newLabTestRequest.add(newRequestingLocationIdentifier);
        Element newRequestingOrganization = this.createHL72CodedElementLite("requestingOrganization", "ROCode");
        newLabTestRequest.add(newRequestingOrganization);
        Element newOrderingFacilityIdentifier = this.createHL72OrganizationIdentifierExtended("orderingFacilityIdentifier");
        newLabTestRequest.add(newOrderingFacilityIdentifier);
        Element newOrderingFacilityAddress = this.makeUsMailingAddress("orderingFacilityAddress");
        newLabTestRequest.add(newOrderingFacilityAddress);
        return newLabTestRequest;
    }

    private Element makePerformingOrganization() {
        Element newPerformingOrganization = DocumentHelper.createElement((String)"performingOrganization");
        Element newIdentifier = this.createHL72OrganizationIdentifierExtended("identifier");
        newPerformingOrganization.add(newIdentifier);
        Element newAddress = this.makeUsMailingAddress("address");
        newPerformingOrganization.add(newAddress);
        Element newMedicalDirector = this.createHL72PersonName("medicalDirector");
        newPerformingOrganization.add(newMedicalDirector);
        return newPerformingOrganization;
    }

    private Element makeSpecimen(String type) {
        Element newSpecimen = DocumentHelper.createElement((String)"specimen");
        Element newSpecimenSource = this.createHL72CodedElementExtended("specimenSource", "SSCode" + type);
        newSpecimen.add(newSpecimenSource);
        Element newSpecimenTakenDate = this.createPointInTime("specimenTakenDate");
        newSpecimen.add(newSpecimenTakenDate);
        Element newSpecimenReceivedDate = this.createPointInTime("specimenReceivedDate");
        newSpecimen.add(newSpecimenReceivedDate);
        newSpecimen.addElement("specimenAction").addText("SpecimenAction");
        return newSpecimen;
    }
}

