/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class IntoleranceConditionBuilder
extends AbstractEntryPointBuilder {
    private static int INTOLERANCE_CONDITION_IDX = 10000;
    private static final int INTOLERANCE_CONDITION_IDX_DEFAULT = 10000;
    public static final String FOOD_TYPE = "Food";
    public static final String DRUG_TYPE = "Drug";
    public static final String FOOD_DRUG_TYPE = "Food/Drug";
    public static final String OTHER_TYPE = "Other";
    public static final String[] ALLERGY_TYPES = new String[]{"Food", "Drug", "Food/Drug", "Other"};
    public static final String[] FOOD_ALLERGEN = new String[]{"Peanuts", "Protein", "MSG", "Starch"};
    public static final String[] DRUG_ALLERGEN = new String[]{"Sulfa", "Aspirin", "Codeine", "Penicillin"};
    public static final String[] FOOD_DRUG_ALLERGEN = new String[]{"FoodDrug1", "FoodDrug2", "FoodDrug3", "FoodDrug4"};
    public static final String[] OTHER_ALLERGEN = new String[]{"Other1", "Other2", "Other3", "Other4"};
    public static final String[] DRUG_CLASSES = new String[]{"Class1", "Class2", "Class3", "Class4", "Class5", "Class6"};
    public static final String[] DRUG_INGREDIENTS = new String[]{"Ingredient1", "Ingredient2", "Ingredient3", "Ingredient4", "Ingredient5", "Ingredient6"};
    public static final String[] REACTION = new String[]{"Hives", "Cough", "Seizure"};
    public static final String[] DATA_ENTERER_IDS = new String[]{"test_ENTERERID_1", "test_ENTERERID_2", "test_ENTERERID_3"};
    public static final String[] VERIFIER_IDS = new String[]{"test_VERIFIERID_2001", "test_VERIFIERID_2002", "test_VERIFIERID_2003", "test_VERIFIERID_2004", "test_IDS_2005"};
    public static final String[] IDBANDUPDATER_IDS = new String[]{"test_IDBANDUPDATERID_3001", "test_IDBANDUPDATERID_3002", "test_IDBANDUPDATERID_3003", "test_IDBANDUPDATERID_3004", "test_IDBANDUPDATERID_3005"};
    public static final String[] CHARTMARKER_IDS = new String[]{"test_CHARTMARKERID_4001", "test_CHARTMARKERID_4002", "test_CHARTMARKERID_4003", "test_CHARTMARKERID_4004", "test_CHARTMARKERID_4005"};
    public static final String[] ERRORENTERER_IDS = new String[]{"test_ERRORENTERERID_5001", "test_ERRORENTERERID_5002", "test_ERRORENTERERID_5003", "test_ERRORENTERERID_5004", "test_ERRORENTERERID_5005"};
    private HashMap<String, String[]> agents = new HashMap();

    public IntoleranceConditionBuilder() {
        this(new Random());
    }

    public IntoleranceConditionBuilder(Random aRandom) {
        super(aRandom);
        this.agents.put(FOOD_TYPE, FOOD_ALLERGEN);
        this.agents.put(DRUG_TYPE, DRUG_ALLERGEN);
        this.agents.put(FOOD_DRUG_TYPE, FOOD_DRUG_ALLERGEN);
        this.agents.put(OTHER_TYPE, OTHER_ALLERGEN);
    }

    public void resetIndex() {
        INTOLERANCE_CONDITION_IDX = 10000;
    }

    public Element makeInsertAllergy() {
        Element intoleranceCondition = this.makeAllergy();
        return intoleranceCondition;
    }

    public List<Element> makeInsertAllergies(int count) {
        List<Element> intoleranceConditions = this.makeAllergies(count);
        return intoleranceConditions;
    }

    public Element makeAllergy() {
        Element allergyType = this.createHL72CodedElementLite("allergyType", "AllergyType", ALLERGY_TYPES);
        return this.makeAllergy(allergyType, null, false);
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeAllergyWithPatient(personIdentifier);
    }

    public Element makeAllergyWithPatient(Element patient) {
        Element allergyType = this.createHL72CodedElementLite("allergyType", "AllergyType", ALLERGY_TYPES);
        return this.makeAllergy(allergyType, patient, false);
    }

    public Element makeAllergyWithCommentEvent(String comment) {
        Element newAllergyCommentEvent = this.makeAllergyCommentEvent("comment", comment, "commentEvent");
        return newAllergyCommentEvent;
    }

    public Element makeAllergyWithAllergyType(Element allergyType) {
        return this.makeAllergy(allergyType, null, false);
    }

    public Element makeAllergy(Element allergyType, Element patient) {
        return this.makeAllergy(allergyType, patient, false);
    }

    public Element makeAllergy(Element allergyType, Element patient, boolean repeatable) {
        Element allergy = this.createIntoleranceCondition(INTOLERANCE_CONDITION_IDX++, allergyType, patient, repeatable);
        return allergy;
    }

    public List<Element> makeAllergies(int number) {
        return this.makeAllergies(number, null);
    }

    public List<Element> makeAllergies(int number, Element patient) {
        Element allergyType = null;
        ArrayList<Element> allergies = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            allergyType = this.createHL72CodedElementLite("allergyType", "AllergyType", ALLERGY_TYPES);
            allergies.add(this.makeAllergy(allergyType, patient, false));
        }
        return allergies;
    }

    public List<Element> makeAllergies(Element allergyType, int aNumber) {
        return this.makeAllergies(allergyType, aNumber, this.random, null);
    }

    public List<Element> makeAllergies(Element allergyType, int number, Element patient) {
        return this.makeAllergies(allergyType, number, this.random, patient);
    }

    public List<Element> makeAllergies(Element allergyType, int number, Random random, Element patient) {
        ArrayList<Element> allergies = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            allergies.add(this.makeAllergy(allergyType, patient, false));
        }
        return allergies;
    }

    public List<Element> makeAllergies(Element allergyType, int number, Random random, Element patient, boolean resetIndex) {
        if (resetIndex) {
            this.resetIndex();
        }
        ArrayList<Element> allergies = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            allergies.add(this.makeAllergy(allergyType, patient, true));
        }
        return allergies;
    }

    private Element createIntoleranceCondition(int id, Element agentElement, Element patient, boolean repeatable) {
        Element element = DocumentHelper.createElement((String)"intoleranceConditions");
        element.add(this.createHL72EntityIdentifier("recordIdentifier", id));
        Element newPatient = this.createPatientLite("patient");
        if (patient != null) {
            newPatient.element("identifier").element("identity").setText(patient.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText(patient.elementText("assigningFacility"));
            newPatient.element("identifier").element("assigningAuthority").setText(patient.elementText("assigningAuthority"));
        }
        element.add(newPatient);
        element.add(this.createPointInTime("observationTime"));
        String allergyAgentValue = this.getRandomValueFromArray(this.agents.get(agentElement.element("code").getTextTrim()));
        element.add(this.createHL72CodedElementLite("agent", allergyAgentValue));
        element.add(this.createHL72CodedElementLite("allergyType", agentElement));
        element.add(this.createHL72CodedElement("gmrAllergyAgent", "Agent", allergyAgentValue));
        element.add(this.createHL72CodedElementLite("informationSourceCategory", "ISC "));
        element.add(this.createHL72CodedElementLite("mechanism", "Mechanism "));
        element.addElement("status").addText("Status");
        element.addElement("verified").addText("True");
        element.add(this.createReactionObservationEvent("reaction"));
        element.add(this.createReactionObservationEvent("reaction"));
        element.add(this.createPractitionerParticipationLite("verifier", "Verifier Comment", VERIFIER_IDS));
        element.add(this.createPractitionerParticipationLite("author", "Author Comment", AUTHOR_IDS));
        element.add(this.createPractitionerParticipationLite("errorEnterer", "ErrorEnterer Comment", ERRORENTERER_IDS));
        element.add(this.createPractitionerParticipationLite("idBandMarker", "ID Band Marker 1 Comment", IDBANDUPDATER_IDS));
        element.add(this.createPractitionerParticipationLite("idBandMarker", "ID Band Marker 2 Comment", IDBANDUPDATER_IDS));
        element.add(this.createPractitionerParticipationLite("chartMarker", "Chart Marker 1 Comment", CHARTMARKER_IDS));
        element.add(this.createPractitionerParticipationLite("chartMarker", "Chart Marker 2 Comment", CHARTMARKER_IDS));
        element.add(this.makeAllergyCommentEvent("commentEvents", "A comment event text 1", "commentEvent"));
        element.add(this.makeAllergyCommentEvent("commentEvents", "A comment event text 2", "commentEvent"));
        element.add(this.makeDrugClass("drugClass", "Drug Class 1", DRUG_CLASSES));
        element.add(this.makeDrugClass("drugClass", "Drug Class 2", DRUG_CLASSES));
        element.add(this.makeDrugIngredient("drugIngredient", "Drug Ing. 1", DRUG_INGREDIENTS));
        element.add(this.makeDrugIngredient("drugIngredient", "Drug Ing. 1", DRUG_INGREDIENTS));
        element.add(this.createHL72OrganizationIdentifier("facilityIdentifier"));
        element.add(this.createHL72FacilityIdentifier("recordSource"));
        element.addElement("recordVersion").addText(String.valueOf(id));
        element.add(this.createPointInTime("recordUpdateTime"));
        return element;
    }

    public void printIntoleranceConditions(List<Element> aListOfIntoleranceConditions) {
        this.printDomainRecords(aListOfIntoleranceConditions);
    }

    public void printIntoleranceConditions(List<Element> aListOfIntoleranceConditions, Logger aLogger) {
        this.printDomainRecords(aListOfIntoleranceConditions, aLogger);
    }

    public void printIntoleranceCondition(Element aIntoleranceCondition) {
        this.printDomainRecord(aIntoleranceCondition);
    }

    public void printIntoleranceCondition(Element aIntoleranceCondition, Logger aLogger) {
        this.printDomainRecord(aIntoleranceCondition, aLogger);
    }

    @Override
    public String fillPrintBuffer(Object aOject) {
        String returnString = "";
        if (aOject != null && aOject instanceof Element) {
            returnString = ((Element)aOject).asXML();
        }
        return returnString;
    }

    private Element makeAllergyCommentEvent(String elementName, String commentText, String codePrefix) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(this.createPointInTime("date"));
        element.add(this.createPractitionerLite("author", AUTHOR_IDS));
        element.add(this.createHL72CodedElementLite("commentType", codePrefix, "aCommentType"));
        element.addElement("comments").addText("theFirstComment");
        element.addElement("comments").addText("theSecondComment");
        return element;
    }

    private Element makeDrugClass(String elementName, String codePrefix, String[] codeValues) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(this.createHL72CodedElement("code", codePrefix, codeValues));
        return element;
    }

    private Element makeDrugIngredient(String elementName, String codePrefix, String[] codeValues) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(this.createHL72CodedElementLite("code", codePrefix, codeValues));
        return element;
    }

    public Element createReactionObservationEvent(String elementName) {
        Element element = DocumentHelper.createElement((String)elementName);
        element.add(this.createFixedPointInTime("observationTime"));
        element.add(this.createHL72CodedElementLite("reaction", "Reaction "));
        element.add(this.createPractitionerParticipationLite("author", "Comment"));
        return element;
    }

    public Element makeIntoleranceCondition(String elementName, String recordIdentifier) {
        Element intoleranceConditions = DocumentHelper.createElement((String)elementName);
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
        intoleranceConditions.add(newRecordIdentifier);
        return intoleranceConditions;
    }

    public Element makeIntoleranceCondition(String elementName, String recordIdentifier, String recordVersion) {
        Element intoleranceConditions = DocumentHelper.createElement((String)elementName);
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
        intoleranceConditions.add(newRecordIdentifier);
        Element newRecordVersion = DocumentHelper.createElement((String)"recordVersion");
        newRecordVersion.addText(recordVersion);
        intoleranceConditions.add(newRecordVersion);
        return intoleranceConditions;
    }
}

