/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HASkillTrackingBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HATrackingClinicalDomainBuilderFactoryInterface;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class HASkillTrackingBuilderFactory
implements HATrackingClinicalDomainBuilderFactoryInterface {
    private HASkillTrackingBuilder skillTrackingBuilder = null;

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) {
        this.buildDomainData(clinicalData, cnt, patientIdentifier, null);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier, String skillType) {
        this.buildDomainData(clinicalData, cnt, patientIdentifier, skillType);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier, String goalName, String entryDate) {
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        this.buildDomainData(clinicalData, recordIdentifier, recordStatus, null);
    }

    private void buildDomainData(Document clinicalData, String recordIdentifier, String recordStatus, String skillType) {
        Namespace xsiNS = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element rootElement = clinicalData.getRootElement();
        rootElement.add(xsiNS);
        Element patient = rootElement.element("patient");
        Element skillsTracking = this.skillTrackingBuilder.makeSkillTracking("skillsTracking", recordIdentifier, recordStatus, "skillTracking", skillType);
        patient.add(skillsTracking);
    }

    private void buildDomainData(Document clinicalData, int count, Element patientIdentifier, String skillType) {
        Namespace xsiNS = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element rootElement = clinicalData.getRootElement();
        rootElement.add(xsiNS);
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        Element skillTracking = this.skillTrackingBuilder.makeSkillTracking(patientIdentifier, count, updateRecordXml, skillType);
        patient.add(skillTracking);
    }

    public void setSkillTrackingBuilder(HASkillTrackingBuilder skillTrackingBuilder) {
        this.skillTrackingBuilder = skillTrackingBuilder;
    }

    @Override
    public void setBuilder(AbstractEntryPointBuilder builder) {
        this.setSkillTrackingBuilder((HASkillTrackingBuilder)builder);
    }
}

