/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.HAPainEventBuilder;
import org.dom4j.Document;
import org.dom4j.Element;

public class HAPainEventBuilderFactory
implements HAClinicalDomainBuilderFactoryInterface {
    private HAPainEventBuilder painEventBuilder = null;

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) {
        this.buildDomainData(clinicalData, cnt, patientIdentifier);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        this.buildDomainData(clinicalData, recordIdentifier, recordStatus);
    }

    private void buildDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        Element rootElement = clinicalData.getRootElement();
        Element patient = rootElement.element("patient");
        Element newPainEvents = this.painEventBuilder.makePainEvent("painEvents", recordIdentifier, recordStatus);
        patient.add(newPainEvents);
    }

    private void buildDomainData(Document clinicalData, int count, Element patientIdentifier) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        Element newPainEvents = this.painEventBuilder.makePainEvent(patientIdentifier, count, updateRecordXml);
        patient.add(newPainEvents);
    }

    @Override
    public void setBuilder(AbstractEntryPointBuilder builder) {
        this.setPainEventBuilder((HAPainEventBuilder)builder);
    }

    public HAPainEventBuilder getPainEventBuilder() {
        return this.painEventBuilder;
    }

    public void setPainEventBuilder(HAPainEventBuilder painEventBuilder) {
        this.painEventBuilder = painEventBuilder;
    }
}

