/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HAPainEventBuilder
extends AbstractEntryPointBuilder {
    private static String ASSIGNINGAUTHORITY_HDR = "USDOD";
    private static final String[] PAIN_QUALITIES = new String[]{"Aching", "Cramping", "Deep", "Dull"};
    private static final String[] PAIN_TREATMENTS = new String[]{"deep-breathing", "exercise", "icing", "medication"};
    private String recordIdentifier;
    private String painEntryDate;
    private int IDX;

    public HAPainEventBuilder() {
    }

    public HAPainEventBuilder(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
    }

    public HAPainEventBuilder(String recordIdentifier, String painEntryDate) {
        this.recordIdentifier = recordIdentifier;
        this.painEntryDate = painEntryDate;
    }

    public HAPainEventBuilder(Random random) {
        super(random);
    }

    public List<Element> makePainEvents(int number) {
        return this.makePainEvents(number, null);
    }

    public List<Element> makePainEvents(int number, Element patient) {
        return this.makePainEvents(number, patient, true);
    }

    public List<Element> makePainEvents(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> painEvents = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            painEvents.add(this.makePainEvent("painEvent", patient, updateRecordXml));
        }
        return painEvents;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makePainEvent("painEvent", personIdentifier);
    }

    public Element makePainEvent(String elementName, Element patientIdentifier) {
        return this.makePainEvent(elementName, patientIdentifier, false);
    }

    public Element makePainEvent(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.IDX;
        Element newPainEvent = DocumentHelper.createElement((String)elementName);
        Element newPatient = this.createPatientLite("patient");
        if (patientIdentifier != null) {
            newPatient.element("identifier").element("identity").setText(patientIdentifier.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText("200DOD");
            newPatient.element("identifier").element("assigningAuthority").setText(ASSIGNINGAUTHORITY_HDR);
        }
        newPainEvent.add(newPatient);
        Element newPainEventDate = this.painEntryDate != null ? this.createPointInTime("entryDate", this.painEntryDate) : this.createFixedPointInTime("entryDate");
        newPainEvent.add(newPainEventDate);
        newPainEvent.addElement("painType").addText("Acute Pain");
        newPainEvent.add(this.createZeroToTenRating("treatmentUsefulness"));
        newPainEvent.add(this.createZeroToTenRating("painLevel"));
        newPainEvent.add(this.createZeroToTenRating("painImpactOnMood"));
        newPainEvent.add(this.createZeroToTenRating("painInterference"));
        newPainEvent.add(this.createZeroToTenRating("sleepRefreshment"));
        newPainEvent.add(this.createZeroToTenRating("depressionLevel"));
        newPainEvent.add(this.createZeroToTenRating("impactOnFunction"));
        newPainEvent.addElement("comments").addText("comments");
        newPainEvent.addElement("painWorsenedBy").addText("painWorsenedBy");
        newPainEvent.addElement("painImprovedBy").addText("painImprovedBy");
        newPainEvent.addElement("dataEnterer").addText("dataEnterer");
        newPainEvent.addElement("painActivatedBy").addText("painActivatedBy");
        newPainEvent.addElement("allowAccessByClinicalStaff").addText("true");
        if (updateRecordXml) {
            if (this.recordIdentifier != null) {
                Element element = DocumentHelper.createElement((String)"recordIdentifier");
                element.addElement("identity").addText(this.recordIdentifier);
                element.addElement("namespaceId").addText("NamespaceId");
                element.addElement("universalId").addText("UniversalId");
                element.addElement("universalIdType").addText("UniversalIdType");
                newPainEvent.add(element);
            } else {
                Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", this.IDX);
                newPainEvent.add(newRecordIdentifier);
            }
        }
        Element painQualities = DocumentHelper.createElement((String)"painQualityToday");
        int i = this.recordIdentifier == null ? 0 : 1;
        for (int j = 0; j < 2; ++j) {
            painQualities.addElement("painQuality").addText(PAIN_QUALITIES[i]);
            ++i;
        }
        newPainEvent.add(painQualities);
        Element treatments = DocumentHelper.createElement((String)"treatments");
        int i2 = this.recordIdentifier == null ? 0 : 1;
        for (int j = 0; j < 2; ++j) {
            treatments.addElement("treatment").addText(PAIN_TREATMENTS[i2]);
            ++i2;
        }
        newPainEvent.add(treatments);
        return newPainEvent;
    }

    public Element makePainEvent(String elementName, String recordIdentifier, String recordStatus) {
        Element newPainEvents = DocumentHelper.createElement((String)elementName);
        Element newPainEvent = DocumentHelper.createElement((String)"painEvent");
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
        newPainEvent.add(newRecordIdentifier);
        newPainEvent.addElement("recordStatus").addText(recordStatus);
        newPainEvents.add(newPainEvent);
        return newPainEvents;
    }

    public Element makePainEvent(Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element newPainEvents = DocumentHelper.createElement((String)"painEvents");
        List<Element> painEventList = this.makePainEvents(countObservations, patientIdentifier, updateRecordXml);
        for (Element painEvent : painEventList) {
            newPainEvents.add(painEvent);
        }
        return newPainEvents;
    }

    @Override
    public String fillPrintBuffer(Object aObject) {
        return null;
    }
}

