/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HAPainAssessmentBuilder
extends AbstractEntryPointBuilder {
    private String recordIdentifier;
    private String painAssessmentDate;
    private int IDX;

    public HAPainAssessmentBuilder() {
    }

    public HAPainAssessmentBuilder(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
    }

    public HAPainAssessmentBuilder(String recordIdentifier, String painAssessmentDate) {
        this.recordIdentifier = recordIdentifier;
        this.painAssessmentDate = painAssessmentDate;
    }

    public HAPainAssessmentBuilder(Random random) {
        super(random);
    }

    public List<Element> makePainAssessments(int number) {
        return this.makePainAssessments(number, null);
    }

    public List<Element> makePainAssessments(int number, Element patient) {
        return this.makePainAssessments(number, patient, true);
    }

    public List<Element> makePainAssessments(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> painAssessment = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            painAssessment.add(this.makePainAssessment("painAssessment", patient, updateRecordXml));
        }
        return painAssessment;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makePainAssessment("painAssessment", personIdentifier);
    }

    public Element makePainAssessment(String elementName, Element patientIdentifier) {
        return this.makePainAssessment(elementName, patientIdentifier, false);
    }

    public Element makePainAssessment(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.IDX;
        Element newPainAssessmentEntry = DocumentHelper.createElement((String)elementName);
        Element newPatient = this.createPatientLite("patient");
        if (patientIdentifier != null) {
            newPatient.element("identifier").element("identity").setText(patientIdentifier.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText("200DOD");
            newPatient.element("identifier").element("assigningAuthority").setText("USDOD");
        }
        newPainAssessmentEntry.add(newPatient);
        Element newAssessmentDate = this.createFixedPointInTime("assessmentDate");
        newPainAssessmentEntry.add(newAssessmentDate);
        newPainAssessmentEntry.add(this.createZeroToTenRating("avgPainLevel"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("maxPainLevel"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("minPainLevel"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("painInterference"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("painImpactOnMood"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("painImpactOnWork"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("decreaseInSocial"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("sleepRefreshment"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("concernOfPainEnding"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("concernOfPainTolerance"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("concernOfExerciseInjury"));
        newPainAssessmentEntry.add(this.createZeroToTenRating("depressionLevel"));
        newPainAssessmentEntry.addElement("allowAccessByClinicalStaff").addText("true");
        if (updateRecordXml) {
            if (this.recordIdentifier != null) {
                Element element = DocumentHelper.createElement((String)"recordIdentifier");
                element.addElement("identity").addText(this.recordIdentifier);
                element.addElement("namespaceId").addText("NamespaceId");
                element.addElement("universalId").addText("UniversalId");
                element.addElement("universalIdType").addText("UniversalIdType");
                newPainAssessmentEntry.add(element);
            } else {
                Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", this.IDX);
                newPainAssessmentEntry.add(newRecordIdentifier);
            }
        }
        return newPainAssessmentEntry;
    }

    public Element makePainAssessment(String elementName, String recordIdentifier, String recordStatus) {
        Element newPainAssessments = DocumentHelper.createElement((String)elementName);
        Element newPainAssessment = DocumentHelper.createElement((String)"painAssessment");
        Element newRecordIdentifier = this.createHL72EntityIdentifier("recordIdentifier", recordIdentifier);
        newPainAssessment.add(newRecordIdentifier);
        newPainAssessment.addElement("recordStatus").addText(recordStatus);
        newPainAssessments.add(newPainAssessment);
        return newPainAssessments;
    }

    public Element makePainAssessment(Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element newPainAssessments = DocumentHelper.createElement((String)"painAssessments");
        List<Element> painAssessmentList = this.makePainAssessments(countObservations, patientIdentifier, updateRecordXml);
        for (Element painAssessment : painAssessmentList) {
            newPainAssessments.add(painAssessment);
        }
        return newPainAssessments;
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }
}

