/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAGoalTrackingBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HATrackingClinicalDomainBuilderFactoryInterface;
import org.dom4j.Document;
import org.dom4j.Element;

public class HAGoalTrackingBuilderFactory
implements HATrackingClinicalDomainBuilderFactoryInterface {
    private HAGoalTrackingBuilder goalTrackingBuilder = null;

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) {
        this.buildDomainData(clinicalData, cnt, patientIdentifier);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        this.buildDomainData(clinicalData, recordIdentifier, recordStatus);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, int count, Element patientIdentifier, String goalName) {
        this.buildDomainData(clinicalData, count, patientIdentifier, goalName);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, int count, Element patientIdentifier, String goalName, String entryDate) {
        this.buildDomainData(clinicalData, count, patientIdentifier, goalName, entryDate);
    }

    private void buildDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        Element rootElement = clinicalData.getRootElement();
        Element patient = rootElement.element("patient");
        Element newGoalsTracking = this.goalTrackingBuilder.makeGoalTracking("goalsTracking", recordIdentifier, recordStatus);
        patient.add(newGoalsTracking);
    }

    private void buildDomainData(Document clinicalData, int count, Element patientIdentifier) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        Element newGoalsTracking = this.goalTrackingBuilder.makeGoalTracking(patientIdentifier, count, updateRecordXml);
        patient.add(newGoalsTracking);
    }

    private void buildDomainData(Document clinicalData, int count, Element patientIdentifier, String goalName) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        if (goalName != null) {
            this.goalTrackingBuilder.setGoalName(goalName);
        }
        Element newGoalsTracking = this.goalTrackingBuilder.makeGoalTracking(patientIdentifier, count, updateRecordXml);
        patient.add(newGoalsTracking);
    }

    private void buildDomainData(Document clinicalData, int count, Element patientIdentifier, String goalName, String entryDate) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        if (goalName != null) {
            this.goalTrackingBuilder.setGoalName(goalName);
        }
        if (entryDate != null) {
            this.goalTrackingBuilder.setGoalEntryDate(entryDate);
        }
        Element newGoalsTracking = this.goalTrackingBuilder.makeGoalTracking(patientIdentifier, count, updateRecordXml);
        patient.add(newGoalsTracking);
    }

    @Override
    public void setBuilder(AbstractEntryPointBuilder builder) {
        this.setGoalTrackingBuilder((HAGoalTrackingBuilder)builder);
    }

    public HAGoalTrackingBuilder getGoalTrackingBuilder() {
        return this.goalTrackingBuilder;
    }

    public void setGoalTrackingBuilder(HAGoalTrackingBuilder goalTrackingBuilder) {
        this.goalTrackingBuilder = goalTrackingBuilder;
    }
}

