/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HADietJournalBuilder
extends AbstractEntryPointBuilder {
    private int IDX;
    private String recordIdentifier;
    private String physicalQty;
    private String attachmentName;

    public HADietJournalBuilder(String recordIdentifier, String physicalQty, String attachmentName) {
        this.recordIdentifier = recordIdentifier;
        this.physicalQty = physicalQty;
        this.attachmentName = attachmentName;
    }

    public HADietJournalBuilder(String recordIdentifier, String physicalQty) {
        this(recordIdentifier, physicalQty, null);
    }

    public HADietJournalBuilder() {
    }

    public HADietJournalBuilder(Random random) {
        super(random);
    }

    public HADietJournalBuilder(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
    }

    public List<Element> makeJournalEntries(int number) {
        return this.makeJournalEntries(number, null);
    }

    public List<Element> makeJournalEntries(int number, Element patient) {
        return this.makeJournalEntries(number, patient, true);
    }

    public List<Element> makeJournalEntries(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> journalEntry = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            journalEntry.add(this.makeJournalEntry("patientjournaling:patientEnteredDietJournalEntry", patient, updateRecordXml));
        }
        return journalEntry;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeJournalEntry("patientjournaling:patientEnteredDietJournalEntry", personIdentifier);
    }

    public Element makeJournalEntry(String elementName, Element patientIdentifier) {
        return this.makeJournalEntry(elementName, patientIdentifier, false);
    }

    public Element makeJournalEntry(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.IDX;
        Element newPatientJournalEntry = DocumentHelper.createElement((String)elementName);
        newPatientJournalEntry.addElement("mealType").addText("MealType");
        newPatientJournalEntry.add(this.createPointInTime("timeOfMeal"));
        if (this.physicalQty != null) {
            newPatientJournalEntry.add(this.createPhysicalQuantity("calories", this.physicalQty));
        } else {
            newPatientJournalEntry.add(this.createPhysicalQuantity("calories", "Calories"));
        }
        newPatientJournalEntry.add(this.createPhysicalQuantity("fat", "Fat"));
        newPatientJournalEntry.add(this.createPhysicalQuantity("carbohydrates", "Carbohydrates"));
        if (this.recordIdentifier != null) {
            newPatientJournalEntry.add(this.createGenericJournalEntryDetails("genericJournalEntryDetails", patientIdentifier, this.IDX, updateRecordXml, null, this.recordIdentifier, this.attachmentName));
        } else {
            newPatientJournalEntry.add(this.createGenericJournalEntryDetails("genericJournalEntryDetails", patientIdentifier, this.IDX, updateRecordXml));
        }
        return newPatientJournalEntry;
    }

    public Element makeDietPatientJournalEntry(Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element patientJournalEntries = DocumentHelper.createElement((String)"patientJournalEntries");
        List<Element> patientJournalEntryList = this.makeJournalEntries(countObservations, patientIdentifier, updateRecordXml);
        for (Element patientJournalEntry : patientJournalEntryList) {
            patientJournalEntries.add(patientJournalEntry);
        }
        return patientJournalEntries;
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }
}

