/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HAContactLogBuilder
extends AbstractEntryPointBuilder {
    protected static Log logger = null;
    public static final String LOGGER_CONFIG_PATH = "log4j.properties";
    protected static String ASSIGNINGAUTHORITY_HDR = "USDOD";
    private String recordIdentifier;
    private String personContacted;
    private int IDX;
    private boolean createTwoAttachmentsWithSameName;
    public static final String[] CONTACT_METHODS = new String[]{"Method 1", "Method 2", "Method 3", "Method 4"};

    public HAContactLogBuilder() {
    }

    public HAContactLogBuilder(String recordIdentifier, String personContacted) {
        this.recordIdentifier = recordIdentifier;
        this.personContacted = personContacted;
    }

    public HAContactLogBuilder(String recordIdentifier, String personContacted, boolean createTwoAttachmentsWithSameName) {
        this.recordIdentifier = recordIdentifier;
        this.personContacted = personContacted;
        this.createTwoAttachmentsWithSameName = createTwoAttachmentsWithSameName;
    }

    public HAContactLogBuilder(String recordIdentifier) {
        this.recordIdentifier = recordIdentifier;
    }

    public HAContactLogBuilder(Random random) {
        super(random);
    }

    public List<Element> makeJournalEntries(int number) {
        return this.makeJournalEntries(number, null);
    }

    public List<Element> makeJournalEntries(int number, Element patient) {
        return this.makeJournalEntries(number, patient, true);
    }

    public List<Element> makeJournalEntries(int number, Element patient, boolean updateRecordXml) {
        ArrayList<Element> journalEntry = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            journalEntry.add(this.makeJournalEntry("patientjournaling:patientEnteredContactLogJournalEntry", patient, updateRecordXml));
        }
        return journalEntry;
    }

    @Override
    public Element createEntryPointRecord(Element personIdentifier) {
        return this.makeJournalEntry("patientjournaling:patientEnteredContactLogJournalEntry", personIdentifier);
    }

    public Element makeJournalEntry(String elementName, Element patientIdentifier) {
        return this.makeJournalEntry(elementName, patientIdentifier, false);
    }

    public Element makeJournalEntry(String elementName, Element patientIdentifier, boolean updateRecordXml) {
        ++this.IDX;
        Element newPatientJournalEntry = DocumentHelper.createElement((String)elementName);
        Element newContactMethod = this.createHL72CodedElementLite("contactMethod", "ContactMethod", CONTACT_METHODS);
        newPatientJournalEntry.add(newContactMethod);
        newPatientJournalEntry.addElement("relatedTaskOrItem").addText("RelatedTaskOrItem");
        if (this.personContacted != null) {
            newPatientJournalEntry.addElement("personContacted").addText(this.personContacted);
        } else {
            newPatientJournalEntry.addElement("personContacted").addText("PersonContacted");
        }
        Element newContactDateTime = this.createFixedPointInTime("contactDateTime");
        newPatientJournalEntry.add(newContactDateTime);
        if (this.recordIdentifier != null) {
            newPatientJournalEntry.add(this.createGenericJournalEntryDetailsRecordId("genericJournalEntryDetails", patientIdentifier, this.IDX, updateRecordXml, this.recordIdentifier));
        } else {
            newPatientJournalEntry.add(this.createGenericJournalEntryDetails("genericJournalEntryDetails", patientIdentifier, this.IDX, updateRecordXml, this.createTwoAttachmentsWithSameName));
        }
        return newPatientJournalEntry;
    }

    public Element makeContactLogPatientJournalEntry(Element patientIdentifier, int countObservations, boolean updateRecordXml) {
        Element patientJournalEntries = DocumentHelper.createElement((String)"patientJournalEntries");
        List<Element> patientJournalEntryList = this.makeJournalEntries(countObservations, patientIdentifier, updateRecordXml);
        for (Element patientJournalEntry : patientJournalEntryList) {
            patientJournalEntries.add(patientJournalEntry);
        }
        return patientJournalEntries;
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }
}

