/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HACalendarEventBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAClinicalDomainBuilderFactoryInterface;
import org.dom4j.Document;
import org.dom4j.Element;

public class HACalendarEventBuilderFactory
implements HAClinicalDomainBuilderFactoryInterface {
    private HACalendarEventBuilder calendarEventBuilder = null;

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) {
        this.buildDomainData(clinicalData, cnt, patientIdentifier);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        this.buildDomainData(clinicalData, recordIdentifier, recordStatus);
    }

    private void buildDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        Element patient = rootElement.element("patient");
        Element newCalendarEvents = this.calendarEventBuilder.makeCalendarEvent("calendarEvents", recordIdentifier, recordStatus);
        patient.add(newCalendarEvents);
    }

    private void buildDomainData(Document clinicalData, int count, Element patientIdentifier) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        Element newCalendarEvents = this.calendarEventBuilder.makeCalendarEvent(patientIdentifier, count, updateRecordXml);
        patient.add(newCalendarEvents);
    }

    public void setCalendarEventBuilder(HACalendarEventBuilder calendarEventBuilder) {
        this.calendarEventBuilder = calendarEventBuilder;
    }

    @Override
    public void setBuilder(AbstractEntryPointBuilder builder) {
        this.setCalendarEventBuilder((HACalendarEventBuilder)builder);
    }
}

