/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAAssessmentDocumentBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HAClinicalDomainBuilderFactoryInterface;
import org.dom4j.Document;
import org.dom4j.Element;

public class HAAssessmentDocumentBuilderFactory
implements HAClinicalDomainBuilderFactoryInterface {
    private HAAssessmentDocumentBuilder assessmentDocumentBuilder;

    @Override
    public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) {
        this.buildAssessmentDocumentData(clinicalData, cnt, patientIdentifier);
    }

    @Override
    public void createClinicalDomainData(Document clinicalData, String recordIdentifier, String recordStatus) {
        this.buildAssessmentDocumentData(clinicalData, recordIdentifier, recordStatus);
    }

    private void buildAssessmentDocumentData(Document clinicalData, int count, Element patientIdentifier) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        boolean updateRecordXml = templateId.getText().endsWith("Update1");
        Element patient = rootElement.element("patient");
        Element assessmentDocuments = this.assessmentDocumentBuilder.makeAssessmentDocuments(patientIdentifier, count, updateRecordXml);
        patient.add(assessmentDocuments);
    }

    private void buildAssessmentDocumentData(Document clinicalData, String recordIdentifier, String recordStatus) {
        Element rootElement = clinicalData.getRootElement();
        Element templateId = rootElement.element("templateId");
        Element patient = rootElement.element("patient");
        Element patientEnteredVitalSigns = this.assessmentDocumentBuilder.makeAssessmentDocuments("assessmentDocuments", recordIdentifier, recordStatus);
        patient.add(patientEnteredVitalSigns);
    }

    public void setAssessmentDocumentBuilder(HAAssessmentDocumentBuilder assessmentDocumentBuilder) {
        this.assessmentDocumentBuilder = assessmentDocumentBuilder;
    }

    @Override
    public void setBuilder(AbstractEntryPointBuilder builder) {
        this.setAssessmentDocumentBuilder((HAAssessmentDocumentBuilder)builder);
    }
}

