/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.testharness.vhim400.builders.AllergyAssessmentBuilder;
import gov.va.med.cds.testharness.vhim400.builders.BaseDatatypesBuilder;
import gov.va.med.cds.testharness.vhim400.builders.BuilderTest;
import gov.va.med.cds.testharness.vhim400.builders.IntoleranceConditionBuilder;
import gov.va.med.cds.testharness.vhim400.builders.LabBuilder;
import gov.va.med.cds.testharness.vhim400.builders.NonVaMedBuilder;
import gov.va.med.cds.testharness.vhim400.builders.OutpatientMedicationPromiseBuilder;
import gov.va.med.cds.testharness.vhim400.builders.TiuBuilder;
import gov.va.med.cds.testharness.vhim400.builders.VitalsBuilder;
import org.dom4j.Element;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SuiteAwareRunner.class)
public class ClinicalDomainBuildersTest
extends BuilderTest {
    VitalsBuilder vitalsBuilder = new VitalsBuilder();
    LabBuilder labBuilder = new LabBuilder();
    IntoleranceConditionBuilder intoleranceConditionBuilder = new IntoleranceConditionBuilder();
    OutpatientMedicationPromiseBuilder outpatientMedicationPromiseBuilder = new OutpatientMedicationPromiseBuilder();
    AllergyAssessmentBuilder allergyAssessmentBuilder = new AllergyAssessmentBuilder();
    TiuBuilder tiuBuilder = new TiuBuilder();
    NonVaMedBuilder nonVaMedBuilder = new NonVaMedBuilder();

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateVitalsRecord() {
        Element vitalsElement = this.vitalsBuilder.createEntryPointRecord(null);
        Assert.assertNotNull((Object)vitalsElement);
        Assert.assertTrue((boolean)vitalsElement.hasContent());
        this.printElementToSystemOut(vitalsElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateVitalsRecordWithPersonIdentifier() {
        Element vitalsElement = this.vitalsBuilder.createEntryPointRecord(this.getPersonIdentifierElement("test_vital_identity"));
        Assert.assertNotNull((Object)vitalsElement);
        Assert.assertTrue((boolean)vitalsElement.hasContent());
        this.printElementToSystemOut(vitalsElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateLabRecord() {
        Element labElement = this.labBuilder.createEntryPointRecord(null);
        Assert.assertNotNull((Object)labElement);
        Assert.assertTrue((boolean)labElement.hasContent());
        this.printElementToSystemOut(labElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateLabRecordWithPersonIdentifier() {
        Element labElement = this.labBuilder.createEntryPointRecord(this.getPersonIdentifierElement("test_lab_identity"));
        Assert.assertNotNull((Object)labElement);
        Assert.assertTrue((boolean)labElement.hasContent());
        this.printElementToSystemOut(labElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateIntoleranceConditionRecord() {
        Element intoleranceConditionElement = this.intoleranceConditionBuilder.createEntryPointRecord(null);
        Assert.assertNotNull((Object)intoleranceConditionElement);
        Assert.assertTrue((boolean)intoleranceConditionElement.hasContent());
        this.printElementToSystemOut(intoleranceConditionElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateIntoleranceConditionRecordWithPersonIdentifier() {
        Element intoleranceConditionElement = this.intoleranceConditionBuilder.createEntryPointRecord(this.getPersonIdentifierElement("test_intolerance_identity"));
        Assert.assertNotNull((Object)intoleranceConditionElement);
        Assert.assertTrue((boolean)intoleranceConditionElement.hasContent());
        this.printElementToSystemOut(intoleranceConditionElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateOutpatientMedicationPromiseRecordWithPersonIdentifier() {
        Element outpatientMedicationPromiseElement = this.outpatientMedicationPromiseBuilder.createEntryPointRecord(this.getPersonIdentifierElement("test_opmpr_identity"));
        Assert.assertNotNull((Object)outpatientMedicationPromiseElement);
        Assert.assertTrue((boolean)outpatientMedicationPromiseElement.hasContent());
        this.printElementToSystemOut(outpatientMedicationPromiseElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testCreateOutpatientMedicationPromiseRecord() {
        Element outpatientMedicationPromiseElement = this.outpatientMedicationPromiseBuilder.createEntryPointRecord(null);
        Assert.assertNotNull((Object)outpatientMedicationPromiseElement);
        Assert.assertTrue((boolean)outpatientMedicationPromiseElement.hasContent());
        this.printElementToSystemOut(outpatientMedicationPromiseElement);
    }

    private Element getPersonIdentifierElement(String identity) {
        return BaseDatatypesBuilder.createHL72PersonIdentifier("patient", identity);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testAllergyAssesmentBuilder() throws Exception {
        Element allergyAssessmentElement = this.allergyAssessmentBuilder.createEntryPointRecord(null);
        Assert.assertNotNull((Object)allergyAssessmentElement);
        Assert.assertTrue((boolean)allergyAssessmentElement.hasContent());
        this.printElementToSystemOut(allergyAssessmentElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testAllergyAssesmentBuilderWithPersonIdentifier() throws Exception {
        Element allergyAssessmentElement = this.allergyAssessmentBuilder.createEntryPointRecord(this.getPersonIdentifierElement("test_allergy_assessment_identity"));
        Assert.assertNotNull((Object)allergyAssessmentElement);
        Assert.assertTrue((boolean)allergyAssessmentElement.hasContent());
        this.printElementToSystemOut(allergyAssessmentElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testTiuBuilder() throws Exception {
        Element clinicalDocumentEventElement = this.tiuBuilder.createEntryPointRecord(null);
        Assert.assertNotNull((Object)clinicalDocumentEventElement);
        Assert.assertTrue((boolean)clinicalDocumentEventElement.hasContent());
        this.printElementToSystemOut(clinicalDocumentEventElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testTiuBuilderWithPersonIdentifier() throws Exception {
        Element clinicalDocumentEventElement = this.tiuBuilder.createEntryPointRecord(this.getPersonIdentifierElement("test_clinicalDocumentEvent_identity"));
        Assert.assertNotNull((Object)clinicalDocumentEventElement);
        Assert.assertTrue((boolean)clinicalDocumentEventElement.hasContent());
        this.printElementToSystemOut(clinicalDocumentEventElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testNonVaMedBuilder() throws Exception {
        Element nonVAMedicationElement = this.nonVaMedBuilder.createEntryPointRecord(null);
        Assert.assertNotNull((Object)nonVAMedicationElement);
        Assert.assertTrue((boolean)nonVAMedicationElement.hasContent());
        this.printElementToSystemOut(nonVAMedicationElement);
    }

    @Test
    @Suite(groups={"prototypetest"})
    public void testNonVaMedBuilderWithPersonIdentifier() throws Exception {
        Element nonVAMedicationElement = this.nonVaMedBuilder.createEntryPointRecord(this.getPersonIdentifierElement("test_nonVaMedicationEvent_identity"));
        Assert.assertNotNull((Object)nonVAMedicationElement);
        Assert.assertTrue((boolean)nonVAMedicationElement.hasContent());
        this.printElementToSystemOut(nonVAMedicationElement);
    }
}

