/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.vhim400.builders;

import gov.va.med.cds.testharness.vhim400.builders.AbstractEntryPointBuilder;
import gov.va.med.cds.testharness.vhim400.builders.BaseDatatypesBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AllergyAssessmentBuilder
extends AbstractEntryPointBuilder {
    private static int ALLERGY_ASSESSMENT_IDX = 10000;
    private static final String[] AUTHOR_IDS = new String[]{"test_authorid_1001", "test_authorid_1002", "test_authorid_1003", "test_authorid_1004"};

    public AllergyAssessmentBuilder() {
    }

    public AllergyAssessmentBuilder(Random aRandom) {
        super(aRandom);
    }

    public Element makeInsertAllergyAssessment() {
        return this.makeAllergyAssessment();
    }

    public List<Element> makeInsertAllergyAssessments(int count) {
        List<Element> allergyAssessments = this.makeAllergyAssessments(count);
        return allergyAssessments;
    }

    public Element makeAllergyAssessment() {
        return this.makeAllergyAssessment(null);
    }

    public List<Element> makeAllergyAssessments(int aNumber) {
        return this.makeAllergyAssessments(aNumber, null);
    }

    public Element makeAllergyAssessment(Element patient) {
        Element allergyAssessment = this.createAllergyAssessment(ALLERGY_ASSESSMENT_IDX++, patient);
        return allergyAssessment;
    }

    public List<Element> makeAllergyAssessments(int number, Element patient) {
        ArrayList<Element> allergies = new ArrayList<Element>(number);
        for (int i = 0; i < number; ++i) {
            allergies.add(this.makeAllergyAssessment(patient));
        }
        return allergies;
    }

    @Override
    public Element createEntryPointRecord(Element aPersonIdentifier) {
        return this.makeAllergyAssessment(aPersonIdentifier);
    }

    private Element createAllergyAssessment(int id, Element patient) {
        Element allergyAssessment = DocumentHelper.createElement((String)"allergyAssessments");
        this.setAllergyAssessmentValues(allergyAssessment, id, patient);
        return allergyAssessment;
    }

    private void setAllergyAssessmentValues(Element allergyAssessment, int id, Element patient) {
        allergyAssessment.add(BaseDatatypesBuilder.createHL72EntityIdentifier("recordIdentifier"));
        Element newPatient = this.createPatientLite("patient");
        if (patient != null) {
            newPatient.element("identifier").element("identity").setText(patient.elementText("identity"));
            newPatient.element("identifier").element("assigningFacility").setText(patient.elementText("assigningFacility"));
            newPatient.element("identifier").element("assigningAuthority").setText(patient.elementText("assigningAuthority"));
        }
        allergyAssessment.add(newPatient);
        allergyAssessment.add(BaseDatatypesBuilder.createPointInTime("observationTime"));
        allergyAssessment.add(BaseDatatypesBuilder.createHL72CodedElementLite("assessmentValue", "codePrefix_?"));
        allergyAssessment.add(this.createSimpleStringElement("status", "Status"));
        Element author = this.createPractitionerParticipationLite("author", "Author Comment", AUTHOR_IDS);
        allergyAssessment.add(author);
        allergyAssessment.add(this.createHL72FacilityIdentifier("recordSource"));
        allergyAssessment.add(this.createSimpleStringElement("recordVersion", "1"));
        allergyAssessment.add(BaseDatatypesBuilder.createPointInTime("recordUpdateTime"));
    }

    public void printAllergyAssessments(List<Element> listOfResults) {
        this.printDomainRecords(listOfResults);
    }

    public void printAllergyAssessments(List<Element> listOfResults, Logger aLogger) {
        this.printDomainRecords(listOfResults, aLogger);
    }

    public void printAllergyAssessment(Element allergy) {
        this.printDomainRecord(allergy);
    }

    public void printAllergyAssessment(Element allergy, Logger logger) {
        this.printDomainRecord(allergy, logger);
    }

    @Override
    public String fillPrintBuffer(Object object) {
        String returnString = "";
        if (object != null && object instanceof Element) {
            returnString = ((Element)object).asXML();
        }
        return returnString;
    }
}

