/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.testharness.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class TemplateJarHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unjar(String pathToXsdTemplateCache, String templateId) throws IOException {
        InputStream ios = null;
        FileOutputStream fos = null;
        String pathToJar = String.format("%s/%s.jar", pathToXsdTemplateCache, templateId);
        String unjarDirectoryPath = String.format("%s/%s/", pathToXsdTemplateCache, templateId);
        TemplateJarHelper.deleteDirectory(unjarDirectoryPath);
        try {
            JarFile jarFile = new JarFile(pathToJar);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                File file = new File(unjarDirectoryPath, jarEntry.getName());
                if (jarEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                ios = jarFile.getInputStream(jarEntry);
                fos = new FileOutputStream(file);
                while (ios.available() > 0) {
                    fos.write(ios.read());
                }
            }
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    ios.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void deleteDirectory(String directoryPath) throws IOException {
        File folder = new File(directoryPath);
        String[] files = null;
        if (folder.isDirectory() && (files = folder.list()).length > 0) {
            for (String filename : files) {
                File f = new File(folder, filename);
                if (f.isDirectory()) {
                    TemplateJarHelper.deleteDirectory(f.getCanonicalPath());
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }
}

