/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.repositories.fpds.ejb;

import gov.va.med.cds.audit.persistence.CdsAuditClobStore;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.hapi.HL7Utility;
import gov.va.med.repositories.fpds.ejb.AbstractFpdsVistAHl7CreateRequestMdb;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.interceptor.Interceptors;
import javax.jms.JMSException;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

@Interceptors(value={SpringBeanAutowiringInterceptor.class})
public class FpdsVistAHl7CreateRequestMdb
extends AbstractFpdsVistAHl7CreateRequestMdb {
    private static String CLIENT_INITIATION_TIME = "CLIENT_INITIATION_TIME";
    private static String CLIENT_NAME = "CLIENT_NAME";
    private static String PATIENT_AUTHORITY = "PATIENT_AUTHORITY";
    private static String DOMAIN = "DOMAIN";
    private static final String DEFAULT_AUTHORITY = "USVHA";

    public void ejbCreate() {
        this.defaultDomainEnvEntry = (String)this.safeGetEnvironmentEntry("java:comp/env/defaultDomainType", String.class, "TIUHL7");
    }

    @Override
    protected String sendHl7Request(String host, String hl7Message) {
        Properties properties = new Properties();
        properties.setProperty("DNS", host);
        return this.dnsSocketProxy.sendMessage(hl7Message, properties);
    }

    @Override
    protected Map<String, String> getMessageProperties(HL7SupportInterface message) throws JMSException {
        String authority = DEFAULT_AUTHORITY;
        String clientName = message.getSendingApplication();
        HashMap<String, String> messageProperties = new HashMap<String, String>(8);
        messageProperties.put(REQUEST_ID, message.getMessageControlId());
        messageProperties.put(CLIENT_INITIATION_TIME, message.getMessageDateTime());
        messageProperties.put(CLIENT_NAME, clientName);
        messageProperties.put(PATIENT_FACILITY, message.getReceivingFacilityStation());
        messageProperties.put(PATIENT_AUTHORITY, authority);
        messageProperties.put(RECORD_UPDATE_TIME, message.getMessageDateTime());
        messageProperties.put(DOMAIN, this.defaultDomainEnvEntry);
        return messageProperties;
    }

    @Override
    protected CdsAuditClobStore buildAuditClobStore(Map<String, String> messageProperties, String hl7Payload) {
        CdsAuditClobStore auditClobStore = new CdsAuditClobStore();
        auditClobStore.setFacilityId(messageProperties.get(PATIENT_FACILITY));
        auditClobStore.setRequestId(messageProperties.get(REQUEST_ID));
        auditClobStore.setTemplateId(TEMPLATE_ID);
        auditClobStore.setHl7Clob(hl7Payload);
        auditClobStore.setMessageDateTime(messageProperties.get(RECORD_UPDATE_TIME));
        auditClobStore.setMessageType(messageProperties.get(DOMAIN));
        auditClobStore.setClientIdentifier(messageProperties.get(CLIENT_NAME));
        auditClobStore.setClientRequestInitiationTime(messageProperties.get(CLIENT_INITIATION_TIME));
        return auditClobStore;
    }

    @Override
    protected String buildCommitReject(String originalMessageControlId, String rejectMsg, HL7SupportInterface hl7Support) {
        String commitReject = "UNKNOWN ERROR PROCESSING REQUEST: " + rejectMsg;
        if (hl7Support != null) {
            commitReject = hl7Support.createHl7WriteAckReject(rejectMsg);
        } else {
            String messageDate = this.getCurrentTime();
            String origMessageContId = originalMessageControlId;
            String receivingFacility = "HDR_HL7_SERVER";
            String sendingFacility = "TIU_CLIENT";
            String receivingApp = "TIUHL7";
            String sendingApp = "HDRAPP";
            String messageControlId = HL7Utility.createMessageControlId();
            StringBuffer commitRejectBuf = new StringBuffer();
            commitRejectBuf.append("MSH^~|\\&^" + receivingApp + "^" + receivingFacility + "^" + sendingApp + "^" + sendingFacility + "^" + messageDate + "^^ACK^" + messageControlId + "^T^2.4");
            commitRejectBuf.append("\r");
            commitRejectBuf.append("MSA^CR^" + origMessageContId + "^" + rejectMsg);
            commitReject = commitRejectBuf.toString();
        }
        return commitReject;
    }
}

