/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.repositories.fpds.ejb;

import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.util.LogMessageUtil;
import gov.va.med.repositories.fpds.ejb.AbstractBaseFpdsVistAMdb;
import java.nio.ByteBuffer;
import javax.interceptor.Interceptors;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

@Interceptors(value={SpringBeanAutowiringInterceptor.class})
public class FpdsVistAHl7AckResponseMdb
extends AbstractBaseFpdsVistAMdb
implements MessageListener {
    public void onMessage(Message message) {
        block11: {
            HL7SupportInterface hl7Support = null;
            String responseDestinationJndiName = null;
            String hl7AckResponse = null;
            try {
                byte[] messageBytes = null;
                if (message instanceof BytesMessage) {
                    BytesMessage bytesMsg = (BytesMessage)message;
                    int msgLength = (int)bytesMsg.getBodyLength();
                    messageBytes = new byte[msgLength];
                    bytesMsg.readBytes(messageBytes);
                } else if (message instanceof TextMessage) {
                    TextMessage textMsg = (TextMessage)message;
                    messageBytes = textMsg.getText().getBytes();
                }
                ByteBuffer messageBuffer = ByteBuffer.wrap(messageBytes);
                hl7AckResponse = new String(messageBuffer.array());
                hl7Support = HL7SupportHAPI.createTranslationSupport((String)hl7AckResponse);
                responseDestinationJndiName = this.hL7Utility.getSendingApplicaionDestination(hl7Support.getReceivingApplication());
                if (hl7AckResponse == null) break block11;
                try {
                    String errMsg;
                    String responseMessage = hl7AckResponse;
                    String responseRequestId = hl7Support.getAckOriginalMessageControlId();
                    InitialContext context = new InitialContext();
                    Destination destination = null;
                    try {
                        destination = (Destination)context.lookup(responseDestinationJndiName);
                    }
                    catch (Exception ee) {
                        errMsg = "Failed to resolve the JNDI name for the JMS response destination - could not send ack response: " + responseMessage;
                        this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)responseRequestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ee);
                    }
                    if (destination == null) break block11;
                    try {
                        this.sendAckToDestination(responseMessage, responseRequestId, destination);
                    }
                    catch (Exception ex1) {
                        errMsg = "Failed to resolve the response JMS destination - could not send ack response: " + responseMessage;
                        this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)responseRequestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ex1);
                    }
                }
                catch (Exception ex2) {
                    String errMsg = "Failed to publish response message ACK to a JMS destination - could not send ack response: " + hl7AckResponse;
                    this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)hl7Support.getAckOriginalMessageControlId(), (String)this.fpdsAppName, (String)errMsg), (Throwable)ex2);
                }
            }
            catch (Exception e) {
                String errMsg = "Failed to extract and publish response message ACK to a JMS destination - could not send ack response: " + hl7AckResponse;
                if (this.logger == null || hl7Support == null) break block11;
                this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)hl7Support.getAckOriginalMessageControlId(), (String)this.fpdsAppName, (String)errMsg), (Throwable)e);
            }
        }
    }
}

