/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.repositories.fpds.ejb;

import gov.va.med.cds.audit.persistence.CdsAuditClobStore;
import gov.va.med.cds.audit.persistence.CdsAuditClobStoreInterface;
import gov.va.med.cds.client.proxy.NetworkClientProxyInterface;
import gov.va.med.cds.hapi.HL7SupportHAPI;
import gov.va.med.cds.hapi.HL7SupportInterface;
import gov.va.med.cds.util.DateTimeUtil;
import gov.va.med.cds.util.LogMessageUtil;
import gov.va.med.repositories.fpds.ejb.AbstractBaseFpdsVistAMdb;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.interceptor.Interceptors;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jndi.JndiTemplate;
import org.springframework.util.StringUtils;

@Interceptors(value={SpringBeanAutowiringInterceptor.class})
public abstract class AbstractFpdsVistAHl7CreateRequestMdb
extends AbstractBaseFpdsVistAMdb
implements MessageListener {
    protected static String REQUEST_ID = "REQUEST_ID";
    protected static String NO_REQUEST_ID_PROVIDED = "NO_REQUEST_ID";
    protected static String PATIENT_FACILITY = "PATIENT_FACILITY";
    protected static String RECORD_UPDATE_TIME = "RECORD_UPDATE_TIME";
    protected static String TEMPLATE_ID = "<<VISTA_HL7LISTENER_WRITE>>";
    protected JndiTemplate jndiTemplate = new JndiTemplate();
    protected String fpdsAppName = "FPDS";
    protected String defaultDomainEnvEntry = "defaultDomainType";
    @Autowired
    @Qualifier(value="dnsSocketProxy")
    protected NetworkClientProxyInterface dnsSocketProxy;
    @Autowired
    @Qualifier(value="persistenceAuditClobStore")
    protected CdsAuditClobStoreInterface persistenceAuditClobStore;

    protected abstract Map<String, String> getMessageProperties(HL7SupportInterface var1) throws JMSException;

    protected abstract String sendHl7Request(String var1, String var2);

    protected abstract CdsAuditClobStore buildAuditClobStore(Map<String, String> var1, String var2);

    protected abstract String buildCommitReject(String var1, String var2, HL7SupportInterface var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block35: {
            String responseDestinationJndiName;
            String response;
            String requestId;
            HL7SupportInterface hl7Support;
            block34: {
                hl7Support = null;
                requestId = null;
                String facilityId = null;
                response = null;
                String host = null;
                responseDestinationJndiName = null;
                Map<String, String> messageProperties = null;
                boolean valitionError = false;
                StringBuffer errorValidationMessage = new StringBuffer();
                try {
                    byte[] messageBytes = null;
                    if (message instanceof BytesMessage) {
                        BytesMessage bytesMsg = (BytesMessage)message;
                        int msgLength = (int)bytesMsg.getBodyLength();
                        messageBytes = new byte[msgLength];
                        bytesMsg.readBytes(messageBytes);
                    } else if (message instanceof TextMessage) {
                        TextMessage textMsg = (TextMessage)message;
                        messageBytes = textMsg.getText().getBytes();
                    }
                    ByteBuffer messageBuffer = ByteBuffer.wrap(messageBytes);
                    String hl7Payload = new String(messageBuffer.array());
                    hl7Support = HL7SupportHAPI.createTranslationSupport((String)hl7Payload);
                    messageProperties = this.getMessageProperties(hl7Support);
                    responseDestinationJndiName = this.hL7Utility.getSendingApplicaionDestination(hl7Support.getSendingApplication());
                    facilityId = messageProperties.get(PATIENT_FACILITY);
                    host = hl7Support.getReceivingFacility();
                    requestId = messageProperties.get(REQUEST_ID);
                    valitionError = this.validateMsh(hl7Support, requestId, facilityId, host, messageProperties, valitionError, errorValidationMessage);
                    if (valitionError) {
                        errorValidationMessage.append(" Cannot process JMS Message.");
                        requestId = requestId != null ? requestId : NO_REQUEST_ID_PROVIDED;
                        response = this.buildCommitReject(requestId, errorValidationMessage.toString(), hl7Support);
                        break block34;
                    }
                    try {
                        CdsAuditClobStore auditClobStore = this.buildAuditClobStore(messageProperties, hl7Payload);
                        this.persistenceAuditClobStore.persistCdsAuditClob(auditClobStore);
                    }
                    catch (Exception auditException) {
                        String msg = "Exception auditing Hl7 ViatA write request.";
                        this.logger.error((Object)LogMessageUtil.buildMessage((String)this.defaultDomainEnvEntry, (String)requestId, (String)this.fpdsAppName, (String)msg), (Throwable)auditException);
                    }
                    response = this.sendHl7Request(host, hl7Payload);
                }
                catch (Exception e) {
                    try {
                        String msg = "Exception occured while processing FPDS Hl7 write request: " + e.getMessage();
                        requestId = requestId != null ? requestId : NO_REQUEST_ID_PROVIDED;
                        response = this.buildCommitReject(requestId, msg, hl7Support);
                        this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.fpdsAppName, (String)msg), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        hl7Support = HL7SupportHAPI.createTranslationSupport(response);
                        String ackType = hl7Support.getAcknowledgementCode();
                        if (response != null && ackType != null && (ackType.equals("CR") || ackType.equals("CE"))) {
                            try {
                                String errMsg;
                                String responseMessage = response;
                                String responseRequestId = requestId;
                                Destination defaultDestination = this.responseJmsTemplate.getDefaultDestination();
                                InitialContext context = new InitialContext();
                                Destination destination = null;
                                try {
                                    destination = (Destination)context.lookup(responseDestinationJndiName);
                                }
                                catch (Exception ee) {
                                    errMsg = "Failed to resolve the JNDI name for the JMS response destination - could not send ack response: " + responseMessage;
                                    this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ee);
                                }
                                if (destination != null) {
                                    try {
                                        this.sendAckToDestination(responseMessage, responseRequestId, destination);
                                    }
                                    catch (Exception ex1) {
                                        errMsg = "Failed to resolve the response JMS destination - could not send ack response: " + responseMessage;
                                        this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ex1);
                                        this.sendAckToDestination(responseMessage, responseRequestId, defaultDestination);
                                    }
                                } else {
                                    this.sendAckToDestination(responseMessage, responseRequestId, defaultDestination);
                                }
                            }
                            catch (Exception ex2) {
                                String errMsg = "Failed to publish response message to a JMS destination - could not send ack response: " + response;
                                this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ex2);
                            }
                        }
                        throw throwable;
                    }
                    hl7Support = HL7SupportHAPI.createTranslationSupport((String)response);
                    String ackType = hl7Support.getAcknowledgementCode();
                    if (response == null || ackType == null || !ackType.equals("CR") && !ackType.equals("CE")) break block35;
                    try {
                        String errMsg;
                        String responseMessage = response;
                        String responseRequestId = requestId;
                        Destination defaultDestination = this.responseJmsTemplate.getDefaultDestination();
                        InitialContext context = new InitialContext();
                        Destination destination = null;
                        try {
                            destination = (Destination)context.lookup(responseDestinationJndiName);
                        }
                        catch (Exception ee) {
                            errMsg = "Failed to resolve the JNDI name for the JMS response destination - could not send ack response: " + responseMessage;
                            this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ee);
                        }
                        if (destination != null) {
                            try {
                                this.sendAckToDestination(responseMessage, responseRequestId, destination);
                            }
                            catch (Exception ex1) {
                                errMsg = "Failed to resolve the response JMS destination - could not send ack response: " + responseMessage;
                                this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ex1);
                                this.sendAckToDestination(responseMessage, responseRequestId, defaultDestination);
                            }
                        }
                        this.sendAckToDestination(responseMessage, responseRequestId, defaultDestination);
                    }
                    catch (Exception ex2) {
                        String errMsg = "Failed to publish response message to a JMS destination - could not send ack response: " + response;
                        this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ex2);
                    }
                }
            }
            hl7Support = HL7SupportHAPI.createTranslationSupport((String)response);
            String ackType = hl7Support.getAcknowledgementCode();
            if (response != null && ackType != null && (ackType.equals("CR") || ackType.equals("CE"))) {
                try {
                    String errMsg;
                    String responseMessage = response;
                    String responseRequestId = requestId;
                    Destination defaultDestination = this.responseJmsTemplate.getDefaultDestination();
                    InitialContext context = new InitialContext();
                    Destination destination = null;
                    try {
                        destination = (Destination)context.lookup(responseDestinationJndiName);
                    }
                    catch (Exception ee) {
                        errMsg = "Failed to resolve the JNDI name for the JMS response destination - could not send ack response: " + responseMessage;
                        this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ee);
                    }
                    if (destination != null) {
                        try {
                            this.sendAckToDestination(responseMessage, responseRequestId, destination);
                        }
                        catch (Exception ex1) {
                            errMsg = "Failed to resolve the response JMS destination - could not send ack response: " + responseMessage;
                            this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ex1);
                            this.sendAckToDestination(responseMessage, responseRequestId, defaultDestination);
                        }
                        break block35;
                    }
                    this.sendAckToDestination(responseMessage, responseRequestId, defaultDestination);
                }
                catch (Exception ex2) {
                    String errMsg = "Failed to publish response message to a JMS destination - could not send ack response: " + response;
                    this.logger.error((Object)LogMessageUtil.buildMessage(null, (String)requestId, (String)this.fpdsAppName, (String)errMsg), (Throwable)ex2);
                }
            }
        }
    }

    private boolean validateMsh(HL7SupportInterface hl7Support, String requestId, String facilityId, String host, Map<String, String> messageProperties, boolean valitionErrorThrown, StringBuffer errorValidationMessage) {
        String messageDateTime;
        if (StringUtils.isEmpty((Object)hl7Support.getSendingApplication())) {
            valitionErrorThrown = true;
            errorValidationMessage.append("Sending Application  (MSH-3-1) is missing from the message. ");
        }
        if (StringUtils.isEmpty((Object)hl7Support.getStationNumber()) || StringUtils.isEmpty((Object)hl7Support.getSendingFacility()) || StringUtils.isEmpty((Object)hl7Support.getSendingFacilityType())) {
            valitionErrorThrown = true;
            errorValidationMessage.append("MSH-4 Sending Facility is missing one or more of the 3 required components. ");
        }
        if (StringUtils.isEmpty((Object)hl7Support.getReceivingApplication())) {
            valitionErrorThrown = true;
            errorValidationMessage.append("Receiving Application (MSH-5-1) is missing from the message. ");
        }
        if (StringUtils.isEmpty((Object)facilityId) || StringUtils.isEmpty((Object)host) || StringUtils.isEmpty((Object)hl7Support.getReceivingFacilityType())) {
            valitionErrorThrown = true;
            errorValidationMessage.append(" MSH-6 Receiving Facility is missing one or more of the 3 required components. ");
        }
        if (StringUtils.isEmpty((Object)(messageDateTime = messageProperties.get(RECORD_UPDATE_TIME)))) {
            valitionErrorThrown = true;
            errorValidationMessage.append("MessageDateTime (MSH-7-1) is missing from the message. ");
        } else if (!DateTimeUtil.isDateValidHl7Format((String)messageDateTime)) {
            valitionErrorThrown = true;
            errorValidationMessage.append("MessageDateTime (MSH-7-1) is an invalid date or is not in the correct date time format 'yyyyMMddHHmmssZ' - " + messageDateTime);
        }
        if (StringUtils.isEmpty((Object)requestId)) {
            valitionErrorThrown = true;
            errorValidationMessage.append("MessageControlId (MSH-10)is missing from the message. ");
        }
        return valitionErrorThrown;
    }

    public void setResponseJmsTemplate(JmsTemplate responseJmsTemplate) {
        this.responseJmsTemplate = responseJmsTemplate;
    }

    protected String getCurrentTime() {
        return DateTimeUtil.getCurrentDateTime((String)"yyyyMMddHHmmssZ");
    }
}

