/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.client;

import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.client.ClinicalDataServiceProxy;
import gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface;
import gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterfaceLocator;
import gov.va.med.cds.exception.ClinicalDataServiceCreateException;
import gov.va.med.cds.util.EndpointResolver;
import java.net.MalformedURLException;
import java.net.URL;

public class ClinicalDataServiceFactory {
    private String serviceBindingId = null;
    private EndpointResolver endpointResolver = null;

    public synchronized ClinicalDataServiceInterface create() {
        try {
            return this.getBusinessDelegate();
        }
        catch (Exception ex) {
            throw new ClinicalDataServiceCreateException("Could not create CDS web service client.", ex);
        }
    }

    private ClinicalDataServiceInterface getBusinessDelegate() {
        try {
            URL endpoint = new URL(this.endpointResolver.resolve(this.serviceBindingId));
            String endPointAsString = endpoint.toString();
            if (null != endPointAsString && !endPointAsString.contains("?")) {
                try {
                    endpoint = new URL(endPointAsString + "?wsdl");
                }
                catch (MalformedURLException e) {
                    throw new Exception(e);
                }
            }
            ClinicalDataServiceSynchronousInterfaceLocator locator = new ClinicalDataServiceSynchronousInterfaceLocator(endpoint);
            ClinicalDataServiceSynchronousInterface port = locator.getClinicalDataServiceSynchronousInterfaceHttpPort();
            ClinicalDataServiceProxy serviceDelegate = new ClinicalDataServiceProxy();
            serviceDelegate.setProxy(port);
            return serviceDelegate;
        }
        catch (Exception e) {
            throw new ClinicalDataServiceCreateException("Error find ing CDS service in look-up registry", e);
        }
    }

    public void setEndpointResolver(EndpointResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
    }

    public void setServiceBindingId(String serviceBindingId) {
        this.serviceBindingId = serviceBindingId;
    }
}

