/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.xml.schema;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.template.SchemaResourceResolver;
import gov.va.med.cds.xml.schema.SchemaException;
import gov.va.med.cds.xml.schema.SchemaHelperInterface;
import gov.va.med.cds.xml.schema.SchemaValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaHelper
implements SchemaHelperInterface {
    private Log logger = LogFactory.getLog(SchemaHelper.class);
    private Map<String, List<String>> elementMap = null;
    private Schema compiledSchema = null;
    private String schemaName = null;
    private SchemaResourceResolver schemaResourceResolver = null;
    private ArrayList<XSDSchema> xsdSchemasList = null;

    public SchemaHelper(Blob aSchemaJar, String aSchemaName) throws SchemaException {
        this.schemaName = aSchemaName;
        if (null != aSchemaJar) {
            try {
                this.schemaResourceResolver = new SchemaResourceResolver(aSchemaJar);
                this.setupSymbolMap();
                this.createCompiledSchema();
            }
            catch (Exception e) {
                throw new SchemaException(ErrorCodeEnum.UNABLE_TO_LOAD_SCHEMAS_INTO_RESOURCE, this.schemaName, e.getMessage());
            }
        } else {
            throw new SchemaException(ErrorCodeEnum.MISSING_SCHEMA_JAR, this.schemaName);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded compiledSchema " + this.schemaName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSymbolMap() throws Exception {
        Map<String, InputSource> schemaInputSourceMap = null;
        try {
            this.elementMap = new HashMap<String, List<String>>();
            schemaInputSourceMap = this.schemaResourceResolver.getSchemaMap();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            String activeSchemaName = null;
            XSDResourceImpl xsdResource = null;
            URI uri = null;
            InputSource inputSourceSchema = null;
            XSDSchema xsdSchema = null;
            this.xsdSchemasList = new ArrayList();
            for (Map.Entry<String, InputSource> entry : schemaInputSourceMap.entrySet()) {
                inputSourceSchema = entry.getValue();
                activeSchemaName = entry.getKey();
                uri = URI.createURI((String)activeSchemaName);
                xsdResource = new XSDResourceImpl();
                xsdResource.setURI(uri);
                xsdResource.load(inputSourceSchema, options);
                xsdSchema = xsdResource.getSchema();
                this.xsdSchemasList.add(xsdSchema);
                this.mapTemplateSchema(xsdSchema);
            }
        }
        finally {
            this.releaseSchemaInputSources(schemaInputSourceMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSchemaInputSources(Map<String, InputSource> aSchemaInputSourceMap) {
        InputSource inputSourceSchema = null;
        InputStream inputStream = null;
        Reader reader = null;
        for (Map.Entry<String, InputSource> entry : aSchemaInputSourceMap.entrySet()) {
            inputSourceSchema = entry.getValue();
            if (null == inputSourceSchema) continue;
            inputStream = inputSourceSchema.getByteStream();
            reader = inputSourceSchema.getCharacterStream();
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Problem closing inputStream");
                    }
                }
                finally {
                    inputStream = null;
                }
            }
            if (null == reader) continue;
            try {
                reader.close();
            }
            catch (IOException ioe) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)"Problem closing reader");
            }
            finally {
                reader = null;
            }
        }
    }

    private void createCompiledSchema() throws Exception {
        String language = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory factory = SchemaFactory.newInstance(language);
        LocalErrorHandler localErrorHandler = new LocalErrorHandler();
        factory.setErrorHandler(localErrorHandler);
        factory.setResourceResolver(this.schemaResourceResolver);
        this.compiledSchema = factory.newSchema(this.schemaResourceResolver.getSchemaSource());
        if (localErrorHandler.parseException != null) {
            throw localErrorHandler.parseException;
        }
    }

    @Override
    public Map<String, List<String>> getSymbolMap() {
        return this.elementMap;
    }

    @Override
    public Validator getValidator() {
        Validator validator = this.compiledSchema.newValidator();
        return validator;
    }

    @Override
    public ArrayList<XSDSchema> getXsdSchemasList() {
        return this.xsdSchemasList;
    }

    private void mapTemplateSchema(XSDSchema aSchema) {
        EList types = aSchema.getTypeDefinitions();
        for (Object type : types) {
            XSDTypeDefinition typedef = (XSDTypeDefinition)type;
            if (!(typedef instanceof XSDComplexTypeDefinition)) continue;
            String classKey = typedef.getTargetNamespace() + "." + typedef.getName();
            ArrayList memberList = new ArrayList();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("adding " + classKey.toUpperCase() + " to the symbol map."));
            }
            this.elementMap.put(classKey.toUpperCase(), memberList);
            XSDComplexTypeDefinition cType = (XSDComplexTypeDefinition)typedef;
            XSDTypeDefinition baseTypeObj = cType.getBaseType();
            if (!cType.getDerivationMethod().getName().equals("restriction")) {
                this.processParent(baseTypeObj, memberList);
            }
            this.listAttributes(cType, memberList);
            this.listContents(cType, memberList);
        }
        EList groups = aSchema.getModelGroupDefinitions();
        for (Object group : groups) {
            XSDModelGroupDefinition groupdef = (XSDModelGroupDefinition)group;
            String classKey = groupdef.getTargetNamespace() + "." + groupdef.getName();
            ArrayList memberList = new ArrayList();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("adding " + classKey.toUpperCase() + " to the symbol map."));
            }
            this.elementMap.put(classKey.toUpperCase(), memberList);
            XSDModelGroup modelGroup = groupdef.getModelGroup();
            this.listModelGroup(modelGroup, memberList);
        }
    }

    private void listContents(XSDComplexTypeDefinition aXSDComplexTypeDefinition, List aMemberList) {
        XSDParticle content;
        XSDParticleContent modContent;
        XSDComplexTypeContent contentObj = aXSDComplexTypeDefinition.getContent();
        if (contentObj != null && contentObj instanceof XSDParticle && (modContent = (content = (XSDParticle)contentObj).getContent()) instanceof XSDModelGroup) {
            this.listModelGroup(modContent, aMemberList);
        }
    }

    private void listModelGroup(Object aModelGroupObject, List aMemberList) {
        XSDModelGroup modelContent = (XSDModelGroup)aModelGroupObject;
        EList modelContents = modelContent.getParticles();
        for (Object partObj : modelContents) {
            if (!(partObj instanceof XSDParticle)) continue;
            XSDParticle particle = (XSDParticle)partObj;
            XSDParticleContent decObj = particle.getContent();
            if (decObj instanceof XSDElementDeclaration) {
                String elementType;
                String declarationTypeTargetNamespace;
                String declarationTypeName;
                XSDElementDeclaration declaration = (XSDElementDeclaration)decObj;
                String declarationName = declaration.getName();
                if ((declarationName = StringUtils.remove((String)declarationName, (String)"_")) != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("adding " + declarationName + " to the symbol set."));
                    }
                    declarationTypeName = declaration.getType().getName();
                    declarationTypeTargetNamespace = declaration.getType().getTargetNamespace();
                    String string = elementType = declarationTypeName == null ? "" : declarationTypeName.toUpperCase();
                    if (declarationTypeName != null && declarationTypeTargetNamespace != null && !declarationTypeTargetNamespace.toUpperCase().contains("W3.ORG")) {
                        elementType = declarationTypeTargetNamespace.toUpperCase() + "." + elementType;
                    }
                    aMemberList.add(aMemberList.size(), declarationName + "/" + elementType);
                    continue;
                }
                declarationName = declaration.getResolvedElementDeclaration().getName();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("adding resolved name " + declarationName + " to the symbol set."));
                }
                declarationTypeName = declaration.getResolvedElementDeclaration().getType().getName();
                declarationTypeTargetNamespace = declaration.getResolvedElementDeclaration().getType().getTargetNamespace();
                String string = elementType = declarationTypeName == null ? "" : declarationTypeName.toUpperCase();
                if (declarationTypeName != null && declarationTypeTargetNamespace != null && !declarationTypeTargetNamespace.toUpperCase().contains("W3.ORG")) {
                    elementType = declarationTypeTargetNamespace.toUpperCase() + "." + elementType;
                }
                aMemberList.add(aMemberList.size(), declarationName + "/" + elementType);
                continue;
            }
            if (decObj instanceof XSDModelGroup) {
                this.listModelGroup(decObj, aMemberList);
                continue;
            }
            if (!(decObj instanceof XSDModelGroupDefinition)) continue;
            this.listModelGroupDefinition(decObj, aMemberList);
        }
    }

    private void listModelGroupDefinition(Object aXSDModelGroupDefinition, List aMemberList) {
        XSDModelGroupDefinition modelGroupDefinition = (XSDModelGroupDefinition)aXSDModelGroupDefinition;
        XSDModelGroupDefinition realGroupDefinition = modelGroupDefinition.getResolvedModelGroupDefinition();
        aMemberList.add(realGroupDefinition.getName().toUpperCase());
    }

    private void listAttributes(XSDComplexTypeDefinition aXSDComplexTypeDefinition, List aMemberList) {
        String attributeName = null;
        EList attributes = aXSDComplexTypeDefinition.getAttributeUses();
        for (Object attrib : attributes) {
            XSDAttributeUse attribute = (XSDAttributeUse)attrib;
            attributeName = attribute.getAttributeDeclaration().getName().toUpperCase();
            attributeName = StringUtils.remove((String)attributeName, (String)"_");
            aMemberList.add(attributeName);
        }
    }

    private void processParent(Object aBaseTypeObject, List aMemberList) {
        if (aBaseTypeObject == null || !(aBaseTypeObject instanceof XSDComplexTypeDefinition)) {
            return;
        }
        XSDComplexTypeDefinition type = (XSDComplexTypeDefinition)aBaseTypeObject;
        if ("anyType".equals(type.getName())) {
            return;
        }
        this.listAttributes(type, aMemberList);
        this.listContents(type, aMemberList);
        XSDTypeDefinition parent = type.getBaseType();
        this.processParent(parent, aMemberList);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Schema: " + this.schemaName + "\n");
        if (this.elementMap != null) {
            ArrayList<String> sortedKeys = new ArrayList<String>(this.elementMap.keySet());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                ArrayList sortedAttributes = new ArrayList(this.elementMap.get(key));
                Collections.sort(sortedAttributes);
                buffer.append("  " + key + ": ");
                boolean first = true;
                for (String attribute : sortedAttributes) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(", ");
                    }
                    buffer.append(" " + attribute);
                }
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    private class LocalErrorHandler
    extends DefaultHandler
    implements ErrorHandler {
        public SchemaValidationException parseException = null;

        private LocalErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.parseException = new SchemaValidationException(ErrorCodeEnum.ERROR_VALIDATIING_XML_AGAINST_COMPILED_SCHEMA, e, e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.parseException = new SchemaValidationException(ErrorCodeEnum.FATAL_ERROR_VALIDATIING_XML_AGAINST_COMPILED_SCHEMA, e, e.getMessage());
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (SchemaHelper.this.logger.isWarnEnabled()) {
                SchemaHelper.this.logger.warn((Object)"A problem occurred when validating an xml instance against a compiledSchema", (Throwable)e);
            }
        }
    }
}

