/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.work;

import commonj.work.Work;
import commonj.work.WorkException;
import gov.va.med.cds.work.DefaultWorkItem;
import gov.va.med.cds.work.WorkQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Worker {
    private final transient WorkQueue workQueue;
    private final transient ExecutorService threadPool = Executors.newCachedThreadPool();
    private volatile boolean isRunning = true;

    public Worker(WorkQueue queue) {
        this.workQueue = queue;
    }

    public void start() throws WorkException {
        do {
            DefaultWorkItem workItem;
            if ((workItem = this.workQueue.getWork()) == null) {
                this.isRunning = false;
                return;
            }
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Work work = workItem.getResult();
                        workItem.setStatus(3);
                        work.run();
                        workItem.setStatus(4);
                    }
                    catch (Throwable e) {
                        workItem.setStatus(2);
                    }
                }
            });
        } while (this.isRunning);
    }
}

