/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.work;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import gov.va.med.cds.transaction.WorkManagerInterface;
import gov.va.med.cds.work.DefaultWorkItem;
import gov.va.med.cds.work.WorkQueue;
import gov.va.med.cds.work.Worker;
import java.util.ArrayList;
import java.util.List;

public class MultiThreadedWorkManager
implements WorkManagerInterface {
    private final WorkQueue workQueue;
    private Worker worker;

    public MultiThreadedWorkManager(WorkQueue queue) {
        this.workQueue = queue;
    }

    @Override
    public WorkItem schedule(Work work) throws WorkException {
        DefaultWorkItem workItem = new DefaultWorkItem(work);
        this.workQueue.addWork(workItem);
        return workItem;
    }

    @Override
    public boolean waitForAll(List<? extends WorkItem> workItems) throws WorkException {
        return this.waitForAll(workItems, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForAll(List<? extends WorkItem> workItems, long timeout) throws WorkException {
        boolean timedIn = false;
        this.startWorker();
        long start = System.currentTimeMillis();
        ArrayList<WorkItem> completedWorkItems = new ArrayList<WorkItem>();
        do {
            completedWorkItems.clear();
            MultiThreadedWorkManager multiThreadedWorkManager = this;
            synchronized (multiThreadedWorkManager) {
                for (WorkItem workItem : workItems) {
                    if (workItem.getStatus() != 4 && workItem.getStatus() != 2) continue;
                    completedWorkItems.add(workItem);
                }
            }
            if (completedWorkItems.size() != workItems.size()) continue;
            return true;
        } while (timedIn = System.currentTimeMillis() - start < timeout);
        return timedIn;
    }

    private void startWorker() throws WorkException {
        this.worker = new Worker(this.workQueue);
        this.worker.start();
    }
}

