/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.dom4j.CDATA;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class QueryCacheValue {
    private long lastUpdateTime;
    private List<Object> cachedValue;

    public QueryCacheValue(List<Object> results) {
        if (results == null) {
            throw new IllegalArgumentException("The constructor argument results cannot be null");
        }
        this.cachedValue = (List)this.copy(results);
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public List<Object> getCachedValue() {
        return (List)this.copy(this.cachedValue);
    }

    public boolean exceedsMaxAge(long maxAgeInSeconds) {
        if (maxAgeInSeconds <= 0L) {
            return false;
        }
        long maxAgeTime = maxAgeInSeconds * 1000L;
        long currentTime = System.currentTimeMillis();
        return currentTime - maxAgeTime > this.lastUpdateTime;
    }

    public String toString() {
        return this.toElement().asXML();
    }

    public Element toElement() {
        DocumentFactory df = new DocumentFactory();
        Element e = df.createElement(this.getClass().getSimpleName());
        Date dt = new Date();
        dt.setTime(this.lastUpdateTime);
        e.add(df.createAttribute(e, "lastUpdateTime", dt.toString()));
        Element contents = df.createElement("cachedValue");
        for (Object item : this.getCachedValue()) {
            if (item instanceof Element) {
                contents.add((Element)item);
                continue;
            }
            CDATA cdata = df.createCDATA(item.toString());
            contents.add(cdata);
        }
        e.add(contents);
        return e;
    }

    protected Object cloneList(List<Object> list) {
        ArrayList<Object> clonedList = new ArrayList<Object>(list.size());
        for (Object item : list) {
            if (item instanceof Element) {
                clonedList.add(((Element)item).clone());
                continue;
            }
            clonedList.add(this.copy(item));
        }
        return clonedList;
    }

    public Object copy(Object original) {
        if (original instanceof List) {
            return this.cloneList((List)original);
        }
        if (original instanceof Element) {
            return ((Element)original).clone();
        }
        if (original instanceof Serializable) {
            return this.copyViaSerialization((Serializable)original);
        }
        throw new RuntimeException("object to copy [" + original + "] could not be copied via cloning nor by Serialization");
    }

    protected Object copyViaSerialization(Serializable original) {
        if (original == null) {
            throw new NullPointerException("Serializable argument cannot be null");
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(original);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            return in.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object other) {
        try {
            return this.cachedValue.equals(((QueryCacheValue)other).cachedValue);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.cachedValue});
    }
}

