/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import gov.va.med.cds.util.QueryCacheManager;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class QueryCacheUtil {
    public List<Object> getNamedQueryList(Session session, String queryName, String paramName, Object paramValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (paramName != null && !paramName.trim().equals("") && paramValue != null) {
            params.put(paramName, paramValue);
        }
        return this.getNamedQueryList(session, queryName, params);
    }

    public List<Object> getNamedQueryList(Session session, String queryName, String paramName1, Object paramValue1, String paramName2, Object paramValue2) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (paramName1 != null && !paramName1.trim().equals("") && paramValue1 != null) {
            params.put(paramName1, paramValue1);
        }
        if (paramName2 != null && !paramName2.trim().equals("") && paramValue2 != null) {
            params.put(paramName2, paramValue2);
        }
        return this.getNamedQueryList(session, queryName, params);
    }

    public List<Object> getNamedQueryList(Session session, String queryName, HashMap<String, Object> params) {
        if (session == null) {
            throw new IllegalArgumentException("session argument cannot be null");
        }
        if (queryName == null) {
            throw new IllegalArgumentException("queryName argument cannot be null");
        }
        if (queryName.trim().equals("")) {
            throw new IllegalArgumentException("queryName argument cannot be an empty string");
        }
        List elements = QueryCacheManager.getInstance().get(session, queryName, params);
        if (elements != null) {
            return elements;
        }
        Query query = session.getNamedQuery(queryName);
        for (String paramName : params.keySet()) {
            query.setParameter(paramName, params.get(paramName));
        }
        elements = query.list();
        QueryCacheManager.getInstance().put(session, queryName, params, elements);
        return elements;
    }

    public List<Object> getQueryList(Session session, String hql, String paramName, Object paramValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (paramName != null && paramName.trim().equals("") && paramValue != null) {
            params.put(paramName, paramValue);
        }
        return this.getQueryList(session, hql, params);
    }

    public List<Object> getQueryList(Session session, String hql, String paramName1, Object paramValue1, String paramName2, Object paramValue2) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (paramName1 != null && paramName1.trim().equals("") && paramValue1 != null) {
            params.put(paramName1, paramValue1);
        }
        if (paramName2 != null && paramName2.trim().equals("") && paramValue2 != null) {
            params.put(paramName2, paramValue2);
        }
        return this.getQueryList(session, hql, params);
    }

    public List<Object> getQueryList(Session session, String hql, HashMap<String, Object> params) {
        if (hql == null) {
            throw new IllegalArgumentException("queryName argument cannot be null");
        }
        if (hql.trim().equals("")) {
            throw new IllegalArgumentException("queryName argument cannot be an empty string");
        }
        if (session == null) {
            throw new IllegalArgumentException("session argument cannot be null");
        }
        List elements = QueryCacheManager.getInstance().get(session, hql, params);
        if (elements == null) {
            Query query = session.createQuery(hql);
            for (String paramName : params.keySet()) {
                query.setParameter(paramName, params.get(paramName));
            }
            elements = query.list();
            QueryCacheManager.getInstance().put(session, hql, params, elements);
        }
        return elements;
    }
}

