/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import gov.va.med.cds.util.QueryCache;
import gov.va.med.cds.util.QueryCacheManagerMBeanInterface;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate4.SessionFactoryUtils;

public class QueryCacheManager
implements QueryCacheManagerMBeanInterface,
ApplicationContextAware {
    public static final int ONE_DAY_IN_SECONDS = 86400;
    public static final int TWELVE_HOURS_IN_SECONDS = 43200;
    public static final int ONE_HOUR_IN_SECONDS = 3600;
    public static final int TWO_HOURS_IN_SECONDS = 7200;
    public static final int FOUR_HOURS_IN_SECONDS = 14400;
    public static final int DEFAULT_MAX_ENTRIES_PER_DATASOURCE = 2000;
    public static final long DEFAULT_MAX_ENTRY_AGE_IN_SECONDS = 3600L;
    private static QueryCacheManager instance;
    private HashMap<DataSource, QueryCache> dataSourceQueryCacheMap = new HashMap();
    private boolean enabled = true;
    private long maxEntriesPerDataSource = 2000L;
    private long maxDataAgeSeconds = 3600L;
    private static ApplicationContext applicationContext;
    private long lastOptimizationTime = System.currentTimeMillis();

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        applicationContext = appContext;
        instance = null;
    }

    public static QueryCacheManager getInstance() {
        if (instance != null) {
            return instance;
        }
        if (applicationContext == null) {
            instance = new QueryCacheManager();
            return instance;
        }
        instance = (QueryCacheManager)applicationContext.getBean("queryCacheManager");
        return instance;
    }

    public void put(Session session, String queryName, String paramName, Object paramValue, List<Object> results) {
        if (!this.enabled) {
            return;
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(paramName, paramValue);
        this.put(session, queryName, queryParams, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Session session, String queryName, HashMap<String, Object> queryParams, List<Object> results) {
        if (!this.enabled || results == null || results.isEmpty() || session == null) {
            return;
        }
        DataSource sessionDataSource = SessionFactoryUtils.getDataSource((SessionFactory)session.getSessionFactory());
        if (this.dataSourceQueryCacheMap.containsKey(sessionDataSource)) {
            QueryCache existingCache;
            QueryCache queryCache = existingCache = this.dataSourceQueryCacheMap.get(sessionDataSource);
            synchronized (queryCache) {
                existingCache.put(queryName, queryParams, results);
            }
        }
        QueryCache newCacheForDatasource = new QueryCache();
        newCacheForDatasource.setMaxEntries(this.maxEntriesPerDataSource);
        newCacheForDatasource.setMaxEntryAgeInSeconds(this.maxDataAgeSeconds);
        QueryCache queryCache = newCacheForDatasource;
        synchronized (queryCache) {
            newCacheForDatasource.put(queryName, queryParams, results);
        }
        this.dataSourceQueryCacheMap.put(sessionDataSource, newCacheForDatasource);
    }

    private void optimize() {
        if (Math.random() > 0.05) {
            return;
        }
        long maxDataAgeTime = this.maxDataAgeSeconds * 1000L;
        long timeSinceLastOptimization = System.currentTimeMillis() - this.lastOptimizationTime;
        if (maxDataAgeTime > timeSinceLastOptimization) {
            return;
        }
        this.removeEntriesExceedingMaxEntryAge();
        this.setLastOptimizationTime(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> get(Session session, String queryName, String paramName, Object paramValue) {
        if (!this.enabled) {
            return null;
        }
        DataSource sessionDataSource = SessionFactoryUtils.getDataSource((SessionFactory)session.getSessionFactory());
        QueryCache cache = this.dataSourceQueryCacheMap.get(sessionDataSource);
        if (cache == null) {
            return null;
        }
        this.optimize();
        QueryCache queryCache = cache;
        synchronized (queryCache) {
            return cache.get(queryName, paramName, paramValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> get(Session session, String queryName, HashMap<String, Object> params) {
        if (!this.enabled) {
            return null;
        }
        DataSource sessionDataSource = SessionFactoryUtils.getDataSource((SessionFactory)session.getSessionFactory());
        QueryCache cache = this.dataSourceQueryCacheMap.get(sessionDataSource);
        if (cache == null) {
            return null;
        }
        this.optimize();
        QueryCache queryCache = cache;
        synchronized (queryCache) {
            return cache.get(queryName, params);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            if (this.dataSourceQueryCacheMap == null) {
                this.dataSourceQueryCacheMap = new HashMap();
            }
        } else {
            for (QueryCache cache : this.dataSourceQueryCacheMap.values()) {
                cache.clear();
                Object var3_3 = null;
            }
            this.dataSourceQueryCacheMap.clear();
            this.dataSourceQueryCacheMap = null;
        }
    }

    @Override
    public long getMaxEntriesPerDataSource() {
        return this.maxEntriesPerDataSource;
    }

    @Override
    public void setMaxEntriesPerDataSource(long maxEntriesPerDataSource) {
        if (maxEntriesPerDataSource < 1L) {
            throw new IllegalArgumentException("maxEntriesPerDataSource cannot be less than 1. To disable the cacheing mechanism, call setEnabled() with a value of 'false'");
        }
        this.maxEntriesPerDataSource = maxEntriesPerDataSource;
        if (!this.enabled) {
            return;
        }
        for (QueryCache cache : this.dataSourceQueryCacheMap.values()) {
            cache.setMaxEntries(maxEntriesPerDataSource);
        }
    }

    @Override
    public long getMaxEntryAgeSeconds() {
        return this.maxDataAgeSeconds;
    }

    @Override
    public void setMaxEntryAgeSeconds(long maxDataAgeSeconds) {
        if (maxDataAgeSeconds < 1L) {
            throw new IllegalArgumentException("The MaxDataAgeSeconds cannot be set to a number less than 1. To disable the cacheing mechanism, call setEnabled() with a value of 'false'");
        }
        this.maxDataAgeSeconds = maxDataAgeSeconds;
        if (!this.enabled) {
            return;
        }
        for (QueryCache cache : this.dataSourceQueryCacheMap.values()) {
            cache.setMaxEntryAgeInSeconds(maxDataAgeSeconds);
        }
    }

    @Override
    public long getCacheHitCount() {
        if (!this.enabled) {
            return -1L;
        }
        int count = 0;
        for (QueryCache cache : this.dataSourceQueryCacheMap.values()) {
            count = (int)((long)count + cache.getCacheHitCount());
        }
        return count;
    }

    @Override
    public long getCacheMissCount() {
        if (!this.enabled) {
            return -1L;
        }
        int count = 0;
        for (QueryCache cache : this.dataSourceQueryCacheMap.values()) {
            count = (int)((long)count + cache.getCacheMissCount());
        }
        return count;
    }

    @Override
    public long getCacheEntryCount() {
        if (!this.enabled) {
            return -1L;
        }
        int count = 0;
        for (QueryCache cache : this.dataSourceQueryCacheMap.values()) {
            count += cache.size();
        }
        return count;
    }

    @Override
    public long getDatasourceCacheCount() {
        if (!this.enabled) {
            return -1L;
        }
        return this.dataSourceQueryCacheMap.size();
    }

    @Override
    public String getQueryCacheManagerDump() {
        return this.toString();
    }

    @Override
    public String emptyCache() {
        if (!this.enabled) {
            return "Since caching is not enabled, the caches are already empty.";
        }
        long entryCount = this.getCacheEntryCount();
        long dataSourceCount = this.getDatasourceCacheCount();
        this.dataSourceQueryCacheMap.clear();
        this.dataSourceQueryCacheMap = null;
        this.dataSourceQueryCacheMap = new HashMap();
        return "The Query caches are now empty. " + entryCount + (entryCount == 1L ? " entry was " : " entries were ") + "removed from " + dataSourceCount + (dataSourceCount == 1L ? " DataSource Cache." : " DataSource Caches.");
    }

    @Override
    public String removeEntriesExceedingMaxEntryAge() {
        if (!this.enabled) {
            return "Since caching is not enabled, the caches are empty.";
        }
        int count = 0;
        for (QueryCache cache : this.dataSourceQueryCacheMap.values()) {
            count += cache.removeEntriesExceedingMaxEntryAge();
        }
        ArrayList<DataSource> keysToRemove = new ArrayList<DataSource>();
        for (DataSource ds : this.dataSourceQueryCacheMap.keySet()) {
            if (this.dataSourceQueryCacheMap.get(ds).size() != 0) continue;
            keysToRemove.add(ds);
        }
        for (DataSource ds : keysToRemove) {
            this.dataSourceQueryCacheMap.remove(ds);
        }
        return count == 1 ? "1 cached entry" : count + " cached entries" + " exceeding the max age" + (count == 1 ? " was" : " were") + " removed.";
    }

    public Element toElement() {
        DocumentFactory df = new DocumentFactory();
        Element e = df.createElement(this.getClass().getSimpleName());
        if (!this.enabled) {
            e.add(df.createComment("Query Caching is currently not enabled"));
            return e;
        }
        e.add(df.createAttribute(e, "numberOfCaches", "" + this.dataSourceQueryCacheMap.size()));
        long hitCount = this.getCacheHitCount();
        long missCount = this.getCacheMissCount();
        long hitPercentage = Math.round((double)hitCount * 100.0 / (double)(hitCount + missCount));
        e.add(df.createAttribute(e, "overallCachingHitCount", "" + hitCount));
        e.add(df.createAttribute(e, "overallCachingMissCount", "" + missCount));
        e.add(df.createAttribute(e, "overallCachingHitPercentage", "" + hitPercentage + "%"));
        Element entries = df.createElement("entries");
        e.add(entries);
        for (DataSource key : this.dataSourceQueryCacheMap.keySet()) {
            Element dsqc = df.createElement("dataSourceQueryCache");
            dsqc.add(df.createAttribute(dsqc, "dataSourceIdentifier", key.toString()));
            dsqc.add(this.dataSourceQueryCacheMap.get(key).toElement());
            entries.add(dsqc);
        }
        return e;
    }

    public String toString() {
        if (!this.enabled) {
            return "Query Caching is currently not enabled";
        }
        return this.toElement().asXML();
    }

    @Override
    public String getMemoryUseEstimate() {
        if (!this.enabled) {
            return "Query Caching is currently not enabled. Neglible use of memory.";
        }
        long byteEstimate = this.toString().getBytes().length;
        DecimalFormat decimalFormat = new DecimalFormat("###,###");
        String bytesString = decimalFormat.format(byteEstimate);
        return bytesString + " bytes.";
    }

    private synchronized void setLastOptimizationTime(long aLastOptimizationTime) {
        this.lastOptimizationTime = aLastOptimizationTime;
    }
}

