/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import java.util.Arrays;
import java.util.HashMap;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class QueryCacheKey {
    private String queryIdentifier;
    private HashMap<String, Object> paramsMap = new HashMap();

    public QueryCacheKey(String queryIdentifier) {
        this(queryIdentifier, null, null);
    }

    public QueryCacheKey(String queryIdentifier, String paramName, Object paramValue) {
        if (queryIdentifier == null) {
            throw new IllegalArgumentException("queryIdentifier cannot be null");
        }
        this.queryIdentifier = queryIdentifier;
        if (paramName != null && !paramName.trim().equals("")) {
            this.paramsMap.put(paramName, paramValue);
        }
    }

    public QueryCacheKey(String queryIdentifier, HashMap<String, Object> paramsMap) {
        if (queryIdentifier == null) {
            throw new IllegalArgumentException("queryIdentifier cannot be null");
        }
        this.queryIdentifier = queryIdentifier;
        if (paramsMap != null) {
            this.paramsMap = paramsMap;
        }
    }

    public String toString() {
        return this.toElement().asXML();
    }

    public Element toElement() {
        DocumentFactory df = new DocumentFactory();
        Element e = df.createElement(this.getClass().getSimpleName());
        e.add(df.createAttribute(e, "queryIdentifier", this.queryIdentifier));
        int index = 0;
        for (String key : this.paramsMap.keySet()) {
            e.add(df.createAttribute(e, "queryParameterName" + index, key));
            e.add(df.createAttribute(e, "queryParameterValue" + index, this.paramsMap.get(key).toString()));
            ++index;
        }
        return e;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        try {
            QueryCacheKey other = (QueryCacheKey)object;
            if (!this.queryIdentifier.equals(other.queryIdentifier)) {
                return false;
            }
            return this.paramsMap.equals(other.paramsMap);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.queryIdentifier, this.paramsMap});
    }
}

