/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import gov.va.med.cds.util.QueryCacheKey;
import gov.va.med.cds.util.QueryCacheValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class QueryCache
extends LinkedHashMap<QueryCacheKey, QueryCacheValue> {
    private long cacheHitCount = 0L;
    private long cacheMissCount = 0L;
    private long maxEntries = 2000L;
    private long maxEntryAgeInSeconds = 3600L;

    public synchronized void put(String queryIdentifier, String paramName, Object paramValue, List<Object> results) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(paramName, paramValue);
        this.put(queryIdentifier, queryParams, results);
    }

    public synchronized void put(String queryIdentifier, HashMap<String, Object> queryParams, List<Object> results) {
        if (results == null || results.isEmpty()) {
            return;
        }
        QueryCacheKey key = new QueryCacheKey(queryIdentifier, queryParams);
        this.put(key, new QueryCacheValue(results));
        if ((long)this.size() > this.maxEntries) {
            this.removeElementsExceedingMaxSize();
        }
    }

    public synchronized List<Object> get(String queryIdentifier, String paramName, Object paramValue) {
        QueryCacheKey key = new QueryCacheKey(queryIdentifier, paramName, paramValue);
        return this.getWithKey(key);
    }

    public synchronized List<Object> get(String queryIdentifier, HashMap<String, Object> queryParams) {
        QueryCacheKey key = new QueryCacheKey(queryIdentifier, queryParams);
        return this.getWithKey(key);
    }

    private synchronized List<Object> getWithKey(QueryCacheKey key) {
        QueryCacheValue cachedValue = (QueryCacheValue)super.get(key);
        if (cachedValue == null) {
            ++this.cacheMissCount;
            return null;
        }
        if (cachedValue.exceedsMaxAge(this.maxEntryAgeInSeconds)) {
            cachedValue = null;
            this.remove(key);
            ++this.cacheMissCount;
            return null;
        }
        ++this.cacheHitCount;
        this.remove(key);
        this.put(key, cachedValue);
        return cachedValue.getCachedValue();
    }

    public long getCacheHitCount() {
        return this.cacheHitCount;
    }

    public long getCacheMissCount() {
        return this.cacheMissCount;
    }

    @Override
    public String toString() {
        return this.toElement().asXML();
    }

    public Element toElement() {
        double hitPercentage = Math.round((double)this.cacheHitCount * 100.0 / (double)(this.cacheMissCount + this.cacheHitCount));
        DocumentFactory df = new DocumentFactory();
        Element e = df.createElement(this.getClass().getSimpleName());
        e.add(df.createAttribute(e, "cacheSize", "" + this.size()));
        e.add(df.createAttribute(e, "cacheHitCount", "" + this.cacheHitCount));
        e.add(df.createAttribute(e, "cacheMissCount", "" + this.cacheMissCount));
        e.add(df.createAttribute(e, "cacheHitPercentage", "" + hitPercentage));
        Element entries = df.createElement("entries");
        e.add(entries);
        for (QueryCacheKey key : this.keySet()) {
            entries.add(key.toElement());
            entries.add(((QueryCacheValue)this.get(key)).toElement());
        }
        return e;
    }

    @Override
    protected synchronized boolean removeEldestEntry(Map.Entry<QueryCacheKey, QueryCacheValue> eldest) {
        return (long)this.size() > this.maxEntries;
    }

    public synchronized long getMaxEntries() {
        return this.maxEntries;
    }

    public synchronized void setMaxEntries(long maxEntries) {
        this.maxEntries = maxEntries;
        if (maxEntries < (long)this.size()) {
            this.removeElementsExceedingMaxSize();
        }
    }

    public synchronized long getMaxEntryAgeInSeconds() {
        return this.maxEntryAgeInSeconds;
    }

    public synchronized void setMaxEntryAgeInSeconds(long maxEntryAgeInSeconds) {
        this.maxEntryAgeInSeconds = maxEntryAgeInSeconds;
        this.removeEntriesExceedingMaxEntryAge();
    }

    private synchronized void removeElementsExceedingMaxSize() {
        int currentSize = this.size();
        int reductionNeeded = currentSize - (int)this.maxEntries;
        if (reductionNeeded <= 0) {
            return;
        }
        ArrayList<QueryCacheKey> keysToRemove = new ArrayList<QueryCacheKey>();
        int counter = 0;
        for (QueryCacheKey key : this.keySet()) {
            if (counter >= reductionNeeded) break;
            keysToRemove.add(key);
            ++counter;
        }
        for (QueryCacheKey key : keysToRemove) {
            this.remove(key);
        }
    }

    public synchronized int removeEntriesExceedingMaxEntryAge() {
        int count = 0;
        ArrayList<QueryCacheKey> keysToRemove = new ArrayList<QueryCacheKey>();
        for (QueryCacheKey key : this.keySet()) {
            if (key == null) continue;
            QueryCacheValue value = (QueryCacheValue)this.get(key);
            if (value == null) {
                keysToRemove.add(key);
                continue;
            }
            if (!value.exceedsMaxAge(this.maxEntryAgeInSeconds)) continue;
            keysToRemove.add(key);
        }
        for (QueryCacheKey key : keysToRemove) {
            this.remove(key);
            ++count;
        }
        return count;
    }
}

