/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import gov.va.med.cds.util.PerformanceLogMBeanInterface;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PerformanceLog
implements PerformanceLogMBeanInterface,
ApplicationContextAware {
    private Log performanceLogger = LogFactory.getLog(PerformanceLog.class);
    public static final String STATUS_SUCCESS = "succeeded";
    public static final String STATUS_FAIL = "failed";
    private boolean enabled = false;
    private static PerformanceLog instance;
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        applicationContext = appContext;
        instance = null;
    }

    public static PerformanceLog getInstance() {
        if (instance != null) {
            return instance;
        }
        if (applicationContext == null) {
            instance = new PerformanceLog();
            return instance;
        }
        instance = (PerformanceLog)applicationContext.getBean("performanceLog");
        return instance;
    }

    public String logFinishTime(long startTime, long finishTime, String keywords, String domainEntryPoint, String templateId, String requestId, String siteId, boolean succeeded, String tier) {
        if (!this.enabled) {
            return null;
        }
        if (this.performanceLogger.isInfoEnabled()) {
            if (finishTime < startTime) {
                throw new IllegalArgumentException("finishTime argument cannot be less than startTime argument");
            }
            if (finishTime < 0L) {
                throw new IllegalArgumentException("finishTime argument cannot be negative");
            }
            if (startTime < 0L) {
                throw new IllegalArgumentException("startTime argument cannot be negative");
            }
            String status = succeeded ? STATUS_SUCCESS : STATUS_FAIL;
            String message = this.buildCsvMessage(startTime, finishTime, keywords, domainEntryPoint, templateId, requestId, siteId, status, tier);
            this.performanceLogger.info((Object)message);
            return message;
        }
        return null;
    }

    private String buildCsvMessage(long startTime, long finishTime, String keywords, String domainEntryPoint, String templateId, String requestId, String siteId, String status, String tier) {
        double durationInSeconds = (double)(finishTime - startTime) / 1000.0;
        if (keywords.indexOf(",") != -1) {
            keywords = "\"" + keywords + "\"";
        }
        String message = keywords + "," + domainEntryPoint + "," + templateId + "," + requestId + "," + siteId + "," + startTime + "," + finishTime + "," + durationInSeconds + "," + status + "," + tier;
        return message;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isInfoEnabled() {
        if (!this.enabled) {
            return false;
        }
        return this.performanceLogger.isInfoEnabled();
    }
}

