/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private static final float HASH_TABLE_LOAD_FACTOR = 0.75f;
    private static final Log LOGGER = LogFactory.getLog(LRUHashMap.class);
    private int mapThreshold;

    public LRUHashMap(int aMapSize) {
        super((int)Math.ceil((float)aMapSize / 0.75f) + 1, 0.75f, true);
        this.mapThreshold = aMapSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldestEntry) {
        boolean removingEldest;
        boolean bl = removingEldest = this.size() > this.mapThreshold;
        if (removingEldest && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Removing entry: " + eldestEntry.getKey() + " from map"));
        }
        return removingEldest;
    }

    public void reSize(int newSize) {
        this.mapThreshold = newSize;
    }

    public int getMapThreshold() {
        return this.mapThreshold;
    }
}

