/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConcurrentLRUCache<K, V> {
    private static final float HASH_TABLE_LOAD_FACTOR = 0.75f;
    private LinkedHashMap<K, V> map;
    private int cacheSize;

    public ConcurrentLRUCache(int aCacheSize) {
        this.cacheSize = aCacheSize;
        int hashTableCapacity = (int)Math.ceil((float)aCacheSize / 0.75f) + 1;
        this.map = new LinkedHashMap<K, V>(hashTableCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldestEntry) {
                return this.size() > ConcurrentLRUCache.this.cacheSize;
            }
        };
    }

    public synchronized boolean containsKey(K aKey) {
        return this.map.containsKey(aKey);
    }

    public synchronized V get(K aKey) {
        return this.map.get(aKey);
    }

    public synchronized void put(K aKey, V aValue) {
        this.map.put(aKey, aValue);
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized int usedEntries() {
        return this.map.size();
    }

    public synchronized Collection<Map.Entry<K, V>> getAll() {
        return new ArrayList<Map.Entry<K, V>>(this.map.entrySet());
    }

    public synchronized int getCacheSize() {
        return this.cacheSize;
    }
}

