/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.transaction;

import commonj.work.Work;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.ReadPersistenceManagerInterface;
import java.util.List;
import org.dom4j.Document;

public class ReadWork
implements Work {
    private ReadPersistenceManagerInterface persistenceManager;
    private EntryFilterInterface entryFilter;
    private List<PersonIdentifierInterface> personIdentifiers;
    private boolean completeFailure = false;
    private Document result = null;
    private String cdsAppName;

    public ReadWork(ReadPersistenceManagerInterface persistenceManager, EntryFilterInterface entryFilter, List<PersonIdentifierInterface> personIdentifiers) {
        this.persistenceManager = persistenceManager;
        this.entryFilter = entryFilter;
        this.personIdentifiers = personIdentifiers;
    }

    public void release() {
    }

    public void run() {
        try {
            this.result = this.persistenceManager.performReadOnClinicalData(this.entryFilter, this.personIdentifiers, this.cdsAppName);
        }
        catch (PersistenceException e) {
            this.completeFailure = true;
            this.result = ExceptionHandler.handleException(this.result, (Exception)((Object)e), this.entryFilter.getTemplateId(), this.entryFilter.getRequestId(), this.cdsAppName);
        }
    }

    public boolean isCompleteFailure() {
        return this.completeFailure;
    }

    public Document getResult() {
        return this.result;
    }

    protected void setResult(Document result) {
        this.result = result;
    }

    public boolean isDaemon() {
        return false;
    }

    public void setCdsAppName(String cdsAppName) {
        this.cdsAppName = cdsAppName;
    }
}

