/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.transaction;

import commonj.work.WorkException;
import commonj.work.WorkItem;
import gov.va.med.cds.clinicaldata.DomainClinicalRecordElementHelperInterface;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.filter.CdsFilterInterface;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.PersistenceLocatorInterface;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.persistence.ReadPersistenceManagerInterface;
import gov.va.med.cds.persistence.WritePersistenceManagerInterface;
import gov.va.med.cds.request.vista.write.CdsWriteInterface;
import gov.va.med.cds.template.TemplateHelperInterface;
import gov.va.med.cds.transaction.ReadWork;
import gov.va.med.cds.transaction.TransactionManagerInterface;
import gov.va.med.cds.transaction.ValidNonVistaSitesMBeanInterface;
import gov.va.med.cds.transaction.WorkManagerInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class DefaultTransactionManager
implements TransactionManagerInterface,
ValidNonVistaSitesMBeanInterface {
    protected PersistenceLocatorInterface persistenceLocator = null;
    protected WorkManagerInterface workManager = null;
    private Map<String, Set<DomainEntryPoint>> templateIdToDomainEntryPointListMap = null;
    private List<String> validNonVistaSites;
    private List<String> vistaCreateTemplateDomainEntryPointsList;
    private CdsWriteInterface cdsVistaWrite;
    private int createdRecordLimitIndex = 20;
    private TemplateHelperInterface templateHelper;
    private Map<String, DomainClinicalRecordElementHelperInterface> domainClinicalRecordOwnerMap;
    private Map<String, String> templateTimeoutMap = null;
    private static final String CDS_XPATH_OF_WARNING_MSG = "//errorSection/warnings/warning/displayMessage";
    private static final String CDS_XPATH_OF_WARNING_MSG_SINGLE = "//errorSection/warnings/displayMessage";
    private static final String CDS_XPATH_OF_ERROR_MSG = "//errorSection/errors/error/displayMessage";

    public void setTemplateTimeoutMap(Map<String, String> templateTimeoutMap) {
        this.templateTimeoutMap = templateTimeoutMap;
    }

    @Override
    public List<Document> performReadOnClinicalData(CdsFilterInterface filter) throws PersistenceException {
        return this.performReadOnClinicalData(null, null, filter);
    }

    @Override
    public List<Document> performReadOnClinicalData(String templateId, String requestId, CdsFilterInterface filter) throws PersistenceException {
        ArrayList<Document> readResults = new ArrayList<Document>();
        ArrayList<WorkItem> workQueue = new ArrayList<WorkItem>();
        List<PersonIdentifierInterface> filterPersonIdentifiers = null;
        boolean isPatientCentricFilter = filter.isPatientCentricFilter();
        if (isPatientCentricFilter) {
            filterPersonIdentifiers = filter.getPersonIdentifiers();
        }
        List<Document> resolvedIdsErrors = null;
        for (EntryFilterInterface entryFilter : filter.getEntryPointFilters()) {
            List<ReadPersistenceManagerInterface> readablePersistenceManagers = this.persistenceLocator.getReadPersistenceManagers(entryFilter, filterPersonIdentifiers);
            if (isPatientCentricFilter && filter.getNationalId() == null) {
                resolvedIdsErrors = this.chkAssigningFacilities(readResults, filterPersonIdentifiers, entryFilter.getRequestId(), entryFilter.getTemplateId(), readablePersistenceManagers, this.templateHelper.getApplicationName(templateId));
            }
            for (ReadPersistenceManagerInterface readPersistenceManager : readablePersistenceManagers) {
                try {
                    workQueue.add(this.workManager.schedule(new ReadWork(readPersistenceManager, entryFilter, filterPersonIdentifiers)));
                }
                catch (WorkException we) {
                    ExceptionHandler.handleException((Exception)((Object)new ReadException(ErrorCodeEnum.READ_REQUEST_WORK_SCHEDULING_EXCEPTION, we)), entryFilter.getTemplateId(), entryFilter.getRequestId(), this.templateHelper.getApplicationName(templateId));
                }
            }
            try {
                this.workManager.waitForAll(workQueue);
            }
            catch (WorkException we) {
                ExceptionHandler.handleException((Exception)((Object)new ReadException(ErrorCodeEnum.READ_REQUEST_WORK_WAIT_INTERRUPTED_EXCEPTION, we)), entryFilter.getTemplateId(), entryFilter.getRequestId(), this.templateHelper.getApplicationName(templateId));
            }
            ReadWork doneWork = null;
            int failedCount = 0;
            for (WorkItem workItem : workQueue) {
                try {
                    doneWork = (ReadWork)workItem.getResult();
                    if (doneWork == null) continue;
                    failedCount = doneWork.isCompleteFailure() ? ++failedCount : failedCount;
                    readResults.add(this.processEntryTypeQueries(doneWork.getResult(), entryFilter.getXpathQuery()));
                }
                catch (WorkException e) {
                    ++failedCount;
                }
            }
            if (workQueue.size() == failedCount && (resolvedIdsErrors == null || resolvedIdsErrors.size() == 0)) {
                ArrayList<String> errMsgs = new ArrayList<String>();
                Element e = null;
                String msgContent = null;
                List content = null;
                String errorMsg = "No data found for the read request";
                for (Document readResult : readResults) {
                    content = readResult.selectNodes(CDS_XPATH_OF_WARNING_MSG);
                    if (content.size() == 0 && (content = readResult.selectNodes(CDS_XPATH_OF_WARNING_MSG_SINGLE)).size() == 0) {
                        content = readResult.selectNodes(CDS_XPATH_OF_ERROR_MSG);
                    }
                    e = (Element)content.get(0);
                    msgContent = e.getText();
                    errMsgs.add(msgContent);
                }
                if (errMsgs.size() > 0) {
                    errorMsg = ((Object)errMsgs).toString();
                }
                throw new PersistenceException(ErrorCodeEnum.READ_REQUEST_ALL_DATASOURCES_FAILED, errorMsg);
            }
            if (resolvedIdsErrors == null || resolvedIdsErrors.size() <= 0) continue;
            for (Document resolvedIdsError : resolvedIdsErrors) {
                readResults.add(resolvedIdsError);
            }
        }
        return readResults;
    }

    @Override
    public List<Element> performCUADOnClinicalData(Operation operation, Document clinicalData, String templateId, String requestId) throws PersistenceException {
        ArrayList<Element> recordIdentifiers = new ArrayList<Element>();
        Set<DomainEntryPoint> domainEntryPoints = this.templateIdToDomainEntryPointListMap.get(templateId);
        if (domainEntryPoints == null) {
            throw new PersistenceException(ErrorCodeEnum.WRITE_REQUEST_SIMPLE_INVALID_TEMPLATE_ID);
        }
        Element documentRoot = clinicalData.getRootElement();
        Element patientElement = documentRoot.element("patient");
        if (null == patientElement) {
            patientElement = documentRoot.element("patients");
            for (DomainEntryPoint domainEntryPoint : domainEntryPoints) {
                String aresultId = null;
                WritePersistenceManagerInterface writePersistenceManager = this.persistenceLocator.getWritePersistenceManager(domainEntryPoint);
                aresultId = writePersistenceManager.performCUADOnPatientsData(templateId, requestId, operation, patientElement, domainEntryPoint);
                recordIdentifiers.add(this.templateHelper.getWriteResponseGenerator(templateId).generateIdentifierElement(aresultId, patientElement));
            }
        } else {
            for (DomainEntryPoint domainEntryPoint : domainEntryPoints) {
                List clinicalRecords = domainEntryPoint.getClinicalRecords(patientElement);
                if (clinicalRecords == null || clinicalRecords.size() <= 0) continue;
                int i = 0;
                WritePersistenceManagerInterface writePersistenceManager = this.persistenceLocator.getWritePersistenceManager(domainEntryPoint);
                for (Element clinicalRecord : clinicalRecords) {
                    String resultId = null;
                    if (operation.equals((Object)Operation.Create) || operation.equals((Object)Operation.Update)) {
                        this.validateAssigningFacility(clinicalRecord, domainEntryPoint);
                    }
                    if (operation.equals((Object)Operation.Create)) {
                        this.addRequestIdToClinicalRecordElement(clinicalRecord, requestId);
                        resultId = writePersistenceManager.performCUADOnClinicalData(templateId, operation, clinicalRecord, domainEntryPoint);
                    }
                    if (operation.equals((Object)Operation.Update) || operation.equals((Object)Operation.Delete)) {
                        resultId = this.addIdtoClinicalElement(clinicalRecord, domainEntryPoint);
                        resultId = writePersistenceManager.performCUADOnClinicalData(templateId, operation, clinicalRecord, domainEntryPoint);
                    }
                    recordIdentifiers.add(this.templateHelper.getWriteResponseGenerator(templateId).generateIdentifierElement(resultId, clinicalRecord));
                    ++i;
                }
            }
        }
        return recordIdentifiers;
    }

    @Override
    public List<Document> performCUADVistAData(Operation operation, Document clinicalData, String templateId, String requestId) throws PersistenceException {
        List<Document> results = null;
        Set<DomainEntryPoint> domainEntryPoints = this.templateIdToDomainEntryPointListMap.get(templateId);
        if (domainEntryPoints == null) {
            throw new PersistenceException(ErrorCodeEnum.WRITE_REQUEST_SIMPLE_INVALID_TEMPLATE_ID);
        }
        Element documentRoot = clinicalData.getRootElement();
        Element patientElement = documentRoot.element("patient");
        if (null != patientElement) {
            for (DomainEntryPoint domainEntryPoint : domainEntryPoints) {
                List recordsParent = domainEntryPoint.getClinicalRecords(patientElement);
                this.cdsVistaWrite.setDataElement((Element)recordsParent.get(0));
                this.cdsVistaWrite.setTemplateId(templateId);
                this.cdsVistaWrite.setRequestId(requestId);
                this.cdsVistaWrite.setDomainEntryPoint(domainEntryPoint);
                this.cdsVistaWrite.extractData();
                results = this.performWriteOnPatientData(templateId, requestId, this.cdsVistaWrite);
            }
        }
        return results;
    }

    private List<Document> performWriteOnPatientData(String templateId, String requestId, CdsWriteInterface cdsWrite) throws PersistenceException {
        ArrayList<Document> writeResults = new ArrayList<Document>();
        ArrayList<WorkItem> workQueue = new ArrayList<WorkItem>();
        Object personIds = null;
        List<Document> resolvedIdsErrors = null;
        ArrayList personIdentifiers = new ArrayList();
        List<EntryFilterInterface> recordsList = cdsWrite.getCreateData();
        for (EntryFilterInterface record : recordsList) {
            List<ReadPersistenceManagerInterface> readablePersistenceManagers = this.persistenceLocator.getReadPersistenceManagers(record, record.getPersonIdentifiers());
            resolvedIdsErrors = this.chkAssigningFacilities(writeResults, record.getPersonIdentifiers(), record.getRequestId(), record.getTemplateId(), readablePersistenceManagers, this.templateHelper.getApplicationName(templateId));
            for (ReadPersistenceManagerInterface readPersistenceManager : readablePersistenceManagers) {
                try {
                    workQueue.add(this.workManager.schedule(new ReadWork(readPersistenceManager, record, record.getPersonIdentifiers())));
                }
                catch (WorkException we) {
                    ExceptionHandler.handleException((Exception)((Object)new ReadException(ErrorCodeEnum.READ_REQUEST_WORK_SCHEDULING_EXCEPTION, we)), record.getTemplateId(), record.getRequestId(), this.templateHelper.getApplicationName(templateId));
                }
            }
            try {
                this.workManager.waitForAll(workQueue);
            }
            catch (WorkException we) {
                ExceptionHandler.handleException((Exception)((Object)new ReadException(ErrorCodeEnum.READ_REQUEST_WORK_WAIT_INTERRUPTED_EXCEPTION, we)), record.getTemplateId(), record.getRequestId(), this.templateHelper.getApplicationName(templateId));
            }
            ReadWork doneWork = null;
            int failedCount = 0;
            for (WorkItem workItem : workQueue) {
                try {
                    doneWork = (ReadWork)workItem.getResult();
                    if (doneWork == null) continue;
                    failedCount = doneWork.isCompleteFailure() ? ++failedCount : failedCount;
                    writeResults.add(this.processEntryTypeQueries(doneWork.getResult(), record.getXpathQuery()));
                }
                catch (WorkException e) {
                    ++failedCount;
                }
            }
            if (workQueue.size() == failedCount && (resolvedIdsErrors == null || resolvedIdsErrors.size() == 0)) {
                ArrayList<String> errMsgs = new ArrayList<String>();
                Element e = null;
                String msgContent = null;
                List content = null;
                String errorMsg = "Write request failure - No data response for the Write request";
                for (Document writeResult : writeResults) {
                    content = writeResult.selectNodes(CDS_XPATH_OF_WARNING_MSG);
                    if (content.size() == 0 && (content = writeResult.selectNodes(CDS_XPATH_OF_WARNING_MSG_SINGLE)).size() == 0) {
                        content = writeResult.selectNodes(CDS_XPATH_OF_ERROR_MSG);
                    }
                    e = (Element)content.get(0);
                    msgContent = e.getText();
                    errMsgs.add(msgContent);
                }
                if (errMsgs.size() > 0) {
                    errorMsg = ((Object)errMsgs).toString();
                }
                throw new PersistenceException(ErrorCodeEnum.READ_REQUEST_ALL_DATASOURCES_FAILED, errorMsg);
            }
            if (resolvedIdsErrors == null || resolvedIdsErrors.size() <= 0) continue;
            for (Document resolvedIdsError : resolvedIdsErrors) {
                writeResults.add(resolvedIdsError);
            }
        }
        return writeResults;
    }

    protected void addRequestIdToClinicalRecordElement(Element clinicalRecord, String requestId) {
        clinicalRecord.addElement("requestId").addText(requestId);
    }

    private String addIdtoClinicalElement(Element clinicalRecord, DomainEntryPoint domainEntryPoint) {
        DomainClinicalRecordElementHelperInterface domainClinicalRecordHelper = this.getDomainClinicalRecordElementHelper(domainEntryPoint);
        return domainClinicalRecordHelper.addIdToClinicalRecordElement(clinicalRecord);
    }

    private DomainClinicalRecordElementHelperInterface getDomainClinicalRecordElementHelper(DomainEntryPoint domainEntryPoint) {
        DomainClinicalRecordElementHelperInterface domainClinicalRecordHelper = this.domainClinicalRecordOwnerMap.get(domainEntryPoint.getName());
        if (domainClinicalRecordHelper == null) {
            domainClinicalRecordHelper = this.domainClinicalRecordOwnerMap.get("defaultDomainOwner");
        }
        return domainClinicalRecordHelper;
    }

    private void validateAssigningFacility(Element clinicalRecord, DomainEntryPoint domainEntryPoint) throws PersistenceException {
        DomainClinicalRecordElementHelperInterface domainClinicalRecordHelper = this.getDomainClinicalRecordElementHelper(domainEntryPoint);
        String assigningFacilityValue = domainClinicalRecordHelper.getAssigningFacilityValue(clinicalRecord);
        if (assigningFacilityValue != null && !this.validNonVistaSites.contains(assigningFacilityValue)) {
            throw new PersistenceException(ErrorCodeEnum.INVALID_ASSIGNING_FACILITY, assigningFacilityValue);
        }
    }

    public void setPersistenceLocator(PersistenceLocatorInterface persistenceLocator) {
        this.persistenceLocator = persistenceLocator;
    }

    public void setWorkManager(WorkManagerInterface workManager) {
        this.workManager = workManager;
    }

    public void setTemplateIdToDomainEntryPointListMap(Map<String, Set<DomainEntryPoint>> templateIdToDomainEntryPointListMap) {
        this.templateIdToDomainEntryPointListMap = templateIdToDomainEntryPointListMap;
    }

    public void setValidNonVistaSites(List<String> validNonVistaSites) {
        this.validNonVistaSites = validNonVistaSites;
    }

    public void setTemplateHelper(TemplateHelperInterface templateHelper) {
        this.templateHelper = templateHelper;
    }

    private Document processEntryTypeQueries(Document document, String xpath) {
        if (!StringUtils.isEmpty((CharSequence)xpath)) {
            List allNodes = document.selectNodes(String.format("//%s", xpath.substring(0, xpath.indexOf(91))));
            allNodes.removeAll(document.selectNodes("//" + xpath));
            for (Node node : allNodes) {
                node.detach();
            }
        }
        return document;
    }

    private List<Document> chkAssigningFacilities(List<Document> readResults, List<PersonIdentifierInterface> filterPersonIdentifiers, String requestId, String templateId, Collection readablePersistenceManagers, String appName) {
        ArrayList<Document> errorResponseList = new ArrayList<Document>();
        ArrayList<String> invalidAssigningFacilitiesInFilter = new ArrayList<String>();
        String assigningFacility = null;
        ArrayList<String> configuredSites = new ArrayList<String>();
        String configuredSiteId = null;
        ReadPersistenceManagerInterface readPersistenceManager = null;
        for (Object rpm : readablePersistenceManagers) {
            if (rpm instanceof ReadPersistenceManagerInterface) {
                readPersistenceManager = (ReadPersistenceManagerInterface)rpm;
                configuredSiteId = readPersistenceManager.getSiteIdentifier();
            }
            if (configuredSiteId == null) continue;
            configuredSites.add(configuredSiteId.trim());
        }
        for (PersonIdentifierInterface resolvedPersonIdentifier : filterPersonIdentifiers) {
            assigningFacility = resolvedPersonIdentifier.getAssigningFacility().trim();
            if (this.validNonVistaSites.contains(assigningFacility) || configuredSites.contains(assigningFacility)) continue;
            invalidAssigningFacilitiesInFilter.add(assigningFacility);
        }
        if (invalidAssigningFacilitiesInFilter.size() > 0) {
            if (configuredSites.size() > 0) {
                errorResponseList.add(ExceptionHandler.handleException((Exception)((Object)new ReadException(ErrorCodeEnum.INVALID_ASSIGNING_FACILITIES_IN_FILTER_XML_REQUEST, ((Object)invalidAssigningFacilitiesInFilter).toString())), templateId, requestId, appName));
            } else {
                errorResponseList.add(ExceptionHandler.handleException((Exception)((Object)new ReadException(ErrorCodeEnum.ALL_ASSIGNING_FACILITIES_INVALID_IN_FILTER_XML_REQUEST, ((Object)invalidAssigningFacilitiesInFilter).toString())), templateId, requestId, appName));
            }
        }
        return errorResponseList;
    }

    @Override
    public List<String> getValidNonVistaSites() {
        return this.validNonVistaSites;
    }

    @Override
    public void addValidNonVistaSite(String validNonVistaSite) {
        if (null != validNonVistaSite && validNonVistaSite.length() > 0 && !this.validNonVistaSites.contains(validNonVistaSite)) {
            this.validNonVistaSites.add(validNonVistaSite);
        }
    }

    @Override
    public void removeValidNonVistaSite(String validNonVistaSite) {
        this.validNonVistaSites.remove(validNonVistaSite);
    }

    public void setDomainClinicalRecordOwnerMap(Map<String, DomainClinicalRecordElementHelperInterface> domainClinicalRecordOwnerMap) {
        this.domainClinicalRecordOwnerMap = domainClinicalRecordOwnerMap;
    }

    public void setCreatedRecordLimitIndex(int createdRecordLimitIndex) {
        this.createdRecordLimitIndex = createdRecordLimitIndex;
    }

    public void setVistaCreateDomainEntryPointsList(List<String> vistaCreateDomainEntryPointsList) {
        this.vistaCreateTemplateDomainEntryPointsList = vistaCreateDomainEntryPointsList;
    }

    public void setCdsVistaWrite(CdsWriteInterface cdsVistaWrite) {
        this.cdsVistaWrite = cdsVistaWrite;
    }
}

