/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.tfs.util;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.EntryFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FilterMetaDataHelper {
    public static Set<String> buildVhimVersions(String aCommaEncodedString) {
        String[] vhimVersions = aCommaEncodedString.replaceAll("[\\[\\]]", "").trim().split(",");
        return new HashSet<String>(Arrays.asList(vhimVersions));
    }

    public static Set<EntryFilter> buildEntryFilters(String entryPoints) {
        HashSet<EntryFilter> entryfilters = new HashSet<EntryFilter>();
        String entryPointsLocal = null;
        if (null != entryPoints && 0 < (entryPointsLocal = entryPoints.trim()).length()) {
            String[] templateEntryPoints;
            for (String entryPoint : templateEntryPoints = entryPointsLocal.replaceAll("[\\[\\]]", "").trim().split(", *")) {
                EntryFilter entryFilter = new EntryFilter();
                entryFilter.setXpath(null);
                entryFilter.setDomainEntryPoint(FilterMetaDataHelper.findEntryPoint(entryPoint));
                entryfilters.add(entryFilter);
            }
        }
        return entryfilters;
    }

    private static DomainEntryPoint findEntryPoint(String entryPoint) {
        String templateEntryPoint = null;
        DomainEntryPoint dep = null;
        if (null != entryPoint) {
            templateEntryPoint = entryPoint.trim();
        }
        if (null != templateEntryPoint && 0 < templateEntryPoint.length()) {
            dep = DomainEntryPoint.valueOf((String)entryPoint);
        }
        return dep;
    }

    public static EntryFilter getEntryFilter(DomainEntryPoint entryPoint) {
        EntryFilter filter = new EntryFilter();
        filter.setDomainEntryPoint(entryPoint);
        return filter;
    }
}

