/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.template;

import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.clinicaldata.TemplateMetaData;
import gov.va.med.cds.clinicaldata.TemplateMetaDataInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.template.TemplateServiceException;
import gov.va.med.cds.template.TemplateServiceInterface;
import gov.va.med.cds.tfs.util.TemplateMetaDataHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TemplateServiceSimulator
implements TemplateServiceInterface {
    private Map<String, Properties> templateMetaDataMap = new HashMap<String, Properties>();

    private File getTemplateJarFile(String aTemplateId) {
        String filePath;
        File file = null;
        Properties properties = this.templateMetaDataMap.get(aTemplateId);
        if (null != properties && null != (filePath = properties.getProperty("file")) && 0 < filePath.length()) {
            filePath = filePath.replace('\\', File.separatorChar);
            file = new File(filePath);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getBytesFromFile(File file) {
        FileInputStream is = null;
        try {
            int offset;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new IOException("File to big to convert: " + file.getName());
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file: " + file.getName());
            }
            ((InputStream)is).close();
            return bytes;
        }
        catch (IOException e) {
            throw new TemplateServiceException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_METADATA, (Throwable)e, new String[]{"Couldn't create a File from the template file path: " + file.getAbsolutePath(), e.getMessage()});
        }
        finally {
            if (is != null) {
                try {
                    try {
                        ((InputStream)is).close();
                        is = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        is = null;
                    }
                }
                catch (Throwable throwable) {
                    is = null;
                    throw throwable;
                }
            }
        }
    }

    public Collection<String> getActiveTemplateIds(String aVhimVersion) {
        ArrayList<String> templateIds = new ArrayList<String>();
        for (Map.Entry<String, Properties> entry : this.templateMetaDataMap.entrySet()) {
            if (!entry.getValue().getProperty("vhimVersion").equals(aVhimVersion)) continue;
            String templateId = entry.getKey();
            templateIds.add(templateId);
        }
        return templateIds;
    }

    public TemplateMetaDataInterface getTemplateMetaData(String aTemplateId) {
        TemplateMetaData metaData = null;
        Properties metaProps = this.templateMetaDataMap.get(aTemplateId);
        if (null != metaProps) {
            metaData = new TemplateMetaData();
            metaData.setTemplateId(metaProps.getProperty("id"));
            String[] vhimVersions = TemplateMetaDataHelper.buildVhimVersions(metaProps.getProperty("vhimVersion"));
            metaData.setVhimVersions(vhimVersions);
            metaData.setDomainEntryPoints(TemplateMetaDataHelper.buildEntryPoints(metaProps.getProperty("entryPoint")));
            metaData.setTemplateName(metaProps.getProperty("name"));
            metaData.setOperation(Operation.valueOf((String)metaProps.getProperty("requestType")));
            metaData.setTemplateDescription(metaProps.getProperty("description"));
            metaData.setTestOnly(metaProps.getProperty("testOnly", "false"));
            metaData.setStatus("ACTIVE");
            File jarFile = this.getTemplateJarFile(aTemplateId);
            metaData.setTemplateJar(this.getBytesFromFile(jarFile));
        }
        return metaData;
    }

    public Collection<String> getVhimVersions() {
        ArrayList<String> vhimVersions = new ArrayList<String>();
        for (Map.Entry<String, Properties> entry : this.templateMetaDataMap.entrySet()) {
            Properties props = entry.getValue();
            String vhimVersion = props.getProperty("vhimVersion");
            if (null == vhimVersion || 0 >= vhimVersion.length() || vhimVersions.contains(vhimVersion)) continue;
            vhimVersions.add(vhimVersion);
        }
        return vhimVersions;
    }

    public void initialize() {
    }

    public synchronized void setTestTemplates(Properties testProperties) throws IOException {
        String path = testProperties.getProperty("path", ".");
        boolean loadTestTemplates = Boolean.parseBoolean(testProperties.getProperty("loadTestTemplates", "false"));
        File dir = new File(path);
        if (!dir.exists()) {
            return;
        }
        if (dir.isFile()) {
            this.loadTemplateMetaDataIntoMap(dir, loadTestTemplates);
        } else {
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".meta");
                }
            });
            for (int i = 0; i < files.length; ++i) {
                this.loadTemplateMetaDataIntoMap(files[i], loadTestTemplates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTemplateMetaDataIntoMap(File templatePropFile, boolean loadTestTemplates) throws IOException {
        FileInputStream propInputStream = null;
        try {
            propInputStream = new FileInputStream(templatePropFile);
            Properties templateProps = new Properties();
            templateProps.load(propInputStream);
            propInputStream.close();
            boolean testonly = Boolean.parseBoolean(templateProps.getProperty("testOnly", "false"));
            if (loadTestTemplates || !testonly) {
                this.templateMetaDataMap.put(templateProps.getProperty("id"), templateProps);
            }
        }
        finally {
            if (propInputStream != null) {
                try {
                    propInputStream.close();
                }
                finally {
                    propInputStream = null;
                }
            }
        }
    }

    public boolean isAlive() {
        return true;
    }
}

