/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.template;

import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.clinicaldata.TemplateMetaDataInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.request.RequestValidatorInterface;
import gov.va.med.cds.request.ResponseValidatorInterface;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.request.WriteRequestInterface;
import gov.va.med.cds.template.TemplateCacheException;
import gov.va.med.cds.template.TemplateCacheInterface;
import gov.va.med.cds.template.TemplateCachePersistenceInterface;
import gov.va.med.cds.template.TemplateManagerMBeanInterface;
import gov.va.med.cds.template.TemplateMetaDataProviderException;
import gov.va.med.cds.template.TemplateMetaDataProviderInterface;
import gov.va.med.cds.template.TemplateServiceException;
import gov.va.med.cds.template.TemplateServiceInterface;
import gov.va.med.cds.xml.schema.SchemaHelperInterface;
import gov.va.med.cds.xml.schema.SchemaValidationException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.xml.sax.SAXException;

public class TemplateManager
implements TemplateMetaDataProviderInterface,
RequestValidatorInterface,
ResponseValidatorInterface,
TemplateManagerMBeanInterface {
    private static final Log LOGGER = LogFactory.getLog(TemplateManager.class);
    private TemplateCacheInterface templateCache = null;
    private TemplateCachePersistenceInterface templateCachePersistence = null;
    private TemplateServiceInterface templateService = null;

    public TemplateManager(TemplateServiceInterface aTemplateService, TemplateCachePersistenceInterface aTemplateCachePersistence, TemplateCacheInterface aTemplateCache) throws Exception {
        this.templateService = aTemplateService;
        this.templateCachePersistence = aTemplateCachePersistence;
        this.templateCache = aTemplateCache;
        this.initialize();
    }

    @Override
    public TemplateMetaDataInterface validateWriteRequest(WriteRequestInterface aWriteRequest) {
        if (aWriteRequest == null) {
            throw new ValidationException(ErrorCodeEnum.WRITE_REQUEST_XML_NULL);
        }
        String requestTemplateId = aWriteRequest.getTemplateId();
        String requestXml = aWriteRequest.getRequestData();
        Validator validator = null;
        TemplateMetaDataInterface templateMetaData = null;
        try {
            validator = this.getTemplateValidator(requestTemplateId);
            templateMetaData = this.getTemplateMetaData(requestTemplateId);
        }
        catch (TemplateCacheException e) {
            throw new ValidationException(ErrorCodeEnum.WRITE_REQUEST_TEMPLATE_ID_INVALID, requestTemplateId, ExceptionUtils.getRootCause((Throwable)((Object)e)) == null ? e.getMessage() : ExceptionUtils.getRootCause((Throwable)((Object)e)).getMessage());
        }
        try {
            validator.validate(new StreamSource(new StringReader(requestXml)));
        }
        catch (SAXException e) {
            throw new SchemaValidationException(ErrorCodeEnum.SCHEMA_VALIDATION_FAILED, e, e.getMessage());
        }
        catch (IOException e) {
            throw new SchemaValidationException(ErrorCodeEnum.SCHEMA_VALIDATION_FAILED, e, e.getMessage());
        }
        return templateMetaData;
    }

    @Override
    public TemplateMetaDataInterface validateReadTemplateId(String templateId) {
        TemplateMetaDataInterface templateMetaData = null;
        try {
            templateMetaData = this.getTemplateMetaData(templateId);
        }
        catch (TemplateMetaDataProviderException e) {
            throw new ValidationException(ErrorCodeEnum.INVALID_TEMPLATE, e, templateId, ExceptionUtils.getRootCause((Throwable)e) == null ? e.getMessage() : ExceptionUtils.getRootCause((Throwable)e).getMessage());
        }
        if (!templateMetaData.getOperation().name().equals(Operation.Read.name())) {
            throw new ValidationException(ErrorCodeEnum.REQUEST_TYPE_MISMATCH_OPERATION_VS_INSTANCE, Operation.Read.name(), templateMetaData.getOperation().name());
        }
        return templateMetaData;
    }

    @Override
    public void validateReadResponse(Document aReadResponse, String responseTemplateId) {
        String readResponseXML = aReadResponse.asXML();
        try {
            Validator validator = this.getTemplateValidator(responseTemplateId);
            validator.validate(new StreamSource(new StringReader(readResponseXML)));
        }
        catch (SAXException e) {
            throw new SchemaValidationException(ErrorCodeEnum.SCHEMA_VALIDATION_FAILED, e, e.getMessage());
        }
        catch (IOException e) {
            throw new SchemaValidationException(ErrorCodeEnum.SCHEMA_VALIDATION_FAILED, e, e.getMessage());
        }
    }

    public synchronized Validator getTemplateValidator(String aTemplateId) {
        SchemaHelperInterface schemaHelper = this.getSchemaHelper(aTemplateId);
        Validator validator = schemaHelper.getValidator();
        return validator;
    }

    public synchronized Map<String, List<String>> getSymbolMap(String aTemplateId) {
        SchemaHelperInterface schemaHelper;
        try {
            schemaHelper = this.getSchemaHelper(aTemplateId);
        }
        catch (TemplateCacheException e) {
            throw new ValidationException(ErrorCodeEnum.CANNOT_CREATE_TEMPLATE_SCHEMA_SYMBOL_MAP, (Throwable)((Object)e), "Could not get a schema helper for the template id: " + aTemplateId, ExceptionUtils.getRootCause((Throwable)((Object)e)).getMessage());
        }
        Map<String, List<String>> symbolMap = schemaHelper.getSymbolMap();
        return symbolMap;
    }

    public synchronized TemplateMetaDataInterface getTemplateMetaData(String aTemplateId) throws TemplateCacheException {
        TemplateMetaDataInterface metaData = this.templateCache.getTemplateMetaData(aTemplateId);
        if (metaData == null) {
            this.templateCachePersistence.loadTemplateIntoCache(this.templateCache, aTemplateId);
            metaData = this.templateCache.getTemplateMetaData(aTemplateId);
            if (metaData == null) {
                this.retrieveAndPersistTemplateFromService(aTemplateId);
                this.templateCachePersistence.loadTemplateIntoCache(this.templateCache, aTemplateId);
                metaData = this.templateCache.getTemplateMetaData(aTemplateId);
            }
        }
        if (metaData == null) {
            throw new TemplateMetaDataProviderException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_METADATA, new String[]{aTemplateId, "MetaData of the template id is null"});
        }
        return metaData;
    }

    public SchemaHelperInterface getSchemaHelper(String aTemplateId) {
        SchemaHelperInterface schemaHelper = this.templateCache.getSchemaHelper(aTemplateId);
        if (schemaHelper == null) {
            this.templateCachePersistence.loadTemplateIntoCache(this.templateCache, aTemplateId);
            schemaHelper = this.templateCache.getSchemaHelper(aTemplateId);
            if (schemaHelper == null) {
                this.retrieveAndPersistTemplateFromService(aTemplateId);
                this.templateCachePersistence.loadTemplateIntoCache(this.templateCache, aTemplateId);
                schemaHelper = this.templateCache.getSchemaHelper(aTemplateId);
            }
            if (schemaHelper == null) {
                throw new ValidationException(ErrorCodeEnum.INVALID_TEMPLATE, aTemplateId);
            }
        }
        return schemaHelper;
    }

    private void retrieveAndPersistTemplateFromService(String aTemplateId) {
        try {
            TemplateMetaDataInterface templateMetaData = this.templateService.getTemplateMetaData(aTemplateId);
            if (templateMetaData != null) {
                templateMetaData.setDateUpdated(new Date());
                this.templateCachePersistence.saveTemplateMetaDataToPersistence(templateMetaData);
            }
        }
        catch (TemplateServiceException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("TemplateServiceException in retrieveAndPersistTemplateFromService, template ID: " + aTemplateId + " Exception Message: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception in retrieveAndPersistTemplateFromService, template ID: " + aTemplateId + " Exception Message: " + e.getMessage()));
        }
    }

    private void initialize() {
        try {
            this.templateService.initialize();
            this.persistTemplatesFromService();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Template Service Initialization failed");
        }
        this.templateCachePersistence.loadAllTemplatesIntoCache(this.templateCache);
    }

    @Override
    public synchronized void reinitializeTemplateCache() {
        TemplateCacheInterface tempCache = this.templateCache;
        try {
            this.clearTemplateCache();
            this.initialize();
        }
        catch (Exception e) {
            this.templateCache = tempCache;
        }
    }

    @Override
    public synchronized void clearTemplateCache() {
        TemplateCacheInterface tempCache = this.templateCache;
        try {
            if (null != this.templateCache && !this.templateCache.isEmpty()) {
                this.templateCache.clear();
            }
        }
        catch (TemplateServiceException e) {
            this.templateCache = tempCache;
        }
        catch (TemplateCacheException e) {
            this.templateCache = tempCache;
        }
    }

    @Override
    public synchronized void resizeTemplateCache(int newSize) {
        if (this.getTemplateCacheThreshold() > newSize) {
            this.templateCache.reSize(newSize);
            this.reinitializeTemplateCache();
        } else {
            this.templateCache.reSize(newSize);
        }
    }

    @Override
    public int getNumberOfTemplatesLoadedIntoTemplateCache() {
        return this.templateCache.getNumberOfTemplatesLoadedIntoTemplateCache();
    }

    @Override
    public List<String> getTemplateCacheTemplateIds() {
        ArrayList<String> list = new ArrayList<String>(this.templateCache.getTemplateCacheTemplateIds());
        return list;
    }

    @Override
    public int getTemplateCacheThreshold() {
        return this.templateCache.getTemplateCacheThreshold();
    }

    private void persistTemplatesFromService() {
        Collection templateIds = null;
        Collection vhimVersions = this.templateService.getVhimVersions();
        for (String vhimVersionName : vhimVersions) {
            templateIds = this.templateService.getActiveTemplateIds(vhimVersionName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("looping on vhim version: " + vhimVersionName));
            }
            for (String templateId : templateIds) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("\tRetrieving and Persisting template from service, template ID: " + templateId));
                }
                this.retrieveAndPersistTemplateFromService(templateId);
            }
        }
    }

    public void setTemplateCache(TemplateCacheInterface aTemplateCache) {
        this.templateCache = aTemplateCache;
    }
}

