/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.template;

import gov.va.med.cds.request.ErrorSectionHelperInterface;
import gov.va.med.cds.response.PatientIdentifierDocumentBuilderInterface;
import gov.va.med.cds.response.ResponseAggregatorInterface;
import gov.va.med.cds.response.WriteResponseGeneratorInterface;
import gov.va.med.cds.response.organizer.ResponseOrganizerInterface;
import gov.va.med.cds.response.sequencer.ResponseSequencerInterface;
import gov.va.med.cds.template.TemplateHelperInterface;
import java.util.Map;

public class TemplateHelper
implements TemplateHelperInterface {
    private static final String APP_NAME_KEY = "applicationName";
    private Map<String, Map<String, Object>> templateDependentObjectsMap;
    private String defaultApplicationName = null;

    @Override
    public WriteResponseGeneratorInterface getWriteResponseGenerator(String templateId) {
        WriteResponseGeneratorInterface writeResponseGenerator = (WriteResponseGeneratorInterface)this.templateDependentObjectsMap.get(templateId).get(WriteResponseGeneratorInterface.class.getName());
        if (writeResponseGenerator == null) {
            throw new RuntimeException("No write response generator configured for " + templateId);
        }
        return writeResponseGenerator;
    }

    @Override
    public ErrorSectionHelperInterface getErrorSectionHelper(String templateId) {
        Map<String, Object> objectsMap = this.templateDependentObjectsMap.get(templateId);
        if (objectsMap != null) {
            return (ErrorSectionHelperInterface)objectsMap.get(ErrorSectionHelperInterface.class.getName());
        }
        return null;
    }

    @Override
    public ResponseAggregatorInterface getResponseAggregator(String templateId) {
        return (ResponseAggregatorInterface)this.templateDependentObjectsMap.get(templateId).get(ResponseAggregatorInterface.class.getName());
    }

    @Override
    public ResponseSequencerInterface getResponseSequencer(String templateId) {
        return (ResponseSequencerInterface)this.templateDependentObjectsMap.get(templateId).get(ResponseSequencerInterface.class.getName());
    }

    public void setTemplateDependentObjectsMap(Map<String, Map<String, Object>> templateDependentObjectsMap) {
        this.templateDependentObjectsMap = templateDependentObjectsMap;
    }

    public void setDefaultApplicationName(String defaultApplicationName) {
        this.defaultApplicationName = defaultApplicationName;
    }

    @Override
    public PatientIdentifierDocumentBuilderInterface getPatientIdentifierDocumentBuilder(String templateId) {
        return (PatientIdentifierDocumentBuilderInterface)this.templateDependentObjectsMap.get(templateId).get(PatientIdentifierDocumentBuilderInterface.class.getName());
    }

    @Override
    public ResponseOrganizerInterface getResponseOrganizer(String templateId) {
        ResponseOrganizerInterface organizer = null;
        Map<String, Object> mapEntry = this.templateDependentObjectsMap.get(templateId);
        if (mapEntry != null) {
            organizer = (ResponseOrganizerInterface)mapEntry.get(ResponseOrganizerInterface.class.getName());
        }
        return organizer;
    }

    @Override
    public String getApplicationName(String templateId) {
        Map<String, Object> mapEntry = this.templateDependentObjectsMap.get(templateId);
        return mapEntry != null && mapEntry.get(APP_NAME_KEY) != null ? (String)mapEntry.get(APP_NAME_KEY) : this.defaultApplicationName;
    }
}

