/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.template;

import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.clinicaldata.TemplateMetaData;
import gov.va.med.cds.clinicaldata.TemplateMetaDataInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.template.TemplateCacheException;
import gov.va.med.cds.template.TemplateCacheInterface;
import gov.va.med.cds.template.TemplateCachePersistenceInterface;
import gov.va.med.cds.tfs.util.TemplateMetaDataHelper;
import gov.va.med.cds.util.SearchPathGeneratorInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class TemplateCacheFileManager
implements TemplateCachePersistenceInterface {
    private Log logger = LogFactory.getLog(TemplateCacheFileManager.class);
    private PathMatchingResourcePatternResolver pathResolver = new PathMatchingResourcePatternResolver();
    private SearchPathGeneratorInterface searchPathGenerator = null;
    private boolean persist = false;

    public void setPersist(boolean persist) {
        this.persist = persist;
    }

    public void setSearchPathGenerator(SearchPathGeneratorInterface searchPathGenerator) {
        this.searchPathGenerator = searchPathGenerator;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveTemplateMetaDataToPersistence(TemplateMetaDataInterface aTemplateMetaData) {
        File newJarFile;
        block19: {
            if (!this.persist) {
                return;
            }
            String newJarName = this.searchPathGenerator.getSearchPath() + File.separatorChar + aTemplateMetaData.getWriteCdsVdm() + File.separatorChar + this.makeFileName(aTemplateMetaData.getTemplateName() + ".jar");
            byte[] templateJar = aTemplateMetaData.getTemplateJar();
            FileOutputStream fos = null;
            URL url = null;
            try {
                url = new URL(newJarName);
            }
            catch (MalformedURLException e) {
                throw new TemplateCacheException(ErrorCodeEnum.CANNOT_SAVE_TEMPLATE, e, "Malformed URL : " + newJarName, e.getMessage());
            }
            String fileName = url.getFile();
            newJarFile = new File(fileName);
            try {
                if (!newJarFile.exists()) {
                    newJarFile.createNewFile();
                }
                if (templateJar != null && templateJar.length > 0) {
                    fos = new FileOutputStream(newJarFile);
                    fos.write(templateJar);
                    fos.flush();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("File path: " + newJarName));
                }
                if (null == fos) break block19;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new TemplateCacheException(ErrorCodeEnum.CANNOT_SAVE_TEMPLATE, e, "Could not find the file: " + newJarName, e.getMessage());
                    catch (IOException e2) {
                        throw new TemplateCacheException(ErrorCodeEnum.CANNOT_SAVE_TEMPLATE, e2, "Could not find the file: " + newJarName, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (null == fos) throw throwable;
                    try {
                        try {
                            fos.close();
                            fos = null;
                            throw throwable;
                        }
                        catch (IOException e3) {
                            throw new TemplateCacheException(ErrorCodeEnum.CANNOT_SAVE_TEMPLATE, e3, "Problem closing the stream for : " + newJarName, e3.getMessage());
                        }
                    }
                    catch (Throwable throwable2) {
                        fos = null;
                        throw throwable2;
                    }
                }
            }
            try {
                try {
                    fos.close();
                    fos = null;
                }
                catch (IOException e) {
                    throw new TemplateCacheException(ErrorCodeEnum.CANNOT_SAVE_TEMPLATE, e, "Problem closing the stream for : " + newJarName, e.getMessage());
                }
            }
            catch (Throwable throwable) {
                fos = null;
                throw throwable;
            }
        }
        this.saveMetaData(aTemplateMetaData, newJarFile);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveMetaData(TemplateMetaDataInterface templateMetaData, File newJarFile) {
        FileOutputStream fos = null;
        String metaFilePath = null;
        try {
            Properties metaProps = this.getMetaDataProperties(templateMetaData, newJarFile.getPath());
            metaFilePath = newJarFile.getParentFile().getParent() + File.separator + newJarFile.getName().split("\\.jar")[0] + ".meta";
            fos = new FileOutputStream(metaFilePath);
            metaProps.store(fos, null);
            if (null == fos) return;
        }
        catch (FileNotFoundException e) {
            try {
                throw new TemplateCacheException(ErrorCodeEnum.CANNOT_SAVE_TEMPLATE, e, "Failed to save the metaFile: " + metaFilePath, e.getMessage());
                catch (IOException e2) {
                    throw new TemplateCacheException(ErrorCodeEnum.CANNOT_SAVE_TEMPLATE, e2, "Failed to save the metaFile: " + metaFilePath, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (null == fos) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new TemplateCacheException(ErrorCodeEnum.CANNOT_SAVE_TEMPLATE, e3, "Problem closing the stream for meta file : " + metaFilePath, e3.getMessage());
                }
            }
        }
        try {
            fos.close();
            return;
        }
        catch (IOException e) {
            throw new TemplateCacheException(ErrorCodeEnum.CANNOT_SAVE_TEMPLATE, e, "Problem closing the stream for meta file : " + metaFilePath, e.getMessage());
        }
    }

    @Override
    public final void loadAllTemplatesIntoCache(TemplateCacheInterface aTemplateCache) throws TemplateCacheException {
        this.loadTemplateCacheFromPersistence(aTemplateCache, null);
    }

    @Override
    public final void loadTemplateIntoCache(TemplateCacheInterface aTemplateCache, String aTemplateId) throws TemplateCacheException {
        this.loadTemplateCacheFromPersistence(aTemplateCache, aTemplateId);
    }

    public void loadTemplateCacheFromPersistence(TemplateCacheInterface templateCache, String aTemplateId) throws TemplateCacheException {
        Resource[] metaResources = null;
        metaResources = aTemplateId == null ? this.findMetaResourcesFromDefaultSearchPath(metaResources) : this.findMetaResourcesFromSpecificTemplateId(aTemplateId, metaResources);
        try {
            this.loadEachResourceIntoTemplateCache(templateCache, metaResources);
        }
        catch (IOException e) {
            throw new TemplateCacheException(ErrorCodeEnum.COULD_NOT_CREATE_A_URL, e, "Failed to create a resource URL while trying to create an error message.", e.getMessage());
        }
    }

    private void loadEachResourceIntoTemplateCache(TemplateCacheInterface templateCache, Resource[] metaResources) throws IOException {
        String absolutePath = null;
        String templateFilePath = null;
        Resource[] schemaResources = null;
        for (Resource metaResource : metaResources) {
            TemplateMetaData metaData = new TemplateMetaData();
            absolutePath = this.resolveMetaData(metaResource.getURL().toString(), (TemplateMetaDataInterface)metaData);
            if (null == absolutePath || 0 >= absolutePath.length()) continue;
            templateFilePath = "jar:" + absolutePath + "!/template/*.xsd";
            try {
                schemaResources = this.pathResolver.getResources(templateFilePath);
            }
            catch (IOException e) {
                throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_SCHEMA_INTO_TEMPLATE_CACHE, e, "Couldn't resolve template paths using: " + templateFilePath, e.getMessage());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("about to load schema resource: " + schemaResources[0].getURL()));
            }
            try {
                templateCache.loadSchemaIntoCache((TemplateMetaDataInterface)metaData);
            }
            catch (IOException e) {
                throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_SCHEMA_INTO_TEMPLATE_CACHE, e, "Failed to load template schema from path: " + schemaResources[0].getURL(), e.getMessage());
            }
        }
    }

    private Resource[] findMetaResourcesFromSpecificTemplateId(String aTemplateId, Resource[] metaResources) {
        String searchPath = this.searchPathGenerator.getSearchPath() + "/" + aTemplateId + ".meta";
        return this.findMetaResourcesFromSpecificSearchPath(searchPath, metaResources);
    }

    private Resource[] findMetaResourcesFromSpecificSearchPath(String searchPath, Resource[] metaResources) {
        try {
            metaResources = this.pathResolver.getResources(searchPath);
        }
        catch (IOException e) {
            throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_SCHEMA_INTO_TEMPLATE_CACHE, e, "Couldn't get template meta data resources using: " + searchPath, e.getMessage());
        }
        return metaResources;
    }

    private Resource[] findMetaResourcesFromDefaultSearchPath(Resource[] metaResources) {
        try {
            metaResources = this.pathResolver.getResources(this.searchPathGenerator.getSearchPath() + "/**/*.meta");
        }
        catch (IOException e) {
            throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_SCHEMA_INTO_TEMPLATE_CACHE, e, "Couldn't get template meta data resources using: " + this.searchPathGenerator.getSearchPath() + "/**/*.meta", e.getMessage());
        }
        return metaResources;
    }

    private String makeFileName(String templateName) {
        return templateName.replaceAll("[^-.a-zA-Z_0-9]", "_");
    }

    private Properties getMetaDataProperties(TemplateMetaDataInterface metaData, String jarPath) {
        Properties metaProps = new Properties();
        metaProps.setProperty("file", jarPath);
        metaProps.setProperty("id", metaData.getTemplateId());
        String encodedVhimVersions = "";
        String[] vhimVersions = metaData.getVhimVersions();
        if (vhimVersions.length > 0) {
            encodedVhimVersions = vhimVersions[0];
            for (int i = 1; i < vhimVersions.length; ++i) {
                encodedVhimVersions = encodedVhimVersions + ", " + vhimVersions[i];
            }
        }
        metaProps.setProperty("vhimVersions", encodedVhimVersions);
        Collection<String> entryPoints = TemplateMetaDataHelper.getEntryPoints(metaData.getDomainEntryPoints());
        if (null != entryPoints) {
            metaProps.setProperty("entryPoint", entryPoints.toString());
        }
        metaProps.setProperty("name", metaData.getTemplateName());
        metaProps.setProperty("requestType", metaData.getOperation().name());
        metaProps.setProperty("description", metaData.getTemplateDescription());
        return metaProps;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String resolveMetaData(String templatePropFileName, TemplateMetaDataInterface aTemplateMetaData) {
        Properties templateProps;
        String resourceFile;
        block14: {
            File templatePropFile;
            resourceFile = null;
            FileInputStream propInputStream = null;
            try {
                templatePropFile = new File(new URL(templatePropFileName).getFile());
            }
            catch (MalformedURLException e) {
                throw new TemplateCacheException(ErrorCodeEnum.COULD_NOT_CREATE_A_URL, e, "Couldn't create a URL from: " + templatePropFileName, e.getMessage());
            }
            templateProps = new Properties();
            try {
                propInputStream = new FileInputStream(templatePropFile);
                templateProps.load(propInputStream);
                if (null == propInputStream) break block14;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_SCHEMA_INTO_TEMPLATE_CACHE, e, "Failure loading property file for meta data: " + templatePropFileName, e.getMessage());
                    catch (IOException e2) {
                        throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_SCHEMA_INTO_TEMPLATE_CACHE, e2, "Failure loading property file for meta data: " + templatePropFileName, e2.getMessage());
                    }
                    catch (IllegalArgumentException e3) {
                        throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_SCHEMA_INTO_TEMPLATE_CACHE, e3, "Problem with the meta data property file format for file: " + templatePropFile + ". Probably due to a uuencoding problem in its content.", e3.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (null == propInputStream) throw throwable;
                    try {
                        ((InputStream)propInputStream).close();
                        throw throwable;
                    }
                    catch (IOException e4) {
                        throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_SCHEMA_INTO_TEMPLATE_CACHE, e4, "Failure property file stream for meta data: " + templatePropFileName, e4.getMessage());
                    }
                }
            }
            try {
                ((InputStream)propInputStream).close();
            }
            catch (IOException e) {
                throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_SCHEMA_INTO_TEMPLATE_CACHE, e, "Failure property file stream for meta data: " + templatePropFileName, e.getMessage());
            }
        }
        try {
            resourceFile = new URL("file", null, templateProps.getProperty("file")).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new TemplateCacheException(ErrorCodeEnum.COULD_NOT_CREATE_A_URL, e, "Couldn't create a URL from the meta data property : " + templateProps.getProperty("file"), e.getMessage());
        }
        aTemplateMetaData.setTemplateId(templateProps.getProperty("id"));
        String[] vhimVersions = TemplateMetaDataHelper.buildVhimVersions(templateProps.getProperty("vhimVersion"));
        aTemplateMetaData.setVhimVersions(vhimVersions);
        aTemplateMetaData.setDomainEntryPoints(TemplateMetaDataHelper.buildEntryPoints(templateProps.getProperty("entryPoint")));
        aTemplateMetaData.setTemplateName(templateProps.getProperty("name"));
        aTemplateMetaData.setOperation(Operation.valueOf((String)templateProps.getProperty("requestType")));
        aTemplateMetaData.setTemplateDescription(templateProps.getProperty("description"));
        return resourceFile;
    }
}

