/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.template;

import gov.va.med.cds.clinicaldata.TemplateMetaDataInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.InitializationException;
import gov.va.med.cds.template.TemplateCacheInterface;
import gov.va.med.cds.template.TemplateCacheModelData;
import gov.va.med.cds.template.TemplateCacheModelInterface;
import gov.va.med.cds.util.LRUHashMap;
import gov.va.med.cds.util.LogMessageUtil;
import gov.va.med.cds.xml.schema.SchemaHelper;
import gov.va.med.cds.xml.schema.SchemaHelperInterface;
import java.io.IOException;
import java.sql.Blob;
import java.util.Calendar;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateCache
implements TemplateCacheInterface {
    private static final Log logger = LogFactory.getLog(TemplateCache.class);
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.reentrantReadWriteLock.readLock();
    private final Lock writeLock = this.reentrantReadWriteLock.writeLock();
    private LRUHashMap<String, TemplateCacheModelInterface> templateCacheModelMap = null;

    public TemplateCache(LRUHashMap<String, TemplateCacheModelInterface> aMap) {
        this.templateCacheModelMap = aMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSchemaIntoCache(TemplateMetaDataInterface aTemplateMetaData) throws IOException {
        SchemaHelper schemaHelper;
        TemplateCacheModelData templateCacheModel = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loading schema " + aTemplateMetaData.getTemplateName()));
            }
            SerialBlob schemaJar = new SerialBlob(aTemplateMetaData.getTemplateJar());
            schemaHelper = this.getSchemaHelper(aTemplateMetaData, schemaJar);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loaded schema " + aTemplateMetaData.getTemplateName()));
            }
        }
        catch (Exception e) {
            throw new InitializationException(ErrorCodeEnum.UNABLE_TO_LOAD_SCHEMAS_INTO_CACHE, e, aTemplateMetaData.getTemplateName(), e.getMessage());
        }
        String templateId = aTemplateMetaData.getTemplateId();
        if (!this.templateCacheModelMap.containsKey(templateId)) {
            this.writeLock.lock();
            try {
                if (!this.templateCacheModelMap.containsKey(templateId)) {
                    templateCacheModel = new TemplateCacheModelData();
                    templateCacheModel.setTemplateMetaData(aTemplateMetaData);
                    templateCacheModel.setSchemaHelper(schemaHelper);
                    templateCacheModel.setLoadedIntoCache(Calendar.getInstance().getTimeInMillis());
                    this.templateCacheModelMap.put(templateId, templateCacheModel);
                } else if (logger.isInfoEnabled()) {
                    String msg = "The template ID='" + templateId + "' already exists. The template registry will not add another one.";
                    logger.info((Object)LogMessageUtil.buildMessage(null, null, null, (String)msg), null);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public TemplateCacheModelInterface getTemplateCacheModel(String aTemplateId) {
        TemplateCacheModelInterface templateCacheModel = null;
        try {
            this.readLock.lock();
            templateCacheModel = (TemplateCacheModelInterface)this.templateCacheModelMap.get(aTemplateId);
        }
        finally {
            this.readLock.unlock();
        }
        return templateCacheModel;
    }

    public Collection<TemplateCacheModelInterface> getAllTemplateCacheModels() {
        Collection<TemplateCacheModelInterface> allTemplateCacheModels = null;
        try {
            this.readLock.lock();
            allTemplateCacheModels = this.templateCacheModelMap.values();
        }
        finally {
            this.readLock.unlock();
        }
        return allTemplateCacheModels;
    }

    @Override
    public TemplateMetaDataInterface getTemplateMetaData(String aTemplateId) {
        TemplateMetaDataInterface templateMetaData = null;
        TemplateCacheModelInterface templateCacheModel = this.getTemplateCacheModel(aTemplateId);
        if (templateCacheModel != null) {
            templateMetaData = templateCacheModel.getTemplateMetaData();
        }
        return templateMetaData;
    }

    @Override
    public SchemaHelperInterface getSchemaHelper(String aTemplateId) {
        SchemaHelperInterface schemaHelper = null;
        TemplateCacheModelInterface templateCacheModel = this.getTemplateCacheModel(aTemplateId);
        if (templateCacheModel != null) {
            schemaHelper = templateCacheModel.getSchemaHelper();
        }
        return schemaHelper;
    }

    @Override
    public boolean isEmpty() {
        boolean isEmpty = true;
        try {
            this.readLock.lock();
            isEmpty = this.templateCacheModelMap.isEmpty();
        }
        finally {
            this.readLock.unlock();
        }
        return isEmpty;
    }

    @Override
    public void clear() {
        try {
            this.writeLock.lock();
            this.templateCacheModelMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void reSize(int newSize) {
        try {
            this.writeLock.lock();
            this.templateCacheModelMap.reSize(newSize);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int getNumberOfTemplatesLoadedIntoTemplateCache() {
        return this.templateCacheModelMap.size();
    }

    @Override
    public int getTemplateCacheThreshold() {
        return this.templateCacheModelMap.getMapThreshold();
    }

    @Override
    public Set<String> getTemplateCacheTemplateIds() {
        return this.templateCacheModelMap.keySet();
    }

    SchemaHelper getSchemaHelper(TemplateMetaDataInterface aTemplateMetaData, Blob schemaJar) {
        return new SchemaHelper(schemaJar, aTemplateMetaData.getTemplateName());
    }
}

