/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.template;

import gov.va.med.cds.exceptionframework.ExceptionHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;

public class SchemaResourceResolver
implements LSResourceResolver {
    static final int BUFF_SIZE = 100000;
    static final byte[] buffer = new byte[100000];
    Hashtable<String, JarEntry> jarEntries = null;
    Hashtable<String, byte[]> jarEntryStreams = null;
    byte[] schema = null;

    public byte[] getSchema() {
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaResourceResolver(Blob aJar) throws Exception {
        ZipInputStream jarInputStream = null;
        InputStream inputStream = null;
        try {
            inputStream = aJar.getBinaryStream();
            jarInputStream = new JarInputStream(inputStream);
            this.resolveSchemas((JarInputStream)jarInputStream);
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                finally {
                    jarInputStream = null;
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                finally {
                    inputStream = null;
                }
            }
        }
    }

    public SchemaResourceResolver(JarInputStream aJarInputStream) {
        this.resolveSchemas(aJarInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void resolveSchemas(JarInputStream aJarInputStream) {
        this.jarEntries = new Hashtable();
        this.jarEntryStreams = new Hashtable();
        JarEntry jarEntry = null;
        String entryName = null;
        byte[] jarEntryByteArray = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            block4: while ((jarEntry = aJarInputStream.getNextJarEntry()) != null) {
                entryName = jarEntry.getName();
                this.jarEntries.put(entryName, jarEntry);
                if (jarEntry.isDirectory()) continue;
                byteArrayOutputStream = new ByteArrayOutputStream();
                while (true) {
                    byte[] byArray = buffer;
                    // MONITORENTER : buffer
                    int amountRead = aJarInputStream.read(buffer);
                    if (amountRead == -1) {
                        // MONITOREXIT : byArray
                        jarEntryByteArray = byteArrayOutputStream.toByteArray();
                        if (!entryName.endsWith(".xsd")) continue block4;
                        break;
                    }
                    byteArrayOutputStream.write(buffer, 0, amountRead);
                    // MONITOREXIT : byArray
                }
                entryName = entryName.substring(0, entryName.indexOf(".xsd"));
                this.jarEntryStreams.put(entryName, jarEntryByteArray);
                if (!entryName.startsWith("template")) continue;
                this.schema = jarEntryByteArray;
            }
            return;
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, null, null, null);
        }
    }

    public Source getSchemaSource() {
        StreamSource schemaSource = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getSchema());
        schemaSource = new StreamSource(byteArrayInputStream);
        return schemaSource;
    }

    public Source[] getSchemaSources() {
        Source[] schemaSources = new Source[this.jarEntryStreams.size()];
        ByteArrayInputStream byteArrayInputStream = null;
        byte[] jarBytes = null;
        int index = 0;
        Hashtable<String, byte[]> localJarEntryStreams = new Hashtable<String, byte[]>();
        Enumeration<String> jarKeys = this.jarEntryStreams.keys();
        while (jarKeys.hasMoreElements()) {
            String key = jarKeys.nextElement();
            localJarEntryStreams.put(key, this.jarEntryStreams.get(key));
        }
        byte[] basedatatypes = (byte[])localJarEntryStreams.remove("Basedatatypes");
        byte[] common = (byte[])localJarEntryStreams.remove("Common");
        byte[] patient = (byte[])localJarEntryStreams.remove("Patient");
        byte[] entrySchema = this.obtainEntrySchema(localJarEntryStreams);
        byteArrayInputStream = new ByteArrayInputStream(basedatatypes);
        schemaSources[index++] = new StreamSource(byteArrayInputStream);
        byteArrayInputStream = new ByteArrayInputStream(common);
        schemaSources[index++] = new StreamSource(byteArrayInputStream);
        Enumeration<byte[]> jarEnum = localJarEntryStreams.elements();
        while (jarEnum.hasMoreElements()) {
            jarBytes = jarEnum.nextElement();
            byteArrayInputStream = new ByteArrayInputStream(jarBytes);
            schemaSources[index++] = new StreamSource(byteArrayInputStream);
        }
        if (patient != null) {
            byteArrayInputStream = new ByteArrayInputStream(patient);
            schemaSources[index++] = new StreamSource(byteArrayInputStream);
        }
        byteArrayInputStream = new ByteArrayInputStream(entrySchema);
        schemaSources[index++] = new StreamSource(byteArrayInputStream);
        return schemaSources;
    }

    public Map<String, InputSource> getSchemaMap() {
        HashMap<String, InputSource> schemaMap = new HashMap<String, InputSource>();
        InputSource schemaInputSource = null;
        String key = null;
        Enumeration<String> jarKeys = this.jarEntryStreams.keys();
        while (jarKeys.hasMoreElements()) {
            key = jarKeys.nextElement();
            schemaInputSource = this.obtainSchemaInputSource(this.jarEntryStreams.get(key));
            schemaMap.put(key, schemaInputSource);
        }
        return schemaMap;
    }

    private InputSource obtainSchemaInputSource(byte[] aEntrySchema) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aEntrySchema);
        StreamSource schemaSource = new StreamSource(byteArrayInputStream);
        InputSource schemaInputSource = new InputSource(schemaSource.getSystemId());
        schemaInputSource.setByteStream(schemaSource.getInputStream());
        schemaInputSource.setCharacterStream(schemaSource.getReader());
        schemaInputSource.setPublicId(schemaSource.getPublicId());
        return schemaInputSource;
    }

    private byte[] obtainEntrySchema(Hashtable<String, byte[]> localJarEntryStreams) {
        Enumeration<String> jarKeys = localJarEntryStreams.keys();
        while (jarKeys.hasMoreElements()) {
            String key = jarKeys.nextElement();
            if (!key.startsWith("template/")) continue;
            return localJarEntryStreams.remove(key);
        }
        return null;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        MyLSInput newLSInput = null;
        ByteArrayInputStream byteArrayInputStream = null;
        byte[] schemaBytes = this.jarEntryStreams.get(namespaceURI);
        if (schemaBytes != null) {
            byteArrayInputStream = new ByteArrayInputStream(schemaBytes);
            newLSInput = new MyLSInput(publicId, systemId, baseURI, byteArrayInputStream, null);
        }
        return newLSInput;
    }

    class MyLSInput
    implements LSInput {
        protected String publicId = null;
        protected String systemId = null;
        protected String baseSystemId = null;
        protected InputStream byteStream = null;
        protected Reader charStream = null;
        protected String data = null;
        protected String encoding = null;
        protected boolean certifiedText = false;

        public MyLSInput(String aPublicId, String aSystemId, String aBaseSystemId, InputStream aByteStream, String aEncoding) {
            this.publicId = aPublicId;
            this.systemId = aSystemId;
            this.baseSystemId = aBaseSystemId;
            this.byteStream = aByteStream;
            this.encoding = aEncoding;
        }

        @Override
        public String getBaseURI() {
            return this.baseSystemId;
        }

        @Override
        public InputStream getByteStream() {
            return this.byteStream;
        }

        @Override
        public boolean getCertifiedText() {
            return this.certifiedText;
        }

        @Override
        public Reader getCharacterStream() {
            return this.charStream;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getStringData() {
            return this.data;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setBaseURI(String aBaseURI) {
            this.baseSystemId = aBaseURI;
        }

        @Override
        public void setByteStream(InputStream aByteStream) {
            this.byteStream = aByteStream;
        }

        @Override
        public void setCertifiedText(boolean aCertifiedText) {
            this.certifiedText = aCertifiedText;
        }

        @Override
        public void setCharacterStream(Reader aCharacterStream) {
            this.charStream = aCharacterStream;
        }

        @Override
        public void setEncoding(String aEncoding) {
            this.encoding = aEncoding;
        }

        @Override
        public void setPublicId(String aPublicId) {
            this.publicId = aPublicId;
        }

        @Override
        public void setStringData(String aStringData) {
            this.data = aStringData;
        }

        @Override
        public void setSystemId(String aSystemId) {
            this.systemId = aSystemId;
        }
    }
}

