/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.template;

import gov.va.med.cds.clinicaldata.TemplateMetaData;
import gov.va.med.cds.clinicaldata.TemplateMetaDataInterface;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.persistence.hibernate.tfs.AbstractTfsHibernatePersistenceManager;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.template.TemplateCacheException;
import gov.va.med.cds.template.TemplateCacheInterface;
import gov.va.med.cds.template.TemplateCachePersistenceInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class HibernateOracleTemplateCachePersistence
extends AbstractTfsHibernatePersistenceManager
implements TemplateCachePersistenceInterface {
    @Override
    public final void loadAllTemplatesIntoCache(TemplateCacheInterface aTemplateCache) throws TemplateCacheException {
        Session session = this.sessionFactory.getCurrentSession();
        this.loadTemplateCacheFromPersistence(aTemplateCache, null, session);
    }

    @Override
    public final void loadTemplateIntoCache(TemplateCacheInterface aTemplateCache, String aTemplateId) throws TemplateCacheException {
        Session session = this.sessionFactory.getCurrentSession();
        this.loadTemplateCacheFromPersistence(aTemplateCache, aTemplateId, session);
    }

    private List<TemplateMetaData> loadTemplatesFromPersistence(Session aSession) {
        List templateIds = null;
        ArrayList<TemplateMetaData> templateMetaDatas = new ArrayList<TemplateMetaData>();
        try {
            Query query = this.buildTemplateStatusQuery(aSession);
            templateIds = query.list();
            for (String templateId : templateIds) {
                templateMetaDatas.add(this.loadTemplateFromPersistence(aSession, templateId));
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, null, null, null);
        }
        return templateMetaDatas;
    }

    private Query buildTemplateStatusQuery(Session aSession) {
        String queryName = "TemplateSchemaIdsByStatus";
        Query query = aSession.getNamedQuery(queryName);
        query.setParameter("status", (Object)"ACTIVE");
        return query;
    }

    private Query buildTemplateIdQuery(Session aSession, String aTemplateId) {
        String queryName = "TemplateSchemaId";
        Query query = aSession.getNamedQuery(queryName);
        query.setParameter("templateId", (Object)aTemplateId);
        return query;
    }

    private final void loadTemplateCacheFromPersistence(TemplateCacheInterface aTemplateCache, String aTemplateId, Session aSession) throws TemplateCacheException {
        if (aTemplateCache == null) {
            throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_CACHE, "Template cache passed in is null.");
        }
        try {
            if (aTemplateId == null) {
                List<TemplateMetaData> hibernateQueryResults = this.loadTemplatesFromPersistence(aSession);
                for (TemplateMetaData templateMetaData : hibernateQueryResults) {
                    this.loadTemplateCache(aTemplateCache, templateMetaData);
                }
            } else {
                TemplateMetaData templateMetaData = this.loadTemplateFromPersistence(aSession, aTemplateId);
                if (templateMetaData != null) {
                    this.loadTemplateCache(aTemplateCache, templateMetaData);
                }
            }
        }
        catch (HibernateException e) {
            throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_CACHE, e, e.getMessage());
        }
        catch (IOException e) {
            throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_CACHE, e, e.getMessage());
        }
        catch (ValidationException e) {
            throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_CACHE, (Throwable)((Object)e), e.getMessage());
        }
    }

    private TemplateMetaData loadTemplateFromPersistence(Session aSession, String aTemplateId) {
        TemplateMetaData queryResults = null;
        try {
            if (aTemplateId == null) {
                throw new TemplateCacheException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_METADATA, aTemplateId, "aTemplateId cannot be null");
            }
            Query query = this.buildTemplateIdQuery(aSession, aTemplateId);
            queryResults = (TemplateMetaData)query.uniqueResult();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, null, null, null);
        }
        return queryResults;
    }

    private void loadTemplateCache(TemplateCacheInterface aTemplateCache, TemplateMetaData aTemplateMetaData) throws IOException {
        aTemplateCache.loadSchemaIntoCache((TemplateMetaDataInterface)aTemplateMetaData);
    }

    @Override
    public final void saveTemplateMetaDataToPersistence(TemplateMetaDataInterface aTemplateMetaData) throws TemplateCacheException {
        Session session = this.sessionFactory.getCurrentSession();
        try {
            this.persistifyVhimVersions(session, aTemplateMetaData.getVhimVersionWrappers());
            this.persistifyDomainEntryPoints(session, aTemplateMetaData.getDomainEntryPointWrappers());
            this.persistifyTemplate(session, aTemplateMetaData);
        }
        catch (HibernateException e) {
            throw new TemplateCacheException(ErrorCodeEnum.CANNOT_SAVE_TEMPLATE, e, aTemplateMetaData.getTemplateId(), e.getMessage());
        }
    }

    private void persistifyTemplate(Session aSession, TemplateMetaDataInterface aTemplateMetaData) {
        TemplateMetaData queryResult = null;
        Query query = aSession.getNamedQuery("TemplateSchemaId").setParameter("templateId", (Object)aTemplateMetaData.getTemplateId());
        queryResult = (TemplateMetaData)query.uniqueResult();
        if (queryResult != null) {
            aSession.delete((Object)queryResult);
        }
        aSession.flush();
        aSession.save((Object)aTemplateMetaData);
    }
}

