/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.response.vhim400;

import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponseInterface;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.response.WriteResponseGeneratorInterface;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Required;

public class WriteResponseGenerator
implements WriteResponseGeneratorInterface {
    protected ClinicalDataResponseInterface clinicalDataResponse = null;
    protected List<String> createdIdentifierResponseTemplates = null;

    @Override
    public Document generateSuccessfulWriteResponse(String templateId, String requestId, List<Element> createdIdentifiers) {
        return this.buildClinicalDataDocument(templateId, requestId, createdIdentifiers);
    }

    @Override
    public Element generateIdentifierElement(String recordIdentifier, Element clinicalData) {
        return this.clinicalDataResponse.buildRecordIdentifierElement(recordIdentifier, clinicalData);
    }

    protected Document buildClinicalDataDocument(String templateId, String requestId, List<Element> createdIdentifiers) {
        if (this.createdIdentifierResponseTemplates.contains(templateId)) {
            return this.buildClinicalDataDocumentWithCreatedIdentifiers(templateId, requestId, createdIdentifiers);
        }
        return this.buildSimpleClinicalDataDocument(templateId, requestId);
    }

    @Override
    public Document generateWriteErrorResponse(String templateId, String requestId, Exception exception, Document clinicalDataDocument, String applicationName) {
        Document writeResultDocument = ExceptionHandler.handleException(exception, templateId, requestId, applicationName);
        writeResultDocument = this.clinicalDataResponse.buildErrorResponse(templateId, requestId, writeResultDocument, clinicalDataDocument);
        return writeResultDocument;
    }

    protected Document buildClinicalDataDocumentWithCreatedIdentifiers(String templateId, String requestId, List<Element> createdIdentifiers) {
        Document clinicalDataDocument = this.clinicalDataResponse.buildClinicalDocumentWithCreatedIdentifiers(templateId, requestId, createdIdentifiers, false);
        return this.buildSuccessfulResponseDocument(clinicalDataDocument);
    }

    protected Document buildSimpleClinicalDataDocument(String templateId, String requestId) {
        Document clinicalDataDocument = this.clinicalDataResponse.buildEmptyClinicalDocument(templateId, requestId, false);
        return this.buildSuccessfulResponseDocument(clinicalDataDocument);
    }

    protected Document buildSuccessfulResponseDocument(Document clinicalDataDocument) {
        Element clinicalDataElement = clinicalDataDocument.getRootElement();
        clinicalDataElement.addElement("errorSection");
        return clinicalDataDocument;
    }

    @Required
    public void setClinicalDataResponse(ClinicalDataResponseInterface clinicalDataResponse) {
        this.clinicalDataResponse = clinicalDataResponse;
    }

    @Required
    public void setCreatedIdentifierResponseTemplates(List<String> createdIdentifierResponseTemplates) {
        this.createdIdentifierResponseTemplates = createdIdentifierResponseTemplates;
    }
}

